/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.rest.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.analytics.reports.rest.dto.v1_0.AssetMetric;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class AnalyticsCloudClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsCloudClient.class);
    private final Http _http;

    public AnalyticsCloudClient(Http http) {
        this._http = http;
    }

    public AssetMetric getAssetMetric(AnalyticsConfiguration analyticsConfiguration, String assetId, String assetType, Long channelId, Integer rangeKey, String[] selectedMetrics) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            String url = String.join((CharSequence)"", analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/api/1.0/asset-metric/", assetType);
            url = HttpComponentsUtil.addParameter((String)url, (String)"assetId", (String)assetId);
            url = HttpComponentsUtil.addParameter((String)url, (String)"channelId", (long)channelId);
            if (rangeKey != null) {
                url = HttpComponentsUtil.addParameter((String)url, (String)"rangeKey", (int)rangeKey);
            }
            url = HttpComponentsUtil.addParameter((String)url, (String)"selectedMetrics", (String)StringUtil.merge((Object[])selectedMetrics, (String)","));
            options.setLocation(url);
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                AssetMetric assetMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(AssetMetric.class));
                    assetMetric = (AssetMetric)objectReader.readValue(jsonNode);
                }
                return assetMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get asset metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get analytics channels page", (Throwable)exception);
        }
    }

    private Http.Options _getOptions(AnalyticsConfiguration analyticsConfiguration) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature());
        options.addHeader("OSB-Asah-Project-ID", analyticsConfiguration.liferayAnalyticsProjectId());
        return options;
    }

    private static class ObjectMapperHolder {
        private static final ObjectMapper _objectMapper = new ObjectMapper(){
            {
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            }
        };

        private ObjectMapperHolder() {
        }
    }
}

