/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.rest.client.json;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public abstract class BaseJSONParser<T> {
    public static final String[][] JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\\\\"}, {"\"", "\\\""}, {"\b", "\\b"}, {"\f", "\\f"}, {"\n", "\\n"}, {"\r", "\\r"}, {"\t", "\\t"}};
    private Stack<Integer> _captureStartStack;
    private DateFormat _dateFormat;
    private int _index;
    private String _json;
    private char _lastChar;

    public T parseToDTO(String json) {
        if (json == null) {
            throw new IllegalArgumentException("JSON is null");
        }
        this._init(json);
        this._assertStartsWithAndEndsWith("{", "}");
        T dto = this.createDTO();
        if (this._isEmpty()) {
            return dto;
        }
        this._readNextChar();
        this._readWhileLastCharIsWhiteSpace();
        this._readNextChar();
        if (this._isLastChar('}')) {
            this._readWhileLastCharIsWhiteSpace();
            if (!this._isEndOfJSON()) {
                this._readNextChar();
                throw new IllegalArgumentException("Expected end of JSON, but found '" + this._lastChar + "'");
            }
            return dto;
        }
        do {
            this._readWhileLastCharIsWhiteSpace();
            String fieldName = this._readValueAsString();
            this._readWhileLastCharIsWhiteSpace();
            this._assertLastChar(':');
            this._readNextChar();
            this._readWhileLastCharIsWhiteSpace();
            this.setField(dto, fieldName, this._readValue(this.parseMaps(fieldName)));
            this._readWhileLastCharIsWhiteSpace();
        } while (this._ifLastCharMatchesThenRead(','));
        return dto;
    }

    public T[] parseToDTOs(String json) {
        if (json == null) {
            throw new IllegalArgumentException("JSON is null");
        }
        this._init(json);
        this._assertStartsWithAndEndsWith("[", "]");
        if (this._isEmpty()) {
            return this.createDTOArray(0);
        }
        this._readNextChar();
        this._readWhileLastCharIsWhiteSpace();
        if (this._isLastChar(']')) {
            this._readNextChar();
            return this.createDTOArray(0);
        }
        this._readWhileLastCharIsWhiteSpace();
        Object[] objects = (Object[])this._readValue();
        T[] dtos = this.createDTOArray(objects.length);
        for (int i = 0; i < dtos.length; ++i) {
            dtos[i] = this.parseToDTO((String)objects[i]);
        }
        return dtos;
    }

    public Map<String, Object> parseToMap(String json) {
        if (json == null) {
            throw new IllegalArgumentException("JSON is null");
        }
        this._init(json);
        this._assertStartsWithAndEndsWith("{", "}");
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        this._setCaptureStart();
        this._readNextChar();
        this._readNextChar();
        this._readWhileLastCharIsWhiteSpace();
        if (this._isLastChar('}')) {
            return map;
        }
        do {
            this._readWhileLastCharIsWhiteSpace();
            String key = this._readValueAsString();
            this._readWhileLastCharIsWhiteSpace();
            if (!this._ifLastCharMatchesThenRead(':')) {
                throw new IllegalArgumentException("Expected ':'");
            }
            this._readWhileLastCharIsWhiteSpace();
            map.put(key, this._readValue(true));
            this._readWhileLastCharIsWhiteSpace();
        } while (this._ifLastCharMatchesThenRead(','));
        this._readWhileLastCharIsWhiteSpace();
        if (!this._ifLastCharMatchesThenRead('}')) {
            throw new IllegalArgumentException("Expected either ',' or '}', but found '" + this._lastChar + "'");
        }
        return map;
    }

    protected abstract T createDTO();

    protected abstract T[] createDTOArray(int var1);

    protected abstract boolean parseMaps(String var1);

    protected abstract void setField(T var1, String var2, Object var3);

    protected BigDecimal[] toBigDecimals(Object[] objects) {
        BigDecimal[] bigdecimals = new BigDecimal[objects.length];
        for (int i = 0; i < bigdecimals.length; ++i) {
            bigdecimals[i] = new BigDecimal(objects[i].toString());
        }
        return bigdecimals;
    }

    protected Date toDate(String string) {
        try {
            return this._dateFormat.parse(string);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Unable to parse date from " + string, pe);
        }
    }

    protected Date[] toDates(Object[] objects) {
        Date[] dates = new Date[objects.length];
        for (int i = 0; i < dates.length; ++i) {
            dates[i] = this.toDate((String)objects[i]);
        }
        return dates;
    }

    protected Integer[] toIntegers(Object[] objects) {
        Integer[] integers = new Integer[objects.length];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = Integer.valueOf(objects[i].toString());
        }
        return integers;
    }

    protected Long[] toLongs(Object[] objects) {
        Long[] longs = new Long[objects.length];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = Long.valueOf(objects[i].toString());
        }
        return longs;
    }

    protected String toString(Date date) {
        return this._dateFormat.format(date);
    }

    protected String[] toStrings(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)objects[i];
        }
        return strings;
    }

    private void _assertLastChar(char c) {
        if (this._lastChar != c) {
            throw new IllegalArgumentException(String.format("Expected last char '%s', but found '%s'", Character.valueOf(c), Character.valueOf(this._lastChar)));
        }
    }

    private void _assertStartsWithAndEndsWith(String prefix, String sufix) {
        if (!this._json.startsWith(prefix)) {
            throw new IllegalArgumentException(String.format("Expected starts with '%s', but found '%s' in '%s'", prefix, Character.valueOf(this._json.charAt(0)), this._json));
        }
        if (!this._json.endsWith(sufix)) {
            throw new IllegalArgumentException(String.format("Expected ends with '%s', but found '%s' in '%s'", sufix, Character.valueOf(this._json.charAt(this._json.length() - 1)), this._json));
        }
    }

    private String _getCapturedJSONSubstring() {
        return this._json.substring(this._captureStartStack.pop(), this._index - 1);
    }

    private String _getCapturedSubstring() {
        return this._unescape(this._getCapturedJSONSubstring());
    }

    private boolean _ifLastCharMatchesThenRead(char ch) {
        if (this._lastChar != ch) {
            return false;
        }
        this._readNextChar();
        return true;
    }

    private void _init(String json) {
        this._captureStartStack = new Stack();
        this._dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        this._index = 0;
        this._json = json.trim();
        this._lastChar = '\u0000';
    }

    private boolean _isCharEscaped(String string, int index) {
        int backslashCount = 0;
        while (index - 1 - backslashCount >= 0 && string.charAt(index - 1 - backslashCount) == '\\') {
            ++backslashCount;
        }
        return backslashCount % 2 != 0;
    }

    private boolean _isEmpty() {
        String substring = this._json.substring(1, this._json.length() - 1);
        substring = substring.trim();
        return substring.isEmpty();
    }

    private boolean _isEndOfJSON() {
        return this._index == this._json.length();
    }

    private boolean _isLastChar(char c) {
        return this._lastChar == c;
    }

    private boolean _isLastCharDecimalSeparator() {
        return this._lastChar == '.';
    }

    private boolean _isLastCharDigit() {
        return this._lastChar >= '0' && this._lastChar <= '9';
    }

    private boolean _isLastCharNegative() {
        return this._lastChar == '-';
    }

    private boolean _isLastCharPositive() {
        return this._lastChar == '+';
    }

    private boolean _isLastCharScientificNotation() {
        return this._lastChar == 'E';
    }

    private void _readNextChar() {
        if (!this._isEndOfJSON()) {
            this._lastChar = this._json.charAt(this._index++);
        }
    }

    private Object _readValue() {
        return this._readValue(false);
    }

    private Object _readValue(boolean parseMaps) {
        if (this._lastChar == '[') {
            return this._readValueAsArray(parseMaps);
        }
        if (this._lastChar == 'f') {
            return this._readValueAsBooleanFalse();
        }
        if (this._lastChar == 't') {
            return this._readValueAsBooleanTrue();
        }
        if (this._lastChar == 'n') {
            return this._readValueAsObjectNull();
        }
        if (this._lastChar == '\"') {
            return this._readValueAsString();
        }
        if (parseMaps && this._lastChar == '{') {
            try {
                Class<?> clazz = this.getClass();
                BaseJSONParser baseJSONParser = (BaseJSONParser)clazz.newInstance();
                return baseJSONParser.parseToMap(this._readValueAsStringJSON());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Expected JSON object or map");
            }
        }
        if (this._lastChar == '{') {
            return this._readValueAsStringJSON();
        }
        if (this._lastChar == '-' || this._lastChar == '0' || this._lastChar == '1' || this._lastChar == '2' || this._lastChar == '3' || this._lastChar == '4' || this._lastChar == '5' || this._lastChar == '6' || this._lastChar == '7' || this._lastChar == '8' || this._lastChar == '9') {
            return this._readValueAsStringNumber();
        }
        throw new IllegalArgumentException();
    }

    private Object[] _readValueAsArray(boolean parseMaps) {
        ArrayList<Object> objects = new ArrayList<Object>();
        this._readNextChar();
        this._readWhileLastCharIsWhiteSpace();
        if (this._isLastChar(']')) {
            this._readNextChar();
            return objects.toArray();
        }
        do {
            this._readWhileLastCharIsWhiteSpace();
            objects.add(this._readValue(parseMaps));
            this._readWhileLastCharIsWhiteSpace();
        } while (this._ifLastCharMatchesThenRead(','));
        if (!this._isLastChar(']')) {
            throw new IllegalArgumentException("Expected ']', but found '" + this._lastChar + "'");
        }
        this._readNextChar();
        return objects.toArray();
    }

    private boolean _readValueAsBooleanFalse() {
        this._readNextChar();
        this._assertLastChar('a');
        this._readNextChar();
        this._assertLastChar('l');
        this._readNextChar();
        this._assertLastChar('s');
        this._readNextChar();
        this._assertLastChar('e');
        this._readNextChar();
        return false;
    }

    private boolean _readValueAsBooleanTrue() {
        this._readNextChar();
        this._assertLastChar('r');
        this._readNextChar();
        this._assertLastChar('u');
        this._readNextChar();
        this._assertLastChar('e');
        this._readNextChar();
        return true;
    }

    private Object _readValueAsObjectNull() {
        this._readNextChar();
        this._assertLastChar('u');
        this._readNextChar();
        this._assertLastChar('l');
        this._readNextChar();
        this._assertLastChar('l');
        this._readNextChar();
        return null;
    }

    private String _readValueAsString() {
        this._readNextChar();
        this._setCaptureStart();
        while (this._lastChar != '\"' || this._isCharEscaped(this._json, this._index - 1)) {
            this._readNextChar();
        }
        String string = this._getCapturedSubstring();
        this._readNextChar();
        return string;
    }

    private String _readValueAsStringJSON() {
        this._setCaptureStart();
        this._readNextChar();
        if (this._isLastChar('}')) {
            this._readNextChar();
            return this._getCapturedJSONSubstring();
        }
        this._readWhileLastCharIsWhiteSpace();
        if (this._isLastChar('}')) {
            this._readNextChar();
            return this._getCapturedJSONSubstring();
        }
        do {
            this._readWhileLastCharIsWhiteSpace();
            this._readValueAsString();
            this._readWhileLastCharIsWhiteSpace();
            if (!this._ifLastCharMatchesThenRead(':')) {
                throw new IllegalArgumentException("Expected ':'");
            }
            this._readWhileLastCharIsWhiteSpace();
            this._readValue();
            this._readWhileLastCharIsWhiteSpace();
        } while (this._ifLastCharMatchesThenRead(','));
        this._readWhileLastCharIsWhiteSpace();
        if (!this._ifLastCharMatchesThenRead('}')) {
            throw new IllegalArgumentException("Expected either ',' or '}', but found '" + this._lastChar + "'");
        }
        return this._getCapturedJSONSubstring();
    }

    private String _readValueAsStringNumber() {
        this._setCaptureStart();
        do {
            this._readNextChar();
        } while (this._isLastCharDigit() || this._isLastCharDecimalSeparator() || this._isLastCharNegative() || this._isLastCharPositive() || this._isLastCharScientificNotation());
        return this._getCapturedSubstring();
    }

    private void _readWhileLastCharIsWhiteSpace() {
        while (this._lastChar == ' ' || this._lastChar == '\n' || this._lastChar == '\r' || this._lastChar == '\t') {
            this._readNextChar();
        }
    }

    private void _setCaptureStart() {
        this._captureStartStack.push(this._index - 1);
    }

    private String _unescape(String string) {
        for (int i = JSON_ESCAPE_STRINGS.length - 1; i >= 0; --i) {
            String[] escapeStrings = JSON_ESCAPE_STRINGS[i];
            int index = string.indexOf(escapeStrings[1]);
            while (index != -1) {
                if (!this._isCharEscaped(string, index)) {
                    string = string.substring(0, index) + escapeStrings[0] + string.substring(index + escapeStrings[1].length());
                    index = string.indexOf(escapeStrings[1], index + escapeStrings[0].length());
                    continue;
                }
                index = string.indexOf(escapeStrings[1], index + escapeStrings[1].length());
            }
        }
        return string;
    }
}

