/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.reports.rest.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.analytics.reports.rest.dto.v1_0.Trend;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Metric")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Metric")
public class Metric
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String metricType;
    @JsonIgnore
    private Supplier<String> _metricTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double previousValue;
    @JsonIgnore
    private Supplier<Double> _previousValueSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String previousValueKey;
    @JsonIgnore
    private Supplier<String> _previousValueKeySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Trend trend;
    @JsonIgnore
    private Supplier<Trend> _trendSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double value;
    @JsonIgnore
    private Supplier<Double> _valueSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String valueKey;
    @JsonIgnore
    private Supplier<String> _valueKeySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.analytics.reports.rest.dto.v1_0.Metric", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Metric toDTO(String json) {
        return (Metric)ObjectMapperUtil.readValue(Metric.class, (String)json);
    }

    public static Metric unsafeToDTO(String json) {
        return (Metric)ObjectMapperUtil.unsafeReadValue(Metric.class, (String)json);
    }

    @Schema
    public String getMetricType() {
        if (this._metricTypeSupplier != null) {
            this.metricType = this._metricTypeSupplier.get();
            this._metricTypeSupplier = null;
        }
        return this.metricType;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
        this._metricTypeSupplier = null;
    }

    @JsonIgnore
    public void setMetricType(UnsafeSupplier<String, Exception> metricTypeUnsafeSupplier) {
        this._metricTypeSupplier = () -> {
            try {
                return (String)metricTypeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Double getPreviousValue() {
        if (this._previousValueSupplier != null) {
            this.previousValue = this._previousValueSupplier.get();
            this._previousValueSupplier = null;
        }
        return this.previousValue;
    }

    public void setPreviousValue(Double previousValue) {
        this.previousValue = previousValue;
        this._previousValueSupplier = null;
    }

    @JsonIgnore
    public void setPreviousValue(UnsafeSupplier<Double, Exception> previousValueUnsafeSupplier) {
        this._previousValueSupplier = () -> {
            try {
                return (Double)previousValueUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getPreviousValueKey() {
        if (this._previousValueKeySupplier != null) {
            this.previousValueKey = this._previousValueKeySupplier.get();
            this._previousValueKeySupplier = null;
        }
        return this.previousValueKey;
    }

    public void setPreviousValueKey(String previousValueKey) {
        this.previousValueKey = previousValueKey;
        this._previousValueKeySupplier = null;
    }

    @JsonIgnore
    public void setPreviousValueKey(UnsafeSupplier<String, Exception> previousValueKeyUnsafeSupplier) {
        this._previousValueKeySupplier = () -> {
            try {
                return (String)previousValueKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Trend getTrend() {
        if (this._trendSupplier != null) {
            this.trend = this._trendSupplier.get();
            this._trendSupplier = null;
        }
        return this.trend;
    }

    public void setTrend(Trend trend) {
        this.trend = trend;
        this._trendSupplier = null;
    }

    @JsonIgnore
    public void setTrend(UnsafeSupplier<Trend, Exception> trendUnsafeSupplier) {
        this._trendSupplier = () -> {
            try {
                return (Trend)trendUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Double getValue() {
        if (this._valueSupplier != null) {
            this.value = this._valueSupplier.get();
            this._valueSupplier = null;
        }
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
        this._valueSupplier = null;
    }

    @JsonIgnore
    public void setValue(UnsafeSupplier<Double, Exception> valueUnsafeSupplier) {
        this._valueSupplier = () -> {
            try {
                return (Double)valueUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getValueKey() {
        if (this._valueKeySupplier != null) {
            this.valueKey = this._valueKeySupplier.get();
            this._valueKeySupplier = null;
        }
        return this.valueKey;
    }

    public void setValueKey(String valueKey) {
        this.valueKey = valueKey;
        this._valueKeySupplier = null;
    }

    @JsonIgnore
    public void setValueKey(UnsafeSupplier<String, Exception> valueKeyUnsafeSupplier) {
        this._valueKeySupplier = () -> {
            try {
                return (String)valueKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)object;
        return Objects.equals(this.toString(), metric.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String valueKey;
        Double value;
        Trend trend;
        String previousValueKey;
        Double previousValue;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String metricType = this.getMetricType();
        if (metricType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"metricType\": ");
            sb.append("\"");
            sb.append(Metric._escape(metricType));
            sb.append("\"");
        }
        if ((previousValue = this.getPreviousValue()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousValue\": ");
            sb.append((Object)previousValue);
        }
        if ((previousValueKey = this.getPreviousValueKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"previousValueKey\": ");
            sb.append("\"");
            sb.append(Metric._escape(previousValueKey));
            sb.append("\"");
        }
        if ((trend = this.getTrend()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"trend\": ");
            sb.append(String.valueOf(trend));
        }
        if ((value = this.getValue()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"value\": ");
            sb.append((Object)value);
        }
        if ((valueKey = this.getValueKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"valueKey\": ");
            sb.append("\"");
            sb.append(Metric._escape(valueKey));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Metric._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Metric._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Metric._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Metric._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Metric._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

