/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.depot.entry.util;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DepotEntryUtil {
    private static final Log _log = LogFactoryUtil.getLog(DepotEntryUtil.class);
    private static final Snapshot<DepotEntryGroupRelLocalService> _depotEntryGroupRelLocalServiceSnapshot = new Snapshot(DepotEntryUtil.class, DepotEntryGroupRelLocalService.class);
    private static final Snapshot<DepotEntryService> _depotEntryServiceSnapshot = new Snapshot(DepotEntryUtil.class, DepotEntryService.class);

    public static List<DepotEntry> getDepotEntries(long companyId, Long depotEntryId) throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        DepotEntryService depotEntryService = (DepotEntryService)_depotEntryServiceSnapshot.get();
        if (depotEntryId == null) {
            depotEntries.addAll(DepotEntryUtil._getViewableDepotEntries(companyId, depotEntryService));
        } else {
            depotEntries.add(depotEntryService.getDepotEntry(depotEntryId.longValue()));
        }
        return depotEntries;
    }

    public static Long[] getGroupIds(List<DepotEntry> depotEntries) {
        Object[] groupIds = new Long[]{};
        DepotEntryGroupRelLocalService depotEntryGroupRelLocalService = (DepotEntryGroupRelLocalService)_depotEntryGroupRelLocalServiceSnapshot.get();
        for (DepotEntry depotEntry : depotEntries) {
            groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntry.getGroupId());
            List depotEntryGroupRels = depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
            for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntryGroupRel.getGroupId());
            }
        }
        return groupIds;
    }

    private static List<DepotEntry> _getViewableDepotEntries(long companyId, DepotEntryService depotEntryService) throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DepotEntry.class.getName(), null, (Pagination)Pagination.of((int)-1, (int)-1), queryConfig -> {}, searchContext -> searchContext.setCompanyId(companyId), null, document -> {
            block2: {
                try {
                    depotEntries.add(depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
                }
                catch (PortalException portalException) {
                    if (!_log.isInfoEnabled()) break block2;
                    _log.info((Object)("User does not have access to view space " + document.get("entryClassPK")), (Throwable)portalException);
                }
            }
            return null;
        });
        return depotEntries;
    }
}

