/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.resource.v1_0.factory;

import com.liferay.analytics.cms.rest.internal.security.permission.LiberalPermissionChecker;
import com.liferay.analytics.cms.rest.resource.v1_0.OverviewResource;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(property={"resource.locator.key=/analytics-cms-rest/v1.0/Overview"}, service={OverviewResource.Factory.class})
public class OverviewResourceFactoryImpl
implements OverviewResource.Factory {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private ComponentServiceObjects<OverviewResource> _componentServiceObjects;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private UserLocalService _userLocalService;

    public OverviewResource.Builder create() {
        return new OverviewResource.Builder(){
            private boolean _checkPermissions = true;
            private HttpServletRequest _httpServletRequest;
            private HttpServletResponse _httpServletResponse;
            private Locale _preferredLocale;
            private UriInfo _uriInfo;
            private User _user;

            public OverviewResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                Function<InvocationHandler, OverviewResource> overviewResourceProxyProviderFunction = ResourceProxyProviderFunctionHolder._overviewResourceProxyProviderFunction;
                return overviewResourceProxyProviderFunction.apply((proxy, method, arguments) -> OverviewResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._httpServletRequest, this._httpServletResponse, this._preferredLocale, this._uriInfo, this._user));
            }

            public OverviewResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public OverviewResource.Builder httpServletRequest(HttpServletRequest httpServletRequest) {
                this._httpServletRequest = httpServletRequest;
                return this;
            }

            public OverviewResource.Builder httpServletResponse(HttpServletResponse httpServletResponse) {
                this._httpServletResponse = httpServletResponse;
                return this;
            }

            public OverviewResource.Builder preferredLocale(Locale preferredLocale) {
                this._preferredLocale = preferredLocale;
                return this;
            }

            public OverviewResource.Builder uriInfo(UriInfo uriInfo) {
                this._uriInfo = uriInfo;
                return this;
            }

            public OverviewResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    private static Function<InvocationHandler, OverviewResource> _getProxyProviderFunction() {
        Class proxyClass = ProxyUtil.getProxyClass((ClassLoader)OverviewResource.class.getClassLoader(), (Class[])new Class[]{OverviewResource.class});
        try {
            Constructor constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (OverviewResource)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new InternalError(reflectiveOperationException);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException);
        }
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale preferredLocale, UriInfo uriInfo, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)new LiberalPermissionChecker(user));
        }
        OverviewResource overviewResource = (OverviewResource)this._componentServiceObjects.getService();
        overviewResource.setContextAcceptLanguage((AcceptLanguage)new AcceptLanguageImpl(httpServletRequest, preferredLocale, user));
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        overviewResource.setContextCompany(company);
        overviewResource.setContextHttpServletRequest(httpServletRequest);
        overviewResource.setContextHttpServletResponse(httpServletResponse);
        overviewResource.setContextUriInfo(uriInfo);
        overviewResource.setContextUser(user);
        overviewResource.setExpressionConvert(this._expressionConvert);
        overviewResource.setFilterParserProvider(this._filterParserProvider);
        overviewResource.setGroupLocalService(this._groupLocalService);
        overviewResource.setResourceActionLocalService(this._resourceActionLocalService);
        overviewResource.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        overviewResource.setRoleLocalService(this._roleLocalService);
        overviewResource.setSortParserProvider(this._sortParserProvider);
        try {
            Object object = method.invoke((Object)overviewResource, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            this._componentServiceObjects.ungetService((Object)overviewResource);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private class AcceptLanguageImpl
    implements AcceptLanguage {
        private final HttpServletRequest _httpServletRequest;
        private final Locale _preferredLocale;
        private final User _user;

        public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Locale preferredLocale, User user) {
            this._httpServletRequest = httpServletRequest;
            this._preferredLocale = preferredLocale;
            this._user = user;
        }

        public List<Locale> getLocales() {
            return Arrays.asList(this.getPreferredLocale());
        }

        public String getPreferredLanguageId() {
            return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
        }

        public Locale getPreferredLocale() {
            Locale locale;
            if (this._preferredLocale != null) {
                return this._preferredLocale;
            }
            if (this._httpServletRequest != null && (locale = (Locale)this._httpServletRequest.getAttribute("LOCALE")) != null) {
                return locale;
            }
            return this._user.getLocale();
        }

        public boolean isAcceptAllLanguages() {
            return false;
        }
    }

    private static class ResourceProxyProviderFunctionHolder {
        private static final Function<InvocationHandler, OverviewResource> _overviewResourceProxyProviderFunction = OverviewResourceFactoryImpl._getProxyProviderFunction();

        private ResourceProxyProviderFunctionHolder() {
        }
    }
}

