/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.resource.v1_0;

import com.liferay.analytics.cms.rest.dto.v1_0.InventoryAnalysis;
import com.liferay.analytics.cms.rest.dto.v1_0.InventoryAnalysisItem;
import com.liferay.analytics.cms.rest.internal.resource.v1_0.BaseInventoryAnalysisResourceImpl;
import com.liferay.analytics.cms.rest.resource.v1_0.InventoryAnalysisResource;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelTable;
import com.liferay.asset.kernel.model.AssetCategoryTable;
import com.liferay.asset.kernel.model.AssetEntries_AssetTagsTable;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.model.AssetTagGroupRelTable;
import com.liferay.asset.kernel.model.AssetTagTable;
import com.liferay.asset.kernel.model.AssetVocabularyGroupRelTable;
import com.liferay.asset.kernel.model.AssetVocabularyTable;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.object.model.ObjectDefinitionTable;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectEntryVersionTable;
import com.liferay.object.model.ObjectFolderTable;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunction;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunctionType;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/inventory-analysis.properties"}, scope=ServiceScope.PROTOTYPE, service={InventoryAnalysisResource.class})
public class InventoryAnalysisResourceImpl
extends BaseInventoryAnalysisResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(InventoryAnalysisResourceImpl.class);
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private Localization _localization;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    @Override
    public InventoryAnalysis getInventoryAnalysis(Long categoryId, Long depotEntryId, String groupBy, String languageId, String rangeEnd, Integer rangeKey, String rangeStart, Long structureId, Long tagId, Long vocabularyId, Pagination pagination) throws Exception {
        InventoryAnalysis inventoryAnalysis = new InventoryAnalysis();
        Long[] groupIds = this._getGroupIds(this._getDepotEntries(depotEntryId));
        inventoryAnalysis.setInventoryAnalysisItems(() -> this.transformToArray((List)this._objectEntryLocalService.dslQuery(this._getGroupByStep(categoryId, DSLQueryFactoryUtil.select(this._getSelectExpressions(groupBy)), groupIds, languageId, rangeEnd, rangeKey, rangeStart, structureId, tagId, vocabularyId).groupBy(this._getGroupByExpressions(groupBy)).orderBy(new OrderByExpression[]{DSLFunctionFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).descending()}).limit(pagination.getStartPosition(), pagination.getEndPosition())), object -> {
            InventoryAnalysisItem inventoryAnalysisItem = new InventoryAnalysisItem();
            inventoryAnalysisItem.setCount(() -> (Long)object[0]);
            inventoryAnalysisItem.setKey(() -> (String)object[1]);
            inventoryAnalysisItem.setTitle(() -> GetterUtil.get((String)this._localization.getLocalization((String)object[2], this.contextAcceptLanguage.getPreferredLocale().toString()), (String)LanguageUtil.get((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"unknown")));
            return inventoryAnalysisItem;
        }, InventoryAnalysisItem.class));
        inventoryAnalysis.setTotalCount(() -> this._objectEntryLocalService.dslQueryCount((DSLQuery)this._getGroupByStep(categoryId, DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId), groupIds, languageId, rangeEnd, rangeKey, rangeStart, structureId, tagId, vocabularyId)));
        return inventoryAnalysis;
    }

    private DateFormat _getDateFormat() {
        return DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
    }

    private List<DepotEntry> _getDepotEntries(Long depotEntryId) throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        if (depotEntryId == null) {
            depotEntries.addAll(this._getViewableDepotEntries());
        } else {
            depotEntries.add(this._depotEntryService.getDepotEntry(depotEntryId.longValue()));
        }
        return depotEntries;
    }

    private Date _getEndDate(String rangeEnd) {
        try {
            Calendar calendar = Calendar.getInstance();
            DateFormat dateFormat = this._getDateFormat();
            calendar.setTime(dateFormat.parse(rangeEnd));
            calendar.set(11, 23);
            calendar.set(14, 59);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            return null;
        }
    }

    private Expression<?>[] _getGroupByExpressions(String groupBy) {
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"category")) {
            return new Expression[]{AssetCategoryTable.INSTANCE.externalReferenceCode, AssetCategoryTable.INSTANCE.name};
        }
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"tag")) {
            return new Expression[]{AssetTagTable.INSTANCE.externalReferenceCode, AssetTagTable.INSTANCE.name};
        }
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"vocabulary")) {
            return new Expression[]{AssetVocabularyTable.INSTANCE.externalReferenceCode, AssetVocabularyTable.INSTANCE.name};
        }
        return new Expression[]{ObjectDefinitionTable.INSTANCE.externalReferenceCode, ObjectDefinitionTable.INSTANCE.label};
    }

    private GroupByStep _getGroupByStep(Long categoryId, FromStep fromStep, Long[] groupIds, String languageId, String rangeEnd, Integer rangeKey, String rangeStart, Long structureId, Long tagId, Long vocabularyId) {
        AssetCategoryTable assetCategoryTable = AssetCategoryTable.INSTANCE;
        AssetEntries_AssetTagsTable assetEntriesAssetTagsTable = AssetEntries_AssetTagsTable.INSTANCE;
        AssetEntryAssetCategoryRelTable assetEntryAssetCategoryRelTable = AssetEntryAssetCategoryRelTable.INSTANCE;
        AssetEntryTable assetEntryTable = AssetEntryTable.INSTANCE;
        AssetTagGroupRelTable assetTagGroupRelTable = AssetTagGroupRelTable.INSTANCE;
        AssetTagTable assetTagTable = AssetTagTable.INSTANCE;
        AssetVocabularyGroupRelTable assetVocabularyGroupRelTable = AssetVocabularyGroupRelTable.INSTANCE;
        AssetVocabularyTable assetVocabularyTable = AssetVocabularyTable.INSTANCE;
        ObjectDefinitionTable objectDefinitionTable = ObjectDefinitionTable.INSTANCE;
        ObjectEntryTable objectEntryTable = ObjectEntryTable.INSTANCE;
        ObjectEntryVersionTable objectEntryVersionTable = ObjectEntryVersionTable.INSTANCE;
        ObjectFolderTable objectFolderTable = ObjectFolderTable.INSTANCE;
        Object[] assetGroupIds = groupIds;
        if (ArrayUtil.isNotEmpty((Object[])groupIds)) {
            assetGroupIds = (Long[])ArrayUtil.append((Object[])assetGroupIds, (Object)-1L);
        }
        return fromStep.from((Table)objectFolderTable).innerJoinON((Table)objectDefinitionTable, objectDefinitionTable.objectFolderId.eq((Expression)objectFolderTable.objectFolderId)).innerJoinON((Table)objectEntryTable, objectEntryTable.objectDefinitionId.eq((Expression)objectDefinitionTable.objectDefinitionId)).innerJoinON((Table)objectEntryVersionTable, objectEntryVersionTable.objectEntryId.eq((Expression)objectEntryTable.objectEntryId).and((Expression)objectEntryVersionTable.version.eq((Expression)objectEntryTable.version)).and((Expression)objectEntryVersionTable.status.eq((Object)0))).innerJoinON((Table)assetEntryTable, assetEntryTable.classPK.eq((Expression)objectEntryTable.objectEntryId)).leftJoinOn((Table)assetEntriesAssetTagsTable, assetEntriesAssetTagsTable.entryId.eq((Expression)assetEntryTable.entryId)).leftJoinOn((Table)assetTagTable, assetTagTable.tagId.eq((Expression)assetEntriesAssetTagsTable.tagId)).leftJoinOn((Table)assetTagGroupRelTable, assetTagGroupRelTable.tagId.eq((Expression)assetTagTable.tagId).and((Expression)assetTagGroupRelTable.groupId.in(assetGroupIds))).leftJoinOn((Table)assetEntryAssetCategoryRelTable, assetEntryAssetCategoryRelTable.assetEntryId.eq((Expression)assetEntryTable.entryId)).leftJoinOn((Table)assetCategoryTable, assetCategoryTable.categoryId.eq((Expression)assetEntryAssetCategoryRelTable.assetCategoryId)).leftJoinOn((Table)assetVocabularyTable, assetVocabularyTable.vocabularyId.eq((Expression)assetCategoryTable.vocabularyId)).leftJoinOn((Table)assetVocabularyGroupRelTable, assetVocabularyGroupRelTable.vocabularyId.eq((Expression)assetVocabularyTable.vocabularyId).and((Expression)assetVocabularyGroupRelTable.groupId.in(assetGroupIds))).where(this._getPredicate(categoryId, groupIds, languageId, rangeEnd, rangeKey, rangeStart, structureId, tagId, vocabularyId));
    }

    private Long[] _getGroupIds(List<DepotEntry> depotEntries) {
        Object[] groupIds = new Long[]{};
        for (DepotEntry depotEntry : depotEntries) {
            groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntry.getGroupId());
            List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
            for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                groupIds = (Long[])ArrayUtil.append((Object[])groupIds, (Object)depotEntryGroupRel.getGroupId());
            }
        }
        return groupIds;
    }

    private Predicate _getPredicate(Long categoryId, Long[] groupIds, String languageId, String rangeEnd, Integer rangeKey, String rangeStart, Long structureId, Long tagId, Long vocabularyId) {
        Predicate predicate = ObjectFolderTable.INSTANCE.externalReferenceCode.eq((Object)"L_CMS_CONTENT_STRUCTURES");
        predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.status.neq((Object)8));
        if (categoryId != null) {
            predicate = predicate.and((Expression)AssetEntryAssetCategoryRelTable.INSTANCE.assetCategoryId.eq((Object)categoryId));
        }
        if (ArrayUtil.isNotEmpty((Object[])groupIds)) {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.groupId.in((Object[])groupIds));
        }
        if (Validator.isNotNull((String)languageId)) {
            predicate = predicate.and((Expression)this._getPropertyValueExpression((Expression)ObjectEntryVersionTable.INSTANCE.content, "$.properties").like("%\"" + languageId + "\":%"));
        }
        if (Validator.isNotNull((String)rangeStart)) {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.createDate.gte((Object)this._getStartDate(rangeKey, rangeStart)));
        }
        if (Validator.isNotNull((String)rangeEnd)) {
            predicate = predicate.and((Expression)ObjectEntryTable.INSTANCE.createDate.lte((Object)this._getEndDate(rangeEnd)));
        }
        if (structureId != null) {
            predicate = predicate.and((Expression)ObjectDefinitionTable.INSTANCE.objectDefinitionId.eq((Object)structureId));
        }
        if (tagId != null) {
            predicate = predicate.and((Expression)AssetTagGroupRelTable.INSTANCE.tagId.eq((Object)tagId));
        }
        if (vocabularyId != null) {
            predicate = predicate.and((Expression)AssetVocabularyGroupRelTable.INSTANCE.vocabularyId.eq((Object)vocabularyId));
        }
        return predicate;
    }

    private <T> Expression<T> _getPropertyValueExpression(Expression<T> expression, String propertyName) {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MYSQL || db.getDBType() == DBType.MARIADB) {
            return new DSLFunction(new DSLFunctionType("JSON_EXTRACT(", ")"), new Expression[]{expression, new Scalar((Object)propertyName)});
        }
        return new DSLFunction(new DSLFunctionType("JSON_QUERY(", ")"), new Expression[]{expression, new Scalar((Object)propertyName)});
    }

    private Expression<?>[] _getSelectExpressions(String groupBy) {
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"category")) {
            return new Expression[]{DSLFunctionFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).as("count_"), AssetCategoryTable.INSTANCE.externalReferenceCode.as("key_"), AssetCategoryTable.INSTANCE.name.as("title")};
        }
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"tag")) {
            return new Expression[]{DSLFunctionFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).as("count_"), AssetTagTable.INSTANCE.externalReferenceCode.as("key_"), AssetTagTable.INSTANCE.name.as("title")};
        }
        if (StringUtil.equalsIgnoreCase((String)groupBy, (String)"vocabulary")) {
            return new Expression[]{DSLFunctionFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).as("count_"), AssetVocabularyTable.INSTANCE.externalReferenceCode.as("key_"), AssetVocabularyTable.INSTANCE.name.as("title")};
        }
        return new Expression[]{DSLFunctionFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).as("count_"), ObjectDefinitionTable.INSTANCE.externalReferenceCode.as("key_"), ObjectDefinitionTable.INSTANCE.label.as("title")};
    }

    private Date _getStartDate(Integer rangeKey, String rangeStart) {
        Calendar calendar = Calendar.getInstance();
        if (Validator.isNotNull((String)rangeStart)) {
            try {
                DateFormat dateFormat = this._getDateFormat();
                calendar.setTime(dateFormat.parse(rangeStart));
            }
            catch (ParseException parseException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)parseException);
                }
            }
        } else {
            calendar.add(5, -rangeKey.intValue());
        }
        calendar.set(11, 0);
        calendar.set(14, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private List<DepotEntry> _getViewableDepotEntries() throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DepotEntry.class.getName(), null, (Pagination)Pagination.of((int)-1, (int)-1), queryConfig -> {}, searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), null, document -> {
            block2: {
                try {
                    depotEntries.add(this._depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
                }
                catch (PortalException portalException) {
                    if (!_log.isInfoEnabled()) break block2;
                    _log.info((Object)("User does not have access to view space " + document.get("entryClassPK")), (Throwable)portalException);
                }
            }
            return null;
        });
        return depotEntries;
    }
}

