/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.analytics.cms.rest.client.serdes.v1_0;

import com.liferay.analytics.cms.rest.client.dto.v1_0.InventoryAnalysis;
import com.liferay.analytics.cms.rest.client.dto.v1_0.InventoryAnalysisItem;
import com.liferay.analytics.cms.rest.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Rachael Koestartyo
 * @generated
 */
@Generated("")
public class InventoryAnalysisSerDes {

	public static InventoryAnalysis toDTO(String json) {
		InventoryAnalysisJSONParser inventoryAnalysisJSONParser =
			new InventoryAnalysisJSONParser();

		return inventoryAnalysisJSONParser.parseToDTO(json);
	}

	public static InventoryAnalysis[] toDTOs(String json) {
		InventoryAnalysisJSONParser inventoryAnalysisJSONParser =
			new InventoryAnalysisJSONParser();

		return inventoryAnalysisJSONParser.parseToDTOs(json);
	}

	public static String toJSON(InventoryAnalysis inventoryAnalysis) {
		if (inventoryAnalysis == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (inventoryAnalysis.getInventoryAnalysisItems() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"inventoryAnalysisItems\": ");

			sb.append("[");

			for (int i = 0;
				 i < inventoryAnalysis.getInventoryAnalysisItems().length;
				 i++) {

				sb.append(
					String.valueOf(
						inventoryAnalysis.getInventoryAnalysisItems()[i]));

				if ((i + 1) <
						inventoryAnalysis.getInventoryAnalysisItems().length) {

					sb.append(", ");
				}
			}

			sb.append("]");
		}

		if (inventoryAnalysis.getTotalCount() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"totalCount\": ");

			sb.append(inventoryAnalysis.getTotalCount());
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		InventoryAnalysisJSONParser inventoryAnalysisJSONParser =
			new InventoryAnalysisJSONParser();

		return inventoryAnalysisJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(
		InventoryAnalysis inventoryAnalysis) {

		if (inventoryAnalysis == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (inventoryAnalysis.getInventoryAnalysisItems() == null) {
			map.put("inventoryAnalysisItems", null);
		}
		else {
			map.put(
				"inventoryAnalysisItems",
				String.valueOf(inventoryAnalysis.getInventoryAnalysisItems()));
		}

		if (inventoryAnalysis.getTotalCount() == null) {
			map.put("totalCount", null);
		}
		else {
			map.put(
				"totalCount",
				String.valueOf(inventoryAnalysis.getTotalCount()));
		}

		return map;
	}

	public static class InventoryAnalysisJSONParser
		extends BaseJSONParser<InventoryAnalysis> {

		@Override
		protected InventoryAnalysis createDTO() {
			return new InventoryAnalysis();
		}

		@Override
		protected InventoryAnalysis[] createDTOArray(int size) {
			return new InventoryAnalysis[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "inventoryAnalysisItems")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "totalCount")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			InventoryAnalysis inventoryAnalysis, String jsonParserFieldName,
			Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "inventoryAnalysisItems")) {
				if (jsonParserFieldValue != null) {
					Object[] jsonParserFieldValues =
						(Object[])jsonParserFieldValue;

					InventoryAnalysisItem[] inventoryAnalysisItemsArray =
						new InventoryAnalysisItem[jsonParserFieldValues.length];

					for (int i = 0; i < inventoryAnalysisItemsArray.length;
						 i++) {

						inventoryAnalysisItemsArray[i] =
							InventoryAnalysisItemSerDes.toDTO(
								(String)jsonParserFieldValues[i]);
					}

					inventoryAnalysis.setInventoryAnalysisItems(
						inventoryAnalysisItemsArray);
				}
			}
			else if (Objects.equals(jsonParserFieldName, "totalCount")) {
				if (jsonParserFieldValue != null) {
					inventoryAnalysis.setTotalCount(
						Long.valueOf((String)jsonParserFieldValue));
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}