/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/prediction_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Response message for [PredictionService.GenerateContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse}
 */
public final class GenerateContentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.GenerateContentResponse)
    GenerateContentResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateContentResponse.newBuilder() to construct.
  private GenerateContentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateContentResponse() {
    candidates_ = java.util.Collections.emptyList();
    modelVersion_ = "";
    responseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateContentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.GenerateContentResponse.class,
            com.google.cloud.vertexai.api.GenerateContentResponse.Builder.class);
  }

  public interface PromptFeedbackOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for blockReason.
     */
    int getBlockReasonValue();

    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The blockReason.
     */
    com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
        getBlockReason();

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.vertexai.api.SafetyRating> getSafetyRatingsList();

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.SafetyRating getSafetyRatings(int index);

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getSafetyRatingsCount();

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
        getSafetyRatingsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The blockReasonMessage.
     */
    java.lang.String getBlockReasonMessage();

    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for blockReasonMessage.
     */
    com.google.protobuf.ByteString getBlockReasonMessageBytes();
  }

  /**
   *
   *
   * <pre>
   * Content filter results for a prompt sent in the request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback}
   */
  public static final class PromptFeedback extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback)
      PromptFeedbackOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PromptFeedback.newBuilder() to construct.
    private PromptFeedback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PromptFeedback() {
      blockReason_ = 0;
      safetyRatings_ = java.util.Collections.emptyList();
      blockReasonMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PromptFeedback();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_PromptFeedback_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_PromptFeedback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.class,
              com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Blocked reason enumeration.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason}
     */
    public enum BlockedReason implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified blocked reason.
       * </pre>
       *
       * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
       */
      BLOCKED_REASON_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to safety.
       * </pre>
       *
       * <code>SAFETY = 1;</code>
       */
      SAFETY(1),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to other reason.
       * </pre>
       *
       * <code>OTHER = 2;</code>
       */
      OTHER(2),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to the terms which are included from the
       * terminology blocklist.
       * </pre>
       *
       * <code>BLOCKLIST = 3;</code>
       */
      BLOCKLIST(3),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to prohibited content.
       * </pre>
       *
       * <code>PROHIBITED_CONTENT = 4;</code>
       */
      PROHIBITED_CONTENT(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified blocked reason.
       * </pre>
       *
       * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
       */
      public static final int BLOCKED_REASON_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Candidates blocked due to safety.
       * </pre>
       *
       * <code>SAFETY = 1;</code>
       */
      public static final int SAFETY_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Candidates blocked due to other reason.
       * </pre>
       *
       * <code>OTHER = 2;</code>
       */
      public static final int OTHER_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Candidates blocked due to the terms which are included from the
       * terminology blocklist.
       * </pre>
       *
       * <code>BLOCKLIST = 3;</code>
       */
      public static final int BLOCKLIST_VALUE = 3;

      /**
       *
       *
       * <pre>
       * Candidates blocked due to prohibited content.
       * </pre>
       *
       * <code>PROHIBITED_CONTENT = 4;</code>
       */
      public static final int PROHIBITED_CONTENT_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BlockedReason valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static BlockedReason forNumber(int value) {
        switch (value) {
          case 0:
            return BLOCKED_REASON_UNSPECIFIED;
          case 1:
            return SAFETY;
          case 2:
            return OTHER;
          case 3:
            return BLOCKLIST;
          case 4:
            return PROHIBITED_CONTENT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<BlockedReason> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<BlockedReason>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<BlockedReason>() {
                public BlockedReason findValueByNumber(int number) {
                  return BlockedReason.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final BlockedReason[] VALUES = values();

      public static BlockedReason valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private BlockedReason(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason)
    }

    public static final int BLOCK_REASON_FIELD_NUMBER = 1;
    private int blockReason_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for blockReason.
     */
    @java.lang.Override
    public int getBlockReasonValue() {
      return blockReason_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The blockReason.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
        getBlockReason() {
      com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason result =
          com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
              .forNumber(blockReason_);
      return result == null
          ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
              .UNRECOGNIZED
          : result;
    }

    public static final int SAFETY_RATINGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vertexai.api.SafetyRating> safetyRatings_;

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vertexai.api.SafetyRating> getSafetyRatingsList() {
      return safetyRatings_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
        getSafetyRatingsOrBuilderList() {
      return safetyRatings_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getSafetyRatingsCount() {
      return safetyRatings_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.SafetyRating getSafetyRatings(int index) {
      return safetyRatings_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
        int index) {
      return safetyRatings_.get(index);
    }

    public static final int BLOCK_REASON_MESSAGE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object blockReasonMessage_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The blockReasonMessage.
     */
    @java.lang.Override
    public java.lang.String getBlockReasonMessage() {
      java.lang.Object ref = blockReasonMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        blockReasonMessage_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for blockReasonMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBlockReasonMessageBytes() {
      java.lang.Object ref = blockReasonMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        blockReasonMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (blockReason_
          != com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
              .BLOCKED_REASON_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, blockReason_);
      }
      for (int i = 0; i < safetyRatings_.size(); i++) {
        output.writeMessage(2, safetyRatings_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(blockReasonMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, blockReasonMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (blockReason_
          != com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
              .BLOCKED_REASON_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, blockReason_);
      }
      for (int i = 0; i < safetyRatings_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, safetyRatings_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(blockReasonMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, blockReasonMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback)) {
        return super.equals(obj);
      }
      com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback other =
          (com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback) obj;

      if (blockReason_ != other.blockReason_) return false;
      if (!getSafetyRatingsList().equals(other.getSafetyRatingsList())) return false;
      if (!getBlockReasonMessage().equals(other.getBlockReasonMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BLOCK_REASON_FIELD_NUMBER;
      hash = (53 * hash) + blockReason_;
      if (getSafetyRatingsCount() > 0) {
        hash = (37 * hash) + SAFETY_RATINGS_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyRatingsList().hashCode();
      }
      hash = (37 * hash) + BLOCK_REASON_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockReasonMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Content filter results for a prompt sent in the request.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback)
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_PromptFeedback_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_PromptFeedback_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.class,
                com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder.class);
      }

      // Construct using
      // com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        blockReason_ = 0;
        if (safetyRatingsBuilder_ == null) {
          safetyRatings_ = java.util.Collections.emptyList();
        } else {
          safetyRatings_ = null;
          safetyRatingsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        blockReasonMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_PromptFeedback_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
          getDefaultInstanceForType() {
        return com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback build() {
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback buildPartial() {
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback result =
            new com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback result) {
        if (safetyRatingsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            safetyRatings_ = java.util.Collections.unmodifiableList(safetyRatings_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.safetyRatings_ = safetyRatings_;
        } else {
          result.safetyRatings_ = safetyRatingsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.blockReason_ = blockReason_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.blockReasonMessage_ = blockReasonMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback) {
          return mergeFrom(
              (com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback other) {
        if (other
            == com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()) return this;
        if (other.blockReason_ != 0) {
          setBlockReasonValue(other.getBlockReasonValue());
        }
        if (safetyRatingsBuilder_ == null) {
          if (!other.safetyRatings_.isEmpty()) {
            if (safetyRatings_.isEmpty()) {
              safetyRatings_ = other.safetyRatings_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSafetyRatingsIsMutable();
              safetyRatings_.addAll(other.safetyRatings_);
            }
            onChanged();
          }
        } else {
          if (!other.safetyRatings_.isEmpty()) {
            if (safetyRatingsBuilder_.isEmpty()) {
              safetyRatingsBuilder_.dispose();
              safetyRatingsBuilder_ = null;
              safetyRatings_ = other.safetyRatings_;
              bitField0_ = (bitField0_ & ~0x00000002);
              safetyRatingsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSafetyRatingsFieldBuilder()
                      : null;
            } else {
              safetyRatingsBuilder_.addAllMessages(other.safetyRatings_);
            }
          }
        }
        if (!other.getBlockReasonMessage().isEmpty()) {
          blockReasonMessage_ = other.blockReasonMessage_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  blockReason_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  com.google.cloud.vertexai.api.SafetyRating m =
                      input.readMessage(
                          com.google.cloud.vertexai.api.SafetyRating.parser(), extensionRegistry);
                  if (safetyRatingsBuilder_ == null) {
                    ensureSafetyRatingsIsMutable();
                    safetyRatings_.add(m);
                  } else {
                    safetyRatingsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  blockReasonMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int blockReason_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for blockReason.
       */
      @java.lang.Override
      public int getBlockReasonValue() {
        return blockReason_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for blockReason to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonValue(int value) {
        blockReason_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The blockReason.
       */
      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
          getBlockReason() {
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason result =
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
                .forNumber(blockReason_);
        return result == null
            ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The blockReason to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReason(
          com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.BlockedReason
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        blockReason_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockReason() {
        bitField0_ = (bitField0_ & ~0x00000001);
        blockReason_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.vertexai.api.SafetyRating> safetyRatings_ =
          java.util.Collections.emptyList();

      private void ensureSafetyRatingsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          safetyRatings_ =
              new java.util.ArrayList<com.google.cloud.vertexai.api.SafetyRating>(safetyRatings_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.SafetyRating,
              com.google.cloud.vertexai.api.SafetyRating.Builder,
              com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
          safetyRatingsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.SafetyRating> getSafetyRatingsList() {
        if (safetyRatingsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(safetyRatings_);
        } else {
          return safetyRatingsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getSafetyRatingsCount() {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.size();
        } else {
          return safetyRatingsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.SafetyRating getSafetyRatings(int index) {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.get(index);
        } else {
          return safetyRatingsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSafetyRatings(int index, com.google.cloud.vertexai.api.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.set(index, value);
          onChanged();
        } else {
          safetyRatingsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSafetyRatings(
          int index, com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.set(index, builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(com.google.cloud.vertexai.api.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(value);
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(int index, com.google.cloud.vertexai.api.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(index, value);
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(
          com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(
          int index, com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(index, builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllSafetyRatings(
          java.lang.Iterable<? extends com.google.cloud.vertexai.api.SafetyRating> values) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, safetyRatings_);
          onChanged();
        } else {
          safetyRatingsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSafetyRatings() {
        if (safetyRatingsBuilder_ == null) {
          safetyRatings_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          safetyRatingsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeSafetyRatings(int index) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.remove(index);
          onChanged();
        } else {
          safetyRatingsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.SafetyRating.Builder getSafetyRatingsBuilder(int index) {
        return getSafetyRatingsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
          int index) {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.get(index);
        } else {
          return safetyRatingsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
          getSafetyRatingsOrBuilderList() {
        if (safetyRatingsBuilder_ != null) {
          return safetyRatingsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(safetyRatings_);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.SafetyRating.Builder addSafetyRatingsBuilder() {
        return getSafetyRatingsFieldBuilder()
            .addBuilder(com.google.cloud.vertexai.api.SafetyRating.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.SafetyRating.Builder addSafetyRatingsBuilder(int index) {
        return getSafetyRatingsFieldBuilder()
            .addBuilder(index, com.google.cloud.vertexai.api.SafetyRating.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.SafetyRating.Builder>
          getSafetyRatingsBuilderList() {
        return getSafetyRatingsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.SafetyRating,
              com.google.cloud.vertexai.api.SafetyRating.Builder,
              com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
          getSafetyRatingsFieldBuilder() {
        if (safetyRatingsBuilder_ == null) {
          safetyRatingsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vertexai.api.SafetyRating,
                  com.google.cloud.vertexai.api.SafetyRating.Builder,
                  com.google.cloud.vertexai.api.SafetyRatingOrBuilder>(
                  safetyRatings_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          safetyRatings_ = null;
        }
        return safetyRatingsBuilder_;
      }

      private java.lang.Object blockReasonMessage_ = "";

      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The blockReasonMessage.
       */
      public java.lang.String getBlockReasonMessage() {
        java.lang.Object ref = blockReasonMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          blockReasonMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for blockReasonMessage.
       */
      public com.google.protobuf.ByteString getBlockReasonMessageBytes() {
        java.lang.Object ref = blockReasonMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          blockReasonMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The blockReasonMessage to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        blockReasonMessage_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockReasonMessage() {
        blockReasonMessage_ = getDefaultInstance().getBlockReasonMessage();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for blockReasonMessage to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        blockReasonMessage_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback)
    private static final com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback();
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PromptFeedback> PARSER =
        new com.google.protobuf.AbstractParser<PromptFeedback>() {
          @java.lang.Override
          public PromptFeedback parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PromptFeedback> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PromptFeedback> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UsageMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of tokens in the request. When `cached_content` is set, this is
     * still the total effective prompt size meaning this includes the number of
     * tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return The promptTokenCount.
     */
    int getPromptTokenCount();

    /**
     *
     *
     * <pre>
     * Number of tokens in the response(s).
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return The candidatesTokenCount.
     */
    int getCandidatesTokenCount();

    /**
     *
     *
     * <pre>
     * Total token count for prompt and response candidates.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return The totalTokenCount.
     */
    int getTotalTokenCount();

    /**
     *
     *
     * <pre>
     * Output only. Number of tokens in the cached part in the input (the cached
     * content).
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cachedContentTokenCount.
     */
    int getCachedContentTokenCount();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount> getPromptTokensDetailsList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCount getPromptTokensDetails(int index);

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getPromptTokensDetailsCount();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getPromptTokensDetailsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder getPromptTokensDetailsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount> getCacheTokensDetailsList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCount getCacheTokensDetails(int index);

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getCacheTokensDetailsCount();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getCacheTokensDetailsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder getCacheTokensDetailsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
        getCandidatesTokensDetailsList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCount getCandidatesTokensDetails(int index);

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getCandidatesTokensDetailsCount();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getCandidatesTokensDetailsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder getCandidatesTokensDetailsOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * Usage metadata about response(s).
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata}
   */
  public static final class UsageMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata)
      UsageMetadataOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use UsageMetadata.newBuilder() to construct.
    private UsageMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UsageMetadata() {
      promptTokensDetails_ = java.util.Collections.emptyList();
      cacheTokensDetails_ = java.util.Collections.emptyList();
      candidatesTokensDetails_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UsageMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_UsageMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_UsageMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.class,
              com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder.class);
    }

    public static final int PROMPT_TOKEN_COUNT_FIELD_NUMBER = 1;
    private int promptTokenCount_ = 0;

    /**
     *
     *
     * <pre>
     * Number of tokens in the request. When `cached_content` is set, this is
     * still the total effective prompt size meaning this includes the number of
     * tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return The promptTokenCount.
     */
    @java.lang.Override
    public int getPromptTokenCount() {
      return promptTokenCount_;
    }

    public static final int CANDIDATES_TOKEN_COUNT_FIELD_NUMBER = 2;
    private int candidatesTokenCount_ = 0;

    /**
     *
     *
     * <pre>
     * Number of tokens in the response(s).
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return The candidatesTokenCount.
     */
    @java.lang.Override
    public int getCandidatesTokenCount() {
      return candidatesTokenCount_;
    }

    public static final int TOTAL_TOKEN_COUNT_FIELD_NUMBER = 3;
    private int totalTokenCount_ = 0;

    /**
     *
     *
     * <pre>
     * Total token count for prompt and response candidates.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return The totalTokenCount.
     */
    @java.lang.Override
    public int getTotalTokenCount() {
      return totalTokenCount_;
    }

    public static final int CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER = 5;
    private int cachedContentTokenCount_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Number of tokens in the cached part in the input (the cached
     * content).
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cachedContentTokenCount.
     */
    @java.lang.Override
    public int getCachedContentTokenCount() {
      return cachedContentTokenCount_;
    }

    public static final int PROMPT_TOKENS_DETAILS_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount> promptTokensDetails_;

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
        getPromptTokensDetailsList() {
      return promptTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getPromptTokensDetailsOrBuilderList() {
      return promptTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getPromptTokensDetailsCount() {
      return promptTokensDetails_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount getPromptTokensDetails(int index) {
      return promptTokensDetails_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were processed in the request input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder
        getPromptTokensDetailsOrBuilder(int index) {
      return promptTokensDetails_.get(index);
    }

    public static final int CACHE_TOKENS_DETAILS_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount> cacheTokensDetails_;

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
        getCacheTokensDetailsList() {
      return cacheTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getCacheTokensDetailsOrBuilderList() {
      return cacheTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getCacheTokensDetailsCount() {
      return cacheTokensDetails_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount getCacheTokensDetails(int index) {
      return cacheTokensDetails_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities of the cached content in the request
     * input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder getCacheTokensDetailsOrBuilder(
        int index) {
      return cacheTokensDetails_.get(index);
    }

    public static final int CANDIDATES_TOKENS_DETAILS_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
        candidatesTokensDetails_;

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
        getCandidatesTokensDetailsList() {
      return candidatesTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
        getCandidatesTokensDetailsOrBuilderList() {
      return candidatesTokensDetails_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getCandidatesTokensDetailsCount() {
      return candidatesTokensDetails_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount getCandidatesTokensDetails(int index) {
      return candidatesTokensDetails_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. List of modalities that were returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder
        getCandidatesTokensDetailsOrBuilder(int index) {
      return candidatesTokensDetails_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (promptTokenCount_ != 0) {
        output.writeInt32(1, promptTokenCount_);
      }
      if (candidatesTokenCount_ != 0) {
        output.writeInt32(2, candidatesTokenCount_);
      }
      if (totalTokenCount_ != 0) {
        output.writeInt32(3, totalTokenCount_);
      }
      if (cachedContentTokenCount_ != 0) {
        output.writeInt32(5, cachedContentTokenCount_);
      }
      for (int i = 0; i < promptTokensDetails_.size(); i++) {
        output.writeMessage(9, promptTokensDetails_.get(i));
      }
      for (int i = 0; i < cacheTokensDetails_.size(); i++) {
        output.writeMessage(10, cacheTokensDetails_.get(i));
      }
      for (int i = 0; i < candidatesTokensDetails_.size(); i++) {
        output.writeMessage(11, candidatesTokensDetails_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (promptTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, promptTokenCount_);
      }
      if (candidatesTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, candidatesTokenCount_);
      }
      if (totalTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalTokenCount_);
      }
      if (cachedContentTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, cachedContentTokenCount_);
      }
      for (int i = 0; i < promptTokensDetails_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, promptTokensDetails_.get(i));
      }
      for (int i = 0; i < cacheTokensDetails_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, cacheTokensDetails_.get(i));
      }
      for (int i = 0; i < candidatesTokensDetails_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                11, candidatesTokensDetails_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata other =
          (com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata) obj;

      if (getPromptTokenCount() != other.getPromptTokenCount()) return false;
      if (getCandidatesTokenCount() != other.getCandidatesTokenCount()) return false;
      if (getTotalTokenCount() != other.getTotalTokenCount()) return false;
      if (getCachedContentTokenCount() != other.getCachedContentTokenCount()) return false;
      if (!getPromptTokensDetailsList().equals(other.getPromptTokensDetailsList())) return false;
      if (!getCacheTokensDetailsList().equals(other.getCacheTokensDetailsList())) return false;
      if (!getCandidatesTokensDetailsList().equals(other.getCandidatesTokensDetailsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROMPT_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPromptTokenCount();
      hash = (37 * hash) + CANDIDATES_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesTokenCount();
      hash = (37 * hash) + TOTAL_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTotalTokenCount();
      hash = (37 * hash) + CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCachedContentTokenCount();
      if (getPromptTokensDetailsCount() > 0) {
        hash = (37 * hash) + PROMPT_TOKENS_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getPromptTokensDetailsList().hashCode();
      }
      if (getCacheTokensDetailsCount() > 0) {
        hash = (37 * hash) + CACHE_TOKENS_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getCacheTokensDetailsList().hashCode();
      }
      if (getCandidatesTokensDetailsCount() > 0) {
        hash = (37 * hash) + CANDIDATES_TOKENS_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getCandidatesTokensDetailsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about response(s).
     * </pre>
     *
     * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata)
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_UsageMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_UsageMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.class,
                com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        promptTokenCount_ = 0;
        candidatesTokenCount_ = 0;
        totalTokenCount_ = 0;
        cachedContentTokenCount_ = 0;
        if (promptTokensDetailsBuilder_ == null) {
          promptTokensDetails_ = java.util.Collections.emptyList();
        } else {
          promptTokensDetails_ = null;
          promptTokensDetailsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (cacheTokensDetailsBuilder_ == null) {
          cacheTokensDetails_ = java.util.Collections.emptyList();
        } else {
          cacheTokensDetails_ = null;
          cacheTokensDetailsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (candidatesTokensDetailsBuilder_ == null) {
          candidatesTokensDetails_ = java.util.Collections.emptyList();
        } else {
          candidatesTokensDetails_ = null;
          candidatesTokensDetailsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vertexai.api.PredictionServiceProto
            .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_UsageMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata build() {
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata buildPartial() {
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata result =
            new com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata result) {
        if (promptTokensDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            promptTokensDetails_ = java.util.Collections.unmodifiableList(promptTokensDetails_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.promptTokensDetails_ = promptTokensDetails_;
        } else {
          result.promptTokensDetails_ = promptTokensDetailsBuilder_.build();
        }
        if (cacheTokensDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            cacheTokensDetails_ = java.util.Collections.unmodifiableList(cacheTokensDetails_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.cacheTokensDetails_ = cacheTokensDetails_;
        } else {
          result.cacheTokensDetails_ = cacheTokensDetailsBuilder_.build();
        }
        if (candidatesTokensDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            candidatesTokensDetails_ =
                java.util.Collections.unmodifiableList(candidatesTokensDetails_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.candidatesTokensDetails_ = candidatesTokensDetails_;
        } else {
          result.candidatesTokensDetails_ = candidatesTokensDetailsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.promptTokenCount_ = promptTokenCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.candidatesTokenCount_ = candidatesTokenCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.totalTokenCount_ = totalTokenCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.cachedContentTokenCount_ = cachedContentTokenCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata) {
          return mergeFrom(
              (com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata other) {
        if (other
            == com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()) return this;
        if (other.getPromptTokenCount() != 0) {
          setPromptTokenCount(other.getPromptTokenCount());
        }
        if (other.getCandidatesTokenCount() != 0) {
          setCandidatesTokenCount(other.getCandidatesTokenCount());
        }
        if (other.getTotalTokenCount() != 0) {
          setTotalTokenCount(other.getTotalTokenCount());
        }
        if (other.getCachedContentTokenCount() != 0) {
          setCachedContentTokenCount(other.getCachedContentTokenCount());
        }
        if (promptTokensDetailsBuilder_ == null) {
          if (!other.promptTokensDetails_.isEmpty()) {
            if (promptTokensDetails_.isEmpty()) {
              promptTokensDetails_ = other.promptTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensurePromptTokensDetailsIsMutable();
              promptTokensDetails_.addAll(other.promptTokensDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.promptTokensDetails_.isEmpty()) {
            if (promptTokensDetailsBuilder_.isEmpty()) {
              promptTokensDetailsBuilder_.dispose();
              promptTokensDetailsBuilder_ = null;
              promptTokensDetails_ = other.promptTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000010);
              promptTokensDetailsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPromptTokensDetailsFieldBuilder()
                      : null;
            } else {
              promptTokensDetailsBuilder_.addAllMessages(other.promptTokensDetails_);
            }
          }
        }
        if (cacheTokensDetailsBuilder_ == null) {
          if (!other.cacheTokensDetails_.isEmpty()) {
            if (cacheTokensDetails_.isEmpty()) {
              cacheTokensDetails_ = other.cacheTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureCacheTokensDetailsIsMutable();
              cacheTokensDetails_.addAll(other.cacheTokensDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.cacheTokensDetails_.isEmpty()) {
            if (cacheTokensDetailsBuilder_.isEmpty()) {
              cacheTokensDetailsBuilder_.dispose();
              cacheTokensDetailsBuilder_ = null;
              cacheTokensDetails_ = other.cacheTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000020);
              cacheTokensDetailsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCacheTokensDetailsFieldBuilder()
                      : null;
            } else {
              cacheTokensDetailsBuilder_.addAllMessages(other.cacheTokensDetails_);
            }
          }
        }
        if (candidatesTokensDetailsBuilder_ == null) {
          if (!other.candidatesTokensDetails_.isEmpty()) {
            if (candidatesTokensDetails_.isEmpty()) {
              candidatesTokensDetails_ = other.candidatesTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureCandidatesTokensDetailsIsMutable();
              candidatesTokensDetails_.addAll(other.candidatesTokensDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.candidatesTokensDetails_.isEmpty()) {
            if (candidatesTokensDetailsBuilder_.isEmpty()) {
              candidatesTokensDetailsBuilder_.dispose();
              candidatesTokensDetailsBuilder_ = null;
              candidatesTokensDetails_ = other.candidatesTokensDetails_;
              bitField0_ = (bitField0_ & ~0x00000040);
              candidatesTokensDetailsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCandidatesTokensDetailsFieldBuilder()
                      : null;
            } else {
              candidatesTokensDetailsBuilder_.addAllMessages(other.candidatesTokensDetails_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  promptTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  candidatesTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  totalTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 40:
                {
                  cachedContentTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 40
              case 74:
                {
                  com.google.cloud.vertexai.api.ModalityTokenCount m =
                      input.readMessage(
                          com.google.cloud.vertexai.api.ModalityTokenCount.parser(),
                          extensionRegistry);
                  if (promptTokensDetailsBuilder_ == null) {
                    ensurePromptTokensDetailsIsMutable();
                    promptTokensDetails_.add(m);
                  } else {
                    promptTokensDetailsBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              case 82:
                {
                  com.google.cloud.vertexai.api.ModalityTokenCount m =
                      input.readMessage(
                          com.google.cloud.vertexai.api.ModalityTokenCount.parser(),
                          extensionRegistry);
                  if (cacheTokensDetailsBuilder_ == null) {
                    ensureCacheTokensDetailsIsMutable();
                    cacheTokensDetails_.add(m);
                  } else {
                    cacheTokensDetailsBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              case 90:
                {
                  com.google.cloud.vertexai.api.ModalityTokenCount m =
                      input.readMessage(
                          com.google.cloud.vertexai.api.ModalityTokenCount.parser(),
                          extensionRegistry);
                  if (candidatesTokensDetailsBuilder_ == null) {
                    ensureCandidatesTokensDetailsIsMutable();
                    candidatesTokensDetails_.add(m);
                  } else {
                    candidatesTokensDetailsBuilder_.addMessage(m);
                  }
                  break;
                } // case 90
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int promptTokenCount_;

      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @return The promptTokenCount.
       */
      @java.lang.Override
      public int getPromptTokenCount() {
        return promptTokenCount_;
      }

      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @param value The promptTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setPromptTokenCount(int value) {

        promptTokenCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPromptTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        promptTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int candidatesTokenCount_;

      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @return The candidatesTokenCount.
       */
      @java.lang.Override
      public int getCandidatesTokenCount() {
        return candidatesTokenCount_;
      }

      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @param value The candidatesTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setCandidatesTokenCount(int value) {

        candidatesTokenCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCandidatesTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        candidatesTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int totalTokenCount_;

      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @return The totalTokenCount.
       */
      @java.lang.Override
      public int getTotalTokenCount() {
        return totalTokenCount_;
      }

      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @param value The totalTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setTotalTokenCount(int value) {

        totalTokenCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        totalTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int cachedContentTokenCount_;

      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The cachedContentTokenCount.
       */
      @java.lang.Override
      public int getCachedContentTokenCount() {
        return cachedContentTokenCount_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The cachedContentTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setCachedContentTokenCount(int value) {

        cachedContentTokenCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCachedContentTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        cachedContentTokenCount_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
          promptTokensDetails_ = java.util.Collections.emptyList();

      private void ensurePromptTokensDetailsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          promptTokensDetails_ =
              new java.util.ArrayList<com.google.cloud.vertexai.api.ModalityTokenCount>(
                  promptTokensDetails_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          promptTokensDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
          getPromptTokensDetailsList() {
        if (promptTokensDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(promptTokensDetails_);
        } else {
          return promptTokensDetailsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getPromptTokensDetailsCount() {
        if (promptTokensDetailsBuilder_ == null) {
          return promptTokensDetails_.size();
        } else {
          return promptTokensDetailsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount getPromptTokensDetails(int index) {
        if (promptTokensDetailsBuilder_ == null) {
          return promptTokensDetails_.get(index);
        } else {
          return promptTokensDetailsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setPromptTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (promptTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.set(index, value);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setPromptTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (promptTokensDetailsBuilder_ == null) {
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          promptTokensDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addPromptTokensDetails(
          com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (promptTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.add(value);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addPromptTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (promptTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.add(index, value);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addPromptTokensDetails(
          com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (promptTokensDetailsBuilder_ == null) {
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.add(builderForValue.build());
          onChanged();
        } else {
          promptTokensDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addPromptTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (promptTokensDetailsBuilder_ == null) {
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          promptTokensDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllPromptTokensDetails(
          java.lang.Iterable<? extends com.google.cloud.vertexai.api.ModalityTokenCount> values) {
        if (promptTokensDetailsBuilder_ == null) {
          ensurePromptTokensDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promptTokensDetails_);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearPromptTokensDetails() {
        if (promptTokensDetailsBuilder_ == null) {
          promptTokensDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removePromptTokensDetails(int index) {
        if (promptTokensDetailsBuilder_ == null) {
          ensurePromptTokensDetailsIsMutable();
          promptTokensDetails_.remove(index);
          onChanged();
        } else {
          promptTokensDetailsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder getPromptTokensDetailsBuilder(
          int index) {
        return getPromptTokensDetailsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder
          getPromptTokensDetailsOrBuilder(int index) {
        if (promptTokensDetailsBuilder_ == null) {
          return promptTokensDetails_.get(index);
        } else {
          return promptTokensDetailsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getPromptTokensDetailsOrBuilderList() {
        if (promptTokensDetailsBuilder_ != null) {
          return promptTokensDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(promptTokensDetails_);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder
          addPromptTokensDetailsBuilder() {
        return getPromptTokensDetailsFieldBuilder()
            .addBuilder(com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder addPromptTokensDetailsBuilder(
          int index) {
        return getPromptTokensDetailsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were processed in the request input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount.Builder>
          getPromptTokensDetailsBuilderList() {
        return getPromptTokensDetailsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getPromptTokensDetailsFieldBuilder() {
        if (promptTokensDetailsBuilder_ == null) {
          promptTokensDetailsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vertexai.api.ModalityTokenCount,
                  com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
                  com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>(
                  promptTokensDetails_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          promptTokensDetails_ = null;
        }
        return promptTokensDetailsBuilder_;
      }

      private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount> cacheTokensDetails_ =
          java.util.Collections.emptyList();

      private void ensureCacheTokensDetailsIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          cacheTokensDetails_ =
              new java.util.ArrayList<com.google.cloud.vertexai.api.ModalityTokenCount>(
                  cacheTokensDetails_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          cacheTokensDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
          getCacheTokensDetailsList() {
        if (cacheTokensDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(cacheTokensDetails_);
        } else {
          return cacheTokensDetailsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getCacheTokensDetailsCount() {
        if (cacheTokensDetailsBuilder_ == null) {
          return cacheTokensDetails_.size();
        } else {
          return cacheTokensDetailsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount getCacheTokensDetails(int index) {
        if (cacheTokensDetailsBuilder_ == null) {
          return cacheTokensDetails_.get(index);
        } else {
          return cacheTokensDetailsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCacheTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (cacheTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.set(index, value);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCacheTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (cacheTokensDetailsBuilder_ == null) {
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCacheTokensDetails(com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (cacheTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.add(value);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCacheTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (cacheTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.add(index, value);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCacheTokensDetails(
          com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (cacheTokensDetailsBuilder_ == null) {
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.add(builderForValue.build());
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCacheTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (cacheTokensDetailsBuilder_ == null) {
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllCacheTokensDetails(
          java.lang.Iterable<? extends com.google.cloud.vertexai.api.ModalityTokenCount> values) {
        if (cacheTokensDetailsBuilder_ == null) {
          ensureCacheTokensDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cacheTokensDetails_);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCacheTokensDetails() {
        if (cacheTokensDetailsBuilder_ == null) {
          cacheTokensDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeCacheTokensDetails(int index) {
        if (cacheTokensDetailsBuilder_ == null) {
          ensureCacheTokensDetailsIsMutable();
          cacheTokensDetails_.remove(index);
          onChanged();
        } else {
          cacheTokensDetailsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder getCacheTokensDetailsBuilder(
          int index) {
        return getCacheTokensDetailsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder
          getCacheTokensDetailsOrBuilder(int index) {
        if (cacheTokensDetailsBuilder_ == null) {
          return cacheTokensDetails_.get(index);
        } else {
          return cacheTokensDetailsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getCacheTokensDetailsOrBuilderList() {
        if (cacheTokensDetailsBuilder_ != null) {
          return cacheTokensDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(cacheTokensDetails_);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder
          addCacheTokensDetailsBuilder() {
        return getCacheTokensDetailsFieldBuilder()
            .addBuilder(com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder addCacheTokensDetailsBuilder(
          int index) {
        return getCacheTokensDetailsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities of the cached content in the request
       * input.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount.Builder>
          getCacheTokensDetailsBuilderList() {
        return getCacheTokensDetailsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getCacheTokensDetailsFieldBuilder() {
        if (cacheTokensDetailsBuilder_ == null) {
          cacheTokensDetailsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vertexai.api.ModalityTokenCount,
                  com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
                  com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>(
                  cacheTokensDetails_,
                  ((bitField0_ & 0x00000020) != 0),
                  getParentForChildren(),
                  isClean());
          cacheTokensDetails_ = null;
        }
        return cacheTokensDetailsBuilder_;
      }

      private java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
          candidatesTokensDetails_ = java.util.Collections.emptyList();

      private void ensureCandidatesTokensDetailsIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          candidatesTokensDetails_ =
              new java.util.ArrayList<com.google.cloud.vertexai.api.ModalityTokenCount>(
                  candidatesTokensDetails_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          candidatesTokensDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount>
          getCandidatesTokensDetailsList() {
        if (candidatesTokensDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(candidatesTokensDetails_);
        } else {
          return candidatesTokensDetailsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getCandidatesTokensDetailsCount() {
        if (candidatesTokensDetailsBuilder_ == null) {
          return candidatesTokensDetails_.size();
        } else {
          return candidatesTokensDetailsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount getCandidatesTokensDetails(
          int index) {
        if (candidatesTokensDetailsBuilder_ == null) {
          return candidatesTokensDetails_.get(index);
        } else {
          return candidatesTokensDetailsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCandidatesTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (candidatesTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.set(index, value);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCandidatesTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (candidatesTokensDetailsBuilder_ == null) {
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCandidatesTokensDetails(
          com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (candidatesTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.add(value);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCandidatesTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount value) {
        if (candidatesTokensDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.add(index, value);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCandidatesTokensDetails(
          com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (candidatesTokensDetailsBuilder_ == null) {
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.add(builderForValue.build());
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addCandidatesTokensDetails(
          int index, com.google.cloud.vertexai.api.ModalityTokenCount.Builder builderForValue) {
        if (candidatesTokensDetailsBuilder_ == null) {
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllCandidatesTokensDetails(
          java.lang.Iterable<? extends com.google.cloud.vertexai.api.ModalityTokenCount> values) {
        if (candidatesTokensDetailsBuilder_ == null) {
          ensureCandidatesTokensDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidatesTokensDetails_);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCandidatesTokensDetails() {
        if (candidatesTokensDetailsBuilder_ == null) {
          candidatesTokensDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeCandidatesTokensDetails(int index) {
        if (candidatesTokensDetailsBuilder_ == null) {
          ensureCandidatesTokensDetailsIsMutable();
          candidatesTokensDetails_.remove(index);
          onChanged();
        } else {
          candidatesTokensDetailsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder
          getCandidatesTokensDetailsBuilder(int index) {
        return getCandidatesTokensDetailsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder
          getCandidatesTokensDetailsOrBuilder(int index) {
        if (candidatesTokensDetailsBuilder_ == null) {
          return candidatesTokensDetails_.get(index);
        } else {
          return candidatesTokensDetailsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getCandidatesTokensDetailsOrBuilderList() {
        if (candidatesTokensDetailsBuilder_ != null) {
          return candidatesTokensDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(candidatesTokensDetails_);
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder
          addCandidatesTokensDetailsBuilder() {
        return getCandidatesTokensDetailsFieldBuilder()
            .addBuilder(com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.vertexai.api.ModalityTokenCount.Builder
          addCandidatesTokensDetailsBuilder(int index) {
        return getCandidatesTokensDetailsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Output only. List of modalities that were returned in the response.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.ModalityTokenCount.Builder>
          getCandidatesTokensDetailsBuilderList() {
        return getCandidatesTokensDetailsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.ModalityTokenCount,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
              com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>
          getCandidatesTokensDetailsFieldBuilder() {
        if (candidatesTokensDetailsBuilder_ == null) {
          candidatesTokensDetailsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vertexai.api.ModalityTokenCount,
                  com.google.cloud.vertexai.api.ModalityTokenCount.Builder,
                  com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder>(
                  candidatesTokensDetails_,
                  ((bitField0_ & 0x00000040) != 0),
                  getParentForChildren(),
                  isClean());
          candidatesTokensDetails_ = null;
        }
        return candidatesTokensDetailsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata)
    private static final com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata();
    }

    public static com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UsageMetadata> PARSER =
        new com.google.protobuf.AbstractParser<UsageMetadata>() {
          @java.lang.Override
          public UsageMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UsageMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UsageMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CANDIDATES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Candidate> candidates_;

  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Candidate> getCandidatesList() {
    return candidates_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.CandidateOrBuilder>
      getCandidatesOrBuilderList() {
    return candidates_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCandidatesCount() {
    return candidates_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Candidate getCandidates(int index) {
    return candidates_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.CandidateOrBuilder getCandidatesOrBuilder(int index) {
    return candidates_.get(index);
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersion_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The model version used to generate the response.
   * </pre>
   *
   * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersion.
   */
  @java.lang.Override
  public java.lang.String getModelVersion() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersion_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The model version used to generate the response.
   * </pre>
   *
   * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionBytes() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the request is made to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the request is made to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the request is made to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int RESPONSE_ID_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object responseId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. response_id is used to identify each response. It is the
   * encoding of the event_id.
   * </pre>
   *
   * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The responseId.
   */
  @java.lang.Override
  public java.lang.String getResponseId() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. response_id is used to identify each response. It is the
   * encoding of the event_id.
   * </pre>
   *
   * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for responseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseIdBytes() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROMPT_FEEDBACK_FIELD_NUMBER = 3;
  private com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback promptFeedback_;

  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the promptFeedback field is set.
   */
  @java.lang.Override
  public boolean hasPromptFeedback() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The promptFeedback.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback getPromptFeedback() {
    return promptFeedback_ == null
        ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.getDefaultInstance()
        : promptFeedback_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder
      getPromptFeedbackOrBuilder() {
    return promptFeedback_ == null
        ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.getDefaultInstance()
        : promptFeedback_;
  }

  public static final int USAGE_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata usageMetadata_;

  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   *
   * @return Whether the usageMetadata field is set.
   */
  @java.lang.Override
  public boolean hasUsageMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   *
   * @return The usageMetadata.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata getUsageMetadata() {
    return usageMetadata_ == null
        ? com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.getDefaultInstance()
        : usageMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder
      getUsageMetadataOrBuilder() {
    return usageMetadata_ == null
        ? com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.getDefaultInstance()
        : usageMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < candidates_.size(); i++) {
      output.writeMessage(2, candidates_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getPromptFeedback());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getUsageMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, modelVersion_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(12, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, responseId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < candidates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, candidates_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPromptFeedback());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUsageMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, modelVersion_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, responseId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.GenerateContentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.GenerateContentResponse other =
        (com.google.cloud.vertexai.api.GenerateContentResponse) obj;

    if (!getCandidatesList().equals(other.getCandidatesList())) return false;
    if (!getModelVersion().equals(other.getModelVersion())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getResponseId().equals(other.getResponseId())) return false;
    if (hasPromptFeedback() != other.hasPromptFeedback()) return false;
    if (hasPromptFeedback()) {
      if (!getPromptFeedback().equals(other.getPromptFeedback())) return false;
    }
    if (hasUsageMetadata() != other.hasUsageMetadata()) return false;
    if (hasUsageMetadata()) {
      if (!getUsageMetadata().equals(other.getUsageMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCandidatesCount() > 0) {
      hash = (37 * hash) + CANDIDATES_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesList().hashCode();
    }
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersion().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResponseId().hashCode();
    if (hasPromptFeedback()) {
      hash = (37 * hash) + PROMPT_FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + getPromptFeedback().hashCode();
    }
    if (hasUsageMetadata()) {
      hash = (37 * hash) + USAGE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getUsageMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vertexai.api.GenerateContentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for [PredictionService.GenerateContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.GenerateContentResponse)
      com.google.cloud.vertexai.api.GenerateContentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.GenerateContentResponse.class,
              com.google.cloud.vertexai.api.GenerateContentResponse.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.GenerateContentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCandidatesFieldBuilder();
        getCreateTimeFieldBuilder();
        getPromptFeedbackFieldBuilder();
        getUsageMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
      } else {
        candidates_ = null;
        candidatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      modelVersion_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      responseId_ = "";
      promptFeedback_ = null;
      if (promptFeedbackBuilder_ != null) {
        promptFeedbackBuilder_.dispose();
        promptFeedbackBuilder_ = null;
      }
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.GenerateContentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse build() {
      com.google.cloud.vertexai.api.GenerateContentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentResponse buildPartial() {
      com.google.cloud.vertexai.api.GenerateContentResponse result =
          new com.google.cloud.vertexai.api.GenerateContentResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.vertexai.api.GenerateContentResponse result) {
      if (candidatesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          candidates_ = java.util.Collections.unmodifiableList(candidates_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.candidates_ = candidates_;
      } else {
        result.candidates_ = candidatesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.GenerateContentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.modelVersion_ = modelVersion_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.responseId_ = responseId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.promptFeedback_ =
            promptFeedbackBuilder_ == null ? promptFeedback_ : promptFeedbackBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.usageMetadata_ =
            usageMetadataBuilder_ == null ? usageMetadata_ : usageMetadataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.GenerateContentResponse) {
        return mergeFrom((com.google.cloud.vertexai.api.GenerateContentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.GenerateContentResponse other) {
      if (other == com.google.cloud.vertexai.api.GenerateContentResponse.getDefaultInstance())
        return this;
      if (candidatesBuilder_ == null) {
        if (!other.candidates_.isEmpty()) {
          if (candidates_.isEmpty()) {
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCandidatesIsMutable();
            candidates_.addAll(other.candidates_);
          }
          onChanged();
        }
      } else {
        if (!other.candidates_.isEmpty()) {
          if (candidatesBuilder_.isEmpty()) {
            candidatesBuilder_.dispose();
            candidatesBuilder_ = null;
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
            candidatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCandidatesFieldBuilder()
                    : null;
          } else {
            candidatesBuilder_.addAllMessages(other.candidates_);
          }
        }
      }
      if (!other.getModelVersion().isEmpty()) {
        modelVersion_ = other.modelVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getResponseId().isEmpty()) {
        responseId_ = other.responseId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasPromptFeedback()) {
        mergePromptFeedback(other.getPromptFeedback());
      }
      if (other.hasUsageMetadata()) {
        mergeUsageMetadata(other.getUsageMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.cloud.vertexai.api.Candidate m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Candidate.parser(), extensionRegistry);
                if (candidatesBuilder_ == null) {
                  ensureCandidatesIsMutable();
                  candidates_.add(m);
                } else {
                  candidatesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPromptFeedbackFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUsageMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 90:
              {
                modelVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 98
            case 106:
              {
                responseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vertexai.api.Candidate> candidates_ =
        java.util.Collections.emptyList();

    private void ensureCandidatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        candidates_ = new java.util.ArrayList<com.google.cloud.vertexai.api.Candidate>(candidates_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Candidate,
            com.google.cloud.vertexai.api.Candidate.Builder,
            com.google.cloud.vertexai.api.CandidateOrBuilder>
        candidatesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Candidate> getCandidatesList() {
      if (candidatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(candidates_);
      } else {
        return candidatesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCandidatesCount() {
      if (candidatesBuilder_ == null) {
        return candidates_.size();
      } else {
        return candidatesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Candidate getCandidates(int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidates(int index, com.google.cloud.vertexai.api.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.set(index, value);
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidates(
        int index, com.google.cloud.vertexai.api.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.set(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(com.google.cloud.vertexai.api.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(int index, com.google.cloud.vertexai.api.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(index, value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(com.google.cloud.vertexai.api.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(
        int index, com.google.cloud.vertexai.api.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCandidates(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Candidate> values) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidates_);
        onChanged();
      } else {
        candidatesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCandidates() {
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        candidatesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCandidates(int index) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.remove(index);
        onChanged();
      } else {
        candidatesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Candidate.Builder getCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.CandidateOrBuilder getCandidatesOrBuilder(int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.CandidateOrBuilder>
        getCandidatesOrBuilderList() {
      if (candidatesBuilder_ != null) {
        return candidatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(candidates_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Candidate.Builder addCandidatesBuilder() {
      return getCandidatesFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Candidate.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Candidate.Builder addCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Candidate.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Candidate.Builder>
        getCandidatesBuilderList() {
      return getCandidatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Candidate,
            com.google.cloud.vertexai.api.Candidate.Builder,
            com.google.cloud.vertexai.api.CandidateOrBuilder>
        getCandidatesFieldBuilder() {
      if (candidatesBuilder_ == null) {
        candidatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Candidate,
                com.google.cloud.vertexai.api.Candidate.Builder,
                com.google.cloud.vertexai.api.CandidateOrBuilder>(
                candidates_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        candidates_ = null;
      }
      return candidatesBuilder_;
    }

    private java.lang.Object modelVersion_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersion.
     */
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersion.
     */
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {
      modelVersion_ = getDefaultInstance().getModelVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the request is made to the server.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object responseId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. response_id is used to identify each response. It is the
     * encoding of the event_id.
     * </pre>
     *
     * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The responseId.
     */
    public java.lang.String getResponseId() {
      java.lang.Object ref = responseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. response_id is used to identify each response. It is the
     * encoding of the event_id.
     * </pre>
     *
     * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for responseId.
     */
    public com.google.protobuf.ByteString getResponseIdBytes() {
      java.lang.Object ref = responseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. response_id is used to identify each response. It is the
     * encoding of the event_id.
     * </pre>
     *
     * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      responseId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. response_id is used to identify each response. It is the
     * encoding of the event_id.
     * </pre>
     *
     * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseId() {
      responseId_ = getDefaultInstance().getResponseId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. response_id is used to identify each response. It is the
     * encoding of the event_id.
     * </pre>
     *
     * <code>string response_id = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      responseId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback promptFeedback_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback,
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder,
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder>
        promptFeedbackBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the promptFeedback field is set.
     */
    public boolean hasPromptFeedback() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The promptFeedback.
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
        getPromptFeedback() {
      if (promptFeedbackBuilder_ == null) {
        return promptFeedback_ == null
            ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()
            : promptFeedback_;
      } else {
        return promptFeedbackBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptFeedback(
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback value) {
      if (promptFeedbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        promptFeedback_ = value;
      } else {
        promptFeedbackBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptFeedback(
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder
            builderForValue) {
      if (promptFeedbackBuilder_ == null) {
        promptFeedback_ = builderForValue.build();
      } else {
        promptFeedbackBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePromptFeedback(
        com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback value) {
      if (promptFeedbackBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && promptFeedback_ != null
            && promptFeedback_
                != com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
                    .getDefaultInstance()) {
          getPromptFeedbackBuilder().mergeFrom(value);
        } else {
          promptFeedback_ = value;
        }
      } else {
        promptFeedbackBuilder_.mergeFrom(value);
      }
      if (promptFeedback_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPromptFeedback() {
      bitField0_ = (bitField0_ & ~0x00000010);
      promptFeedback_ = null;
      if (promptFeedbackBuilder_ != null) {
        promptFeedbackBuilder_.dispose();
        promptFeedbackBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder
        getPromptFeedbackBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPromptFeedbackFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder
        getPromptFeedbackOrBuilder() {
      if (promptFeedbackBuilder_ != null) {
        return promptFeedbackBuilder_.getMessageOrBuilder();
      } else {
        return promptFeedback_ == null
            ? com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()
            : promptFeedback_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback,
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder,
            com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder>
        getPromptFeedbackFieldBuilder() {
      if (promptFeedbackBuilder_ == null) {
        promptFeedbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback,
                com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedback.Builder,
                com.google.cloud.vertexai.api.GenerateContentResponse.PromptFeedbackOrBuilder>(
                getPromptFeedback(), getParentForChildren(), isClean());
        promptFeedback_ = null;
      }
      return promptFeedbackBuilder_;
    }

    private com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata usageMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata,
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder,
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder>
        usageMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     *
     * @return Whether the usageMetadata field is set.
     */
    public boolean hasUsageMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     *
     * @return The usageMetadata.
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata getUsageMetadata() {
      if (usageMetadataBuilder_ == null) {
        return usageMetadata_ == null
            ? com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()
            : usageMetadata_;
      } else {
        return usageMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder setUsageMetadata(
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usageMetadata_ = value;
      } else {
        usageMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder setUsageMetadata(
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder
            builderForValue) {
      if (usageMetadataBuilder_ == null) {
        usageMetadata_ = builderForValue.build();
      } else {
        usageMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder mergeUsageMetadata(
        com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && usageMetadata_ != null
            && usageMetadata_
                != com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
                    .getDefaultInstance()) {
          getUsageMetadataBuilder().mergeFrom(value);
        } else {
          usageMetadata_ = value;
        }
      } else {
        usageMetadataBuilder_.mergeFrom(value);
      }
      if (usageMetadata_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder clearUsageMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder
        getUsageMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUsageMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder
        getUsageMetadataOrBuilder() {
      if (usageMetadataBuilder_ != null) {
        return usageMetadataBuilder_.getMessageOrBuilder();
      } else {
        return usageMetadata_ == null
            ? com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()
            : usageMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata,
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder,
            com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder>
        getUsageMetadataFieldBuilder() {
      if (usageMetadataBuilder_ == null) {
        usageMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata,
                com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadata.Builder,
                com.google.cloud.vertexai.api.GenerateContentResponse.UsageMetadataOrBuilder>(
                getUsageMetadata(), getParentForChildren(), isClean());
        usageMetadata_ = null;
      }
      return usageMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.GenerateContentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.GenerateContentResponse)
  private static final com.google.cloud.vertexai.api.GenerateContentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.GenerateContentResponse();
  }

  public static com.google.cloud.vertexai.api.GenerateContentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateContentResponse> PARSER =
      new com.google.protobuf.AbstractParser<GenerateContentResponse>() {
        @java.lang.Override
        public GenerateContentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateContentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateContentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
