/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal.workflow.kaleo.runtime.node;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.node.TaskNodeExecutorAIDelegate;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiStreamingChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.TokenStream;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TaskNodeExecutorAIDelegate.class})
public class ImproveWritingTaskNodeExecutorAIDelegate
implements TaskNodeExecutorAIDelegate {
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;

    public void execute(ExecutionContext executionContext, String taskNodeName) {
        Map workflowContext = executionContext.getWorkflowContext();
        VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel = VertexAiGeminiStreamingChatModel.builder().project("").location("us-central1").modelName("gemini-2.5-flash-lite").build();
        Assistant assistant = (Assistant)AiServices.builder(Assistant.class).systemMessageProvider(object -> StringBundler.concat((String[])new String[]{"You are a professional writing editor. Your sole task is to ", "take the provided text and rewrite it to be significantly ", "more concise, direct, and free of unnecessary filler words, ", "nominalizations, and passive voice, while retaining the ", "original meaning and professional tone. Only output the ", "revised, concise text. Do not include any explanation, ", "introduction, or conversation."})).streamingChatModel((StreamingChatModel)vertexAiGeminiStreamingChatModel).build();
        assistant.rewrite("This is the text to be rewritten : " + GetterUtil.getString(workflowContext.get("text"))).onCompleteResponse(response -> this._completeResponse((ChatResponse)response, executionContext, vertexAiGeminiStreamingChatModel)).onError(throwable -> vertexAiGeminiStreamingChatModel.close()).start();
    }

    public String getKey() {
        return "improveWriting";
    }

    private void _completeResponse(ChatResponse chatResponse, ExecutionContext executionContext, VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel) {
        Map workflowContext = executionContext.getWorkflowContext();
        AiMessage aiMessage = chatResponse.aiMessage();
        workflowContext.put("rewrittenText", aiMessage.text());
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        try {
            this._workflowInstanceManager.updateWorkflowContext(kaleoInstanceToken.getCompanyId(), kaleoInstanceToken.getKaleoInstanceId(), workflowContext);
            KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
            this._workflowTaskManager.completeWorkflowTask(kaleoTaskInstanceToken.getCompanyId(), kaleoTaskInstanceToken.getUserId(), kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId(), "end", "", executionContext.getWorkflowContext());
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
        finally {
            vertexAiGeminiStreamingChatModel.close();
        }
    }

    public static interface Assistant {
        public TokenStream rewrite(String var1);
    }
}

