/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/explanation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

public interface ExplanationOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.vertexai.v1.Explanation)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * By default, we provide Shapley values for the predicted class. However,
   * you can configure the explanation request to generate Shapley values for
   * any other classes too. For example, if a model predicts a probability of
   * `0.4` for approving a loan application, the model's decision is to reject
   * the application since `p(reject) = 0.6 &gt; p(approve) = 0.4`, and the default
   * Shapley values would be computed for rejection decision and not approval,
   * even though the latter might be the positive class.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * in descending order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.vertexai.api.Attribution> getAttributionsList();

  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * By default, we provide Shapley values for the predicted class. However,
   * you can configure the explanation request to generate Shapley values for
   * any other classes too. For example, if a model predicts a probability of
   * `0.4` for approving a loan application, the model's decision is to reject
   * the application since `p(reject) = 0.6 &gt; p(approve) = 0.4`, and the default
   * Shapley values would be computed for rejection decision and not approval,
   * even though the latter might be the positive class.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * in descending order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.vertexai.api.Attribution getAttributions(int index);

  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * By default, we provide Shapley values for the predicted class. However,
   * you can configure the explanation request to generate Shapley values for
   * any other classes too. For example, if a model predicts a probability of
   * `0.4` for approving a loan application, the model's decision is to reject
   * the application since `p(reject) = 0.6 &gt; p(approve) = 0.4`, and the default
   * Shapley values would be computed for rejection decision and not approval,
   * even though the latter might be the positive class.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * in descending order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getAttributionsCount();

  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * By default, we provide Shapley values for the predicted class. However,
   * you can configure the explanation request to generate Shapley values for
   * any other classes too. For example, if a model predicts a probability of
   * `0.4` for approving a loan application, the model's decision is to reject
   * the application since `p(reject) = 0.6 &gt; p(approve) = 0.4`, and the default
   * Shapley values would be computed for rejection decision and not approval,
   * even though the latter might be the positive class.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * in descending order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.vertexai.api.AttributionOrBuilder>
      getAttributionsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * By default, we provide Shapley values for the predicted class. However,
   * you can configure the explanation request to generate Shapley values for
   * any other classes too. For example, if a model predicts a probability of
   * `0.4` for approving a loan application, the model's decision is to reject
   * the application since `p(reject) = 0.6 &gt; p(approve) = 0.4`, and the default
   * Shapley values would be computed for rejection decision and not approval,
   * even though the latter might be the positive class.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * in descending order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.vertexai.api.AttributionOrBuilder getAttributionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.vertexai.api.Neighbor> getNeighborsList();

  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.vertexai.api.Neighbor getNeighbors(int index);

  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getNeighborsCount();

  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.vertexai.api.NeighborOrBuilder>
      getNeighborsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.vertexai.api.NeighborOrBuilder getNeighborsOrBuilder(int index);
}
