/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.web.search;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.rest.dto.v1_0.SearchResult;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class LiferayWebSearchEngine
implements WebSearchEngine {
    private static final Log _log = LogFactoryUtil.getLog(LiferayWebSearchEngine.class);
    private final String _blueprintExternalReferenceCode;

    public LiferayWebSearchEngine(String blueprintExternalReferenceCode) {
        this._blueprintExternalReferenceCode = blueprintExternalReferenceCode;
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        try {
            return this._search(webSearchRequest);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return (WebSearchResults)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private String _getAuthorization() throws Exception {
        Base64.Encoder encoder = Base64.getEncoder();
        String userNameAndPassword = "test@liferay.com:" + PropsValues.DEFAULT_ADMIN_PASSWORD;
        return "Basic " + new String(encoder.encode(userNameAndPassword.getBytes("UTF-8")), "UTF-8");
    }

    private WebSearchResults _search(WebSearchRequest webSearchRequest) throws Exception {
        ArrayList<WebSearchOrganicResult> webSearchOrganicResults = new ArrayList<WebSearchOrganicResult>();
        Http.Options options = new Http.Options();
        options.addHeader("Authorization", this._getAuthorization());
        options.addHeader("Content-Type", "application/json");
        String location = "http://localhost:8080/o/search/v1.0/search";
        if (!Validator.isBlank((String)this._blueprintExternalReferenceCode)) {
            location = HttpComponentsUtil.addParameter((String)location, (String)"blueprintExternalReferenceCode", (String)this._blueprintExternalReferenceCode);
        }
        location = HttpComponentsUtil.addParameter((String)location, (String)"page", (int)webSearchRequest.startPage());
        location = HttpComponentsUtil.addParameter((String)location, (String)"pageSize", (int)webSearchRequest.maxResults());
        location = HttpComponentsUtil.addParameter((String)location, (String)"search", (String)webSearchRequest.searchTerms());
        options.setLocation(location);
        options.setMethod(Http.Method.GET);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((Http.Options)options));
        for (JSONObject itemJSONObject : jsonObject.getJSONArray("items")) {
            SearchResult searchResult = SearchResult.toDTO((String)itemJSONObject.toString());
            String url = "";
            if (searchResult.getItemURL() != null) {
                url = searchResult.getItemURL();
            }
            webSearchOrganicResults.add(WebSearchOrganicResult.from((String)searchResult.getTitle(), (URI)URI.create(URLEncoder.encode(url, "UTF-8")), null, (String)searchResult.getDescription(), Map.of("score", String.valueOf(searchResult.getScore()))));
        }
        return WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)jsonObject.getLong("totalCount")), webSearchOrganicResults);
    }
}

