/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal;

import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal.configuration.AMBackwardsCompatibilityHtmlContentTransformerConfiguration;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal.configuration.AMBackwardsCompatibilityHtmlContentTransformerConfiguration"}, service={ContentTransformer.class})
public class AMBackwardsCompatibilityHtmlContentTransformer
implements ContentTransformer {
    private static final String _ATTRIBUTE_TOKEN_SRC = "src=";
    private static final String _CLOSE_TAG_TOKEN_PICTURE = "</picture>";
    private static final String _OPEN_TAG_TOKEN_IMG = "<img";
    private static final String _OPEN_TAG_TOKEN_PICTURE = "<picture";
    private static final Log _log = LogFactoryUtil.getLog(AMBackwardsCompatibilityHtmlContentTransformer.class);
    private static final Pattern _pattern = Pattern.compile("((?:/?[^\\s]*)/documents/(\\d+)/(\\d+)/([^/?]+)(?:/([-0-9a-fA-F]+))?(?:\\?.*$)?)|((?:/?[^\\s]*)/documents/(d)/(.*)/([_A-Za-z0-9-]+)?(?:\\?.*$)?)");
    private volatile AMBackwardsCompatibilityHtmlContentTransformerConfiguration _amBackwardsCompatibilityHtmlContentTransformerConfiguration;
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String transform(String html) throws PortalException {
        if (!this._amBackwardsCompatibilityHtmlContentTransformerConfiguration.enabled()) {
            return html;
        }
        if (html == null) {
            return null;
        }
        if (!html.contains("/documents/") || !html.contains(_OPEN_TAG_TOKEN_IMG)) {
            return html;
        }
        StringBundler sb = new StringBundler();
        int lastIndex = 0;
        while (lastIndex < html.length()) {
            int pictureStart = html.indexOf(_OPEN_TAG_TOKEN_PICTURE, lastIndex);
            if (pictureStart == -1) {
                pictureStart = html.length();
            }
            this._transformImgTags(html, lastIndex, pictureStart, sb);
            if (pictureStart < html.length()) {
                int pictureEnd = html.indexOf(_CLOSE_TAG_TOKEN_PICTURE, pictureStart + _OPEN_TAG_TOKEN_PICTURE.length());
                pictureEnd = pictureEnd == -1 ? html.length() : (pictureEnd += _CLOSE_TAG_TOKEN_PICTURE.length());
                sb.append(html.substring(pictureStart, pictureEnd));
                lastIndex = pictureEnd;
                continue;
            }
            lastIndex = pictureStart;
        }
        return sb.toString();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._amBackwardsCompatibilityHtmlContentTransformerConfiguration = (AMBackwardsCompatibilityHtmlContentTransformerConfiguration)ConfigurableUtil.createConfigurable(AMBackwardsCompatibilityHtmlContentTransformerConfiguration.class, properties);
    }

    private FileEntry _getFileEntry(Matcher matcher) throws PortalException {
        if (Objects.equals("d", matcher.group(7))) {
            FileEntry fileEntry = this._resolveFileEntry(matcher.group(9), matcher.group(8));
            if (fileEntry == null) {
                throw new PortalException("No file entry found for friendly URL " + matcher.group(0));
            }
            return fileEntry;
        }
        if (matcher.group(5) != null) {
            long groupId = GetterUtil.getLong((String)matcher.group(2));
            String uuid = matcher.group(5);
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        long groupId = GetterUtil.getLong((String)matcher.group(2));
        long folderId = GetterUtil.getLong((String)matcher.group(3));
        String title = matcher.group(4);
        try {
            return this._dlAppLocalService.getFileEntry(groupId, folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return this._dlAppLocalService.getFileEntryByFileName(groupId, folderId, title);
        }
    }

    private Group _getGroup(long companyId, String name) throws PortalException {
        Group group = this._groupLocalService.fetchFriendlyURLGroup(companyId, "/" + name);
        if (group != null) {
            return group;
        }
        User user = this._userLocalService.getUserByScreenName(companyId, name);
        return user.getGroup();
    }

    private String _getReplacement(String originalImgTag, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null || !this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType())) {
            return originalImgTag;
        }
        return this._amImageHTMLTagFactory.create(originalImgTag, fileEntry);
    }

    private FileEntry _resolveFileEntry(String friendlyURL, String groupName) throws PortalException {
        Group group = this._getGroup(CompanyThreadLocal.getCompanyId(), groupName);
        return this._fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), friendlyURL);
    }

    private String _transform(String imgElementString, String src) throws PortalException {
        if (src.startsWith("data:image/")) {
            return imgElementString;
        }
        if (!src.contains("/documents")) {
            return imgElementString;
        }
        String replacement = imgElementString;
        StringBuffer sb = null;
        Matcher matcher = _pattern.matcher(src);
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer(imgElementString.length());
            }
            FileEntry fileEntry = null;
            if (!imgElementString.contains("data-fileentryid")) {
                fileEntry = this._getFileEntry(matcher);
            }
            replacement = this._getReplacement(imgElementString, fileEntry);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        if (sb != null) {
            matcher.appendTail(sb);
            replacement = sb.toString();
        }
        return replacement;
    }

    private void _transformImgTags(String html, int start, int end, StringBundler sb) throws PortalException {
        int lastIndex = start;
        while (lastIndex < end) {
            int imgStart = html.indexOf(_OPEN_TAG_TOKEN_IMG, lastIndex);
            if (imgStart == -1 || imgStart > end) {
                sb.append(html.substring(lastIndex, end));
                return;
            }
            sb.append(html.substring(lastIndex, imgStart));
            int imgEnd = html.indexOf(62, imgStart) + 1;
            int attributeListPos = imgStart + _OPEN_TAG_TOKEN_IMG.length();
            int srcStart = html.indexOf(_ATTRIBUTE_TOKEN_SRC, attributeListPos);
            if (srcStart == -1 || srcStart > imgEnd) {
                sb.append(html.substring(imgStart, imgEnd));
                lastIndex = imgEnd;
                continue;
            }
            int quotePos = srcStart + _ATTRIBUTE_TOKEN_SRC.length();
            int srcEnd = html.indexOf(html.charAt(quotePos), quotePos + 1);
            sb.append(this._transform(html.substring(imgStart, imgEnd), html.substring(quotePos + 1, srcEnd)));
            lastIndex = imgEnd;
        }
    }
}

