/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal;

import com.liferay.adaptive.media.content.transformer.BaseRegexStringContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentTransformer.class})
public class AMBackwardsCompatibilityHtmlContentTransformer
extends BaseRegexStringContentTransformer {
    private static final Log _log = LogFactoryUtil.getLog(AMBackwardsCompatibilityHtmlContentTransformer.class);
    private static final Pattern _pattern = Pattern.compile("((?:/?[^\\s]*)/documents/(\\d+)/(\\d+)/([^/?]+)(?:/([-0-9a-fA-F]+))?(?:\\?t=\\d+)?)|((?:/?[^\\s]*)/documents/(d)/(.*)/([_A-Za-z0-9-]+)?)");
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String transform(String html) throws PortalException {
        if (html == null) {
            return null;
        }
        if (!html.contains("/documents/") || !this._hasStandaloneImgTag(html)) {
            return html;
        }
        Document document = this._parseDocument(html);
        for (Element imgElement : document.select("img:not(picture > img)")) {
            String imgElementString = imgElement.toString();
            String replacement = this._transform(imgElementString, imgElement.attr("src"));
            imgElement.replaceWith(this._parseNode(replacement));
        }
        if (html.contains("<html>") || html.contains("<head>")) {
            return document.html();
        }
        Element body = document.body();
        return body.html();
    }

    protected FileEntry getFileEntry(Matcher matcher) throws PortalException {
        if (Objects.equals("d", matcher.group(7))) {
            FileEntry fileEntry = this._resolveFileEntry(matcher.group(9), matcher.group(8));
            if (fileEntry == null) {
                throw new PortalException("No file entry found for friendly URL " + matcher.group(0));
            }
            return fileEntry;
        }
        if (matcher.group(5) != null) {
            long groupId = GetterUtil.getLong((String)matcher.group(2));
            String uuid = matcher.group(5);
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        long groupId = GetterUtil.getLong((String)matcher.group(2));
        long folderId = GetterUtil.getLong((String)matcher.group(3));
        String title = matcher.group(4);
        try {
            return this._dlAppLocalService.getFileEntry(groupId, folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return this._dlAppLocalService.getFileEntryByFileName(groupId, folderId, title);
        }
    }

    protected Pattern getPattern() {
        return _pattern;
    }

    protected String getReplacement(String originalImgTag, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null || !this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType())) {
            return originalImgTag;
        }
        return this._amImageHTMLTagFactory.create(originalImgTag, fileEntry);
    }

    protected boolean isSupported(FileEntry fileEntry) {
        return this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType());
    }

    private Group _getGroup(long companyId, String name) throws PortalException {
        Group group = this._groupLocalService.fetchFriendlyURLGroup(companyId, "/" + name);
        if (group != null) {
            return group;
        }
        User user = this._userLocalService.getUserByScreenName(companyId, name);
        return user.getGroup();
    }

    private boolean _hasStandaloneImgTag(String html) {
        int index = -1;
        while ((index = html.indexOf("<img", index)) != -1) {
            int openStart = html.lastIndexOf("<picture", index);
            if (openStart == -1) {
                return true;
            }
            int closeStart = html.lastIndexOf("</picture>", index);
            if (closeStart != -1 && openStart > closeStart) {
                return true;
            }
            index += 4;
        }
        return false;
    }

    private Document _parseDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        return document;
    }

    private Node _parseNode(String tag) {
        Document document = this._parseDocument(tag);
        Element bodyNode = document.body();
        return bodyNode.childNode(0);
    }

    private FileEntry _resolveFileEntry(String friendlyURL, String groupName) throws PortalException {
        Group group = this._getGroup(CompanyThreadLocal.getCompanyId(), groupName);
        return this._fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), friendlyURL);
    }

    private String _transform(String imgElementString, String src) throws PortalException {
        if (src.startsWith("data:image/")) {
            return imgElementString;
        }
        if (!src.contains("/documents")) {
            return imgElementString;
        }
        String replacement = imgElementString;
        StringBuffer sb = null;
        Pattern pattern = this.getPattern();
        Matcher matcher = pattern.matcher(src);
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer(imgElementString.length());
            }
            FileEntry fileEntry = null;
            if (!imgElementString.contains("data-fileentryid")) {
                fileEntry = this.getFileEntry(matcher);
            }
            replacement = this.getReplacement(imgElementString, fileEntry);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        if (sb != null) {
            matcher.appendTail(sb);
            replacement = sb.toString();
        }
        return replacement;
    }
}

