/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.editor.configuration.internal;

import com.liferay.adaptive.media.image.item.selector.AMImageFileEntryItemSelectorReturnType;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAMEditorConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    protected ItemSelector itemSelector;
    private static final String _IMG_TAG_RULE = "img[*](*){*};";

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        String itemSelectorURL;
        Object allowedContent = jsonObject.getString("allowedContent");
        if (Validator.isNotNull((String)allowedContent) && !((String)allowedContent).equals(Boolean.TRUE.toString()) && !((String)allowedContent).contains(_IMG_TAG_RULE)) {
            allowedContent = (String)allowedContent + " img[*](*){*};";
            jsonObject.put("allowedContent", (String)allowedContent);
        }
        if (Validator.isNull((String)(itemSelectorURL = jsonObject.getString("filebrowserImageBrowseLinkUrl")))) {
            return;
        }
        List itemSelectorCriteria = this.itemSelector.getItemSelectorCriteria(itemSelectorURL);
        boolean amImageURLItemSelectorReturnTypeAdded = false;
        for (ItemSelectorCriterion itemSelectorCriterion : itemSelectorCriteria) {
            if (!this.isItemSelectorCriterionOverridable(itemSelectorCriterion)) continue;
            this.addAMImageFileEntryItemSelectorReturnType(itemSelectorCriterion);
            amImageURLItemSelectorReturnTypeAdded = true;
        }
        if (!amImageURLItemSelectorReturnTypeAdded) {
            return;
        }
        jsonObject.put("adaptiveMediaFileEntryAttributeName", "data-fileentryid");
        Object extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = Validator.isNotNull((String)extraPlugins) ? (String)extraPlugins + ",adaptivemedia" : "adaptivemedia";
        jsonObject.put("extraPlugins", (String)extraPlugins);
        PortletURL itemSelectorPortletURL = this.itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, this.itemSelector.getItemSelectedEventName(itemSelectorURL), itemSelectorCriteria.toArray(new ItemSelectorCriterion[0]));
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorPortletURL.toString()).put("filebrowserImageBrowseUrl", itemSelectorPortletURL.toString());
    }

    protected void addAMImageFileEntryItemSelectorReturnType(ItemSelectorCriterion itemSelectorCriterion) {
        List desiredItemSelectorReturnTypes = itemSelectorCriterion.getDesiredItemSelectorReturnTypes();
        desiredItemSelectorReturnTypes.add(0, new AMImageFileEntryItemSelectorReturnType());
    }

    protected abstract boolean isItemSelectorCriterionOverridable(ItemSelectorCriterion var1);
}

