/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands;

import com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands.configuration.ThumbnailConfiguration;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.osgi.util.osgi.commands.OSGiCommands;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.image.ImageToolUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.function=check", "osgi.command.function=cleanUp", "osgi.command.function=migrate", "osgi.command.scope=thumbnails"}, service={OSGiCommands.class})
public class AMThumbnailsOSGiCommands
implements OSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(AMThumbnailsOSGiCommands.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference(target="(default=true)")
    private Store _store;

    public void check(String ... companyIds) {
        System.out.println("Company ID\t# of thumbnails pending migration");
        System.out.println("-------------------------------------------------");
        AtomicInteger count = new AtomicInteger();
        this._companyLocalService.forEachCompanyId(companyId -> this._countPendingThumbnails((Long)companyId, count));
        System.out.printf("%nTOTAL: %d%n", count.get());
    }

    public void cleanUp(String ... companyIds) {
        this._companyLocalService.forEachCompanyId(companyId -> this._cleanUp((long)companyId), this._getCompanyIds(companyIds));
    }

    public void migrate(String ... companyIds) throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> this._migrate((Long)companyId), this._getCompanyIds(companyIds));
    }

    private void _cleanUp(long companyId) {
        String[] fileNames;
        for (String fileName : fileNames = this._store.getFileNames(companyId, 0L, "document_thumbnail/")) {
            String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
            for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                if (fileVersion == null) continue;
                this._store.deleteDirectory(companyId, 0L, actualFileName);
            }
        }
    }

    private void _countPendingThumbnails(Long companyId, AtomicInteger count) {
        String[] fileNames = this._store.getFileNames(companyId.longValue(), 0L, "document_thumbnail/");
        int companyTotal = 0;
        for (String fileName : fileNames) {
            String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
            for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                if (fileVersion == null) continue;
                companyTotal = 1;
            }
        }
        System.out.printf("%d\t\t%d%n", companyId, companyTotal);
        count.addAndGet(companyTotal);
    }

    private long[] _getCompanyIds(String ... companyIds) {
        if (companyIds.length == 0) {
            return ListUtil.toLongArray((List)this._companyLocalService.getCompanies(), CompanyModel::getCompanyId);
        }
        return ListUtil.toLongArray(Arrays.asList(companyIds), Long::parseLong);
    }

    private FileVersion _getFileVersion(long fileVersionId) {
        try {
            if (fileVersionId == 0L) {
                return null;
            }
            FileVersion fileVersion = this._dlAppLocalService.getFileVersion(fileVersionId);
            if (!this._isMimeTypeSupported(fileVersion)) {
                return null;
            }
            return fileVersion;
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }

    private ThumbnailConfiguration[] _getThumbnailConfigurations() {
        return new ThumbnailConfiguration[]{new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-1(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-2(?:\\..+)?$"))};
    }

    private boolean _isMimeTypeSupported(FileVersion fileVersion) {
        return ArrayUtil.contains((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes(), (Object)fileVersion.getMimeType());
    }

    private boolean _isValidConfigurationEntries(Collection<AMImageConfigurationEntry> amImageConfigurationEntries) {
        for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
            for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
                if (!thumbnailConfiguration.matches(amImageConfigurationEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private void _migrate(Long companyId) throws PortalException {
        String[] fileNames;
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId.longValue());
        if (!this._isValidConfigurationEntries(amImageConfigurationEntries)) {
            throw new PortalException("No valid Adaptive Media configuration found. Please refer to the upgrade documentation for the details.");
        }
        for (String fileName : fileNames = this._store.getFileNames(companyId.longValue(), 0L, "document_thumbnail/")) {
            String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
            for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                AMImageConfigurationEntry amImageConfigurationEntry = thumbnailConfiguration.selectMatchingConfigurationEntry(amImageConfigurationEntries);
                if (amImageConfigurationEntry == null) continue;
                this._migrate(actualFileName, amImageConfigurationEntry, thumbnailConfiguration);
            }
        }
    }

    private void _migrate(String fileName, AMImageConfigurationEntry amImageConfigurationEntry, ThumbnailConfiguration thumbnailConfiguration) {
        try {
            FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(fileName));
            if (fileVersion == null) {
                return;
            }
            AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
            if (amImageEntry != null) {
                return;
            }
            byte[] bytes = StreamUtil.toByteArray((InputStream)this._store.getFileAsStream(fileVersion.getCompanyId(), 0L, fileName, ""));
            ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, fileVersion, renderedImage.getHeight(), renderedImage.getWidth(), (InputStream)new UnsyncByteArrayInputStream(bytes), (long)bytes.length);
        }
        catch (PortalException | IOException exception) {
            _log.error(exception);
        }
    }
}

