/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Frame;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;

public class TaintFrame
extends Frame<Taint> {
    public TaintFrame(int numLocals) {
        super(numLocals);
    }

    public String toString(MethodGen method) {
        String[] variables = new String[method.getLocalVariables().length];
        LocalVariableGen[] variablesGen = method.getLocalVariables();
        for (int i = 0; i < variablesGen.length; ++i) {
            variables[i] = variablesGen[i].getName();
        }
        return this.toString(variables);
    }

    public String toString() {
        return this.toString(new String[this.getNumLocals()]);
    }

    public String toString(String[] variableNames) {
        StringBuilder str = new StringBuilder();
        try {
            str.append("+============================\n");
            if (!FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
                str.append("| /!\\ Warning : The taint debugging is not fully activated.\n");
            }
            str.append("| [[ Stack ]]\n");
            int stackDepth = this.getStackDepth();
            for (int i = 0; i < stackDepth; ++i) {
                Taint taintValue = (Taint)this.getStackValue(i);
                str.append(String.format("| %s. %s {%s}\n", i, taintValue.getState().toString(), taintValue.toString()));
            }
            if (stackDepth == 0) {
                str.append("| Empty\n");
            }
            str.append("|============================\n");
            str.append("| [[ Local variables ]]\n");
            int nb = this.getNumLocals();
            for (int i = 0; i < nb; ++i) {
                Taint taintValue = (Taint)this.getValue(i);
                str.append("| ").append(variableNames[i]).append(" = ").append(taintValue == null ? "<not set>" : taintValue.toString()).append("\n");
            }
            str.append("+============================\n");
        }
        catch (DataflowAnalysisException e) {
            str.append("Oups " + e.getMessage());
        }
        return str.toString();
    }
}

