/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.StackUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class DesUsageDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = false;
    private static final String DES_USAGE_TYPE = "DES_USAGE";
    private BugReporter bugReporter;

    public DesUsageDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 184) {
            String cipherValue;
            OpcodeStack.Item item;
            if (this.getClassConstantOperand().equals("javax/crypto/Cipher") && this.getNameConstantOperand().equals("getInstance")) {
                if (this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljavax/crypto/Cipher;")) {
                    item = this.stack.getStackItem(0);
                } else if (this.getSigConstantOperand().equals("(Ljava/lang/String;Ljava/lang/String;)Ljavax/crypto/Cipher;")) {
                    item = this.stack.getStackItem(1);
                } else if (this.getSigConstantOperand().equals("(Ljava/lang/String;Ljava/security/Provider;)Ljavax/crypto/Cipher;")) {
                    item = this.stack.getStackItem(1);
                } else {
                    return;
                }
                if (StackUtils.isConstantString(item) && ((cipherValue = ((String)item.getConstant()).toLowerCase()).equals("des") || cipherValue.startsWith("des/") || cipherValue.startsWith("desede/"))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, DES_USAGE_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            if (this.getClassConstantOperand().equals("javax/crypto/KeyGenerator") && this.getNameConstantOperand().equals("getInstance")) {
                if (this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljavax/crypto/KeyGenerator;")) {
                    item = this.stack.getStackItem(0);
                } else if (this.getSigConstantOperand().equals("(Ljava/lang/String;Ljava/lang/String;)Ljavax/crypto/KeyGenerator;")) {
                    item = this.stack.getStackItem(1);
                } else if (this.getSigConstantOperand().equals("(Ljava/lang/String;Ljava/security/Provider;)Ljavax/crypto/KeyGenerator;")) {
                    item = this.stack.getStackItem(1);
                } else {
                    return;
                }
                if (StackUtils.isConstantString(item) && ((cipherValue = ((String)item.getConstant()).toLowerCase()).equals("des") || cipherValue.equals("desede"))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, DES_USAGE_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }
}

