/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.StackUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Pattern;

public class CipherWithNoIntegrityDetector
extends OpcodeStackDetector {
    private static final String ECB_MODE_TYPE = "ECB_MODE";
    private static final String PADDING_ORACLE_TYPE = "PADDING_ORACLE";
    private static final String CIPHER_INTEGRITY_TYPE = "CIPHER_INTEGRITY";
    private static final Pattern AUTHENTICATED_CIPHER_MODES = Pattern.compile(".*/(CCM|CWC|OCB|EAX|GCM)/.*");
    private static final Pattern INSECURE_ECB_MODES = Pattern.compile("(AES|DES(ede)?)(/ECB/.*)?");
    private final BugReporter bugReporter;

    public CipherWithNoIntegrityDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 184 || !this.getClassConstantOperand().equals("javax/crypto/Cipher") || !this.getNameConstantOperand().equals("getInstance")) {
            return;
        }
        OpcodeStack.Item item = this.stack.getStackItem(this.getSigConstantOperand().contains(";L") ? 1 : 0);
        if (!StackUtils.isConstantString(item)) {
            return;
        }
        String cipherValue = (String)item.getConstant();
        if (INSECURE_ECB_MODES.matcher(cipherValue).matches()) {
            this.reportBug(ECB_MODE_TYPE);
        }
        if (cipherValue.contains("/CBC/PKCS5Padding")) {
            this.reportBug(PADDING_ORACLE_TYPE);
        }
        if (!AUTHENTICATED_CIPHER_MODES.matcher(cipherValue).matches() && !cipherValue.startsWith("RSA")) {
            this.reportBug(CIPHER_INTEGRITY_TYPE);
        }
    }

    private void reportBug(String type) {
        this.bugReporter.reportBug(new BugInstance((Detector)this, type, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }
}

