/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.redirect;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;

public class RedirectionSource
implements InjectionSource {
    private static final String UNVALIDATED_REDIRECT_TYPE = "UNVALIDATED_REDIRECT";

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEINTERFACE) {
            String methodName = ins.getMethodName(cpg);
            String className = ins.getReferenceType(cpg).toString();
            if (className.equals("javax.servlet.http.HttpServletResponse") || className.equals("javax.servlet.http.HttpServletResponseWrapper")) {
                Object value;
                LDC ldc;
                if (methodName.equals("sendRedirect")) {
                    InjectionPoint ip = new InjectionPoint(new int[]{0}, UNVALIDATED_REDIRECT_TYPE);
                    ip.setInjectableMethod(className.concat(".sendRedirect(...)"));
                    return ip;
                }
                if ((methodName.equals("addHeader") || methodName.equals("setHeader")) && (ldc = ByteCode.getPrevInstruction(insHandle, LDC.class)) != null && (value = ldc.getValue(cpg)) != null && "Location".equalsIgnoreCase((String)value)) {
                    InjectionPoint ip = new InjectionPoint(new int[]{0}, UNVALIDATED_REDIRECT_TYPE);
                    ip.setInjectableMethod(className + "." + methodName + "(\"Location\", ...)");
                    return ip;
                }
            }
        }
        return InjectionPoint.NONE;
    }
}

