/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class InsecureSmtpSslDetector
implements Detector {
    private static final String INSECURE_SMTP_SSL = "INSECURE_SMTP_SSL";
    private static final List<String> INSECURE_APIS = Arrays.asList("org.apache.commons.mail.Email", "org.apache.commons.mail.HtmlEmail", "org.apache.commons.mail.ImageHtmlEmail", "org.apache.commons.mail.MultiPartEmail");
    private final BugReporter bugReporter;

    public InsecureSmtpSslDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        HashMap<Location, String> sslConnMap = new HashMap<Location, String>();
        HashSet<String> sslCertVerSet = new HashSet<String>();
        Object locationWeakness = null;
        String hostName = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Integer checkOn;
            Integer sslOn;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof INVOKEVIRTUAL)) continue;
            INVOKEVIRTUAL invoke = (INVOKEVIRTUAL)inst;
            if (INSECURE_APIS.contains(invoke.getClassName(cpg)) && "setHostName".equals(invoke.getMethodName(cpg))) {
                hostName = ByteCode.getConstantLDC(location.getHandle().getPrev(), cpg, String.class);
            }
            if (INSECURE_APIS.contains(invoke.getClassName(cpg)) && "setSSLOnConnect".equals(invoke.getMethodName(cpg)) && (sslOn = ByteCode.getConstantInt(location.getHandle().getPrev())) != null && sslOn == 1) {
                sslConnMap.put(location, invoke.getClassName(cpg) + hostName);
            }
            if (!INSECURE_APIS.contains(invoke.getClassName(cpg)) || !"setSSLCheckServerIdentity".equals(invoke.getMethodName(cpg)) || (checkOn = ByteCode.getConstantInt(location.getHandle().getPrev())) == null || checkOn != 1) continue;
            sslCertVerSet.add(invoke.getClassName(cpg) + hostName);
        }
        sslConnMap.values().removeAll(sslCertVerSet);
        if (!sslConnMap.isEmpty()) {
            for (Location key : sslConnMap.keySet()) {
                JavaClass clz = classContext.getJavaClass();
                this.bugReporter.reportBug(new BugInstance((Detector)this, INSECURE_SMTP_SSL, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, key));
            }
        }
    }

    public void report() {
    }
}

