/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class TaintAnalysis
extends FrameDataflowAnalysis<Taint, TaintFrame> {
    private final MethodGen methodGen;
    private final MethodInfo methodDescriptor;
    private final TaintFrameModelingVisitor visitor;
    private int parameterStackSize;
    private List<Integer> slotToParameter;
    private static final List<String> TAINTED_ANNOTATIONS = TaintAnalysis.loadFileContent("taint-config/taint-param-annotations.txt");

    public TaintAnalysis(MethodGen methodGen, DepthFirstSearch dfs, MethodDescriptor descriptor, TaintConfig taintConfig) {
        super(dfs);
        this.methodGen = methodGen;
        this.methodDescriptor = (MethodInfo)descriptor;
        this.visitor = new TaintFrameModelingVisitor(methodGen.getConstantPool(), descriptor, taintConfig);
        this.computeParametersInfo(descriptor.getSignature(), descriptor.isStatic());
    }

    protected void mergeValues(TaintFrame frame, TaintFrame result, int i) throws DataflowAnalysisException {
        result.setValue(i, Taint.merge((Taint)result.getValue(i), (Taint)frame.getValue(i)));
    }

    public void transferInstruction(InstructionHandle handle, BasicBlock block, TaintFrame fact) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(fact, new Location(handle, block));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    public TaintFrame createFact() {
        return new TaintFrame(this.methodGen.getMaxLocals());
    }

    public void initEntryFact(TaintFrame fact) {
        fact.setValid();
        fact.clearStack();
        boolean inMainMethod = this.isInMainMethod();
        int numSlots = fact.getNumSlots();
        int numLocals = fact.getNumLocals();
        for (int i = 0; i < numSlots; ++i) {
            Taint value = new Taint(Taint.State.UNKNOWN);
            if (i < numLocals) {
                if (i < this.parameterStackSize) {
                    if (this.isTaintedByAnnotation(i - 1)) {
                        value = new Taint(Taint.State.TAINTED);
                    } else if (inMainMethod) {
                        value = FindSecBugsGlobalConfig.getInstance().isTaintedMainArgument() ? new Taint(Taint.State.TAINTED) : new Taint(Taint.State.SAFE);
                    } else {
                        int stackOffset = this.parameterStackSize - i - 1;
                        value.addParameter(stackOffset);
                    }
                }
                value.setVariableIndex(i);
            }
            fact.setValue(i, value);
        }
    }

    private boolean isInMainMethod() {
        return this.methodDescriptor.isStatic() && "main".equals(this.methodDescriptor.getName()) && "([Ljava/lang/String;)V".equals(this.methodDescriptor.getSignature()) && this.methodGen.getMethod().isPublic();
    }

    private boolean isTaintedByAnnotation(int slotNo) {
        if (slotNo >= 0 && this.methodDescriptor.hasParameterAnnotations()) {
            int parameter = this.slotToParameter.get(slotNo);
            Collection annotations = this.methodDescriptor.getParameterAnnotations(parameter);
            for (AnnotationValue annotation : annotations) {
                if (!TAINTED_ANNOTATIONS.contains(annotation.getAnnotationClass().getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    public void meetInto(TaintFrame fact, Edge edge, TaintFrame result) throws DataflowAnalysisException {
        if (fact.isValid() && edge.isExceptionEdge()) {
            TaintFrame copy = null;
            copy = (TaintFrame)this.modifyFrame(fact, copy);
            copy.clearStack();
            copy.pushValue(new Taint(Taint.State.UNKNOWN));
            fact = copy;
        }
        this.mergeInto(fact, result);
    }

    public void finishAnalysis() {
        this.visitor.finishAnalysis();
    }

    private void computeParametersInfo(String signature, boolean isStatic) {
        assert (signature != null && !signature.isEmpty());
        int stackSize = isStatic ? 0 : 1;
        GenericSignatureParser parser = new GenericSignatureParser(signature);
        Iterator iterator = parser.parameterSignatureIterator();
        int paramIdx = 0;
        this.slotToParameter = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (parameter.equals("D") || parameter.equals("J")) {
                stackSize += 2;
                this.slotToParameter.add(paramIdx);
                this.slotToParameter.add(paramIdx);
            } else {
                ++stackSize;
                this.slotToParameter.add(paramIdx);
            }
            ++paramIdx;
        }
        this.parameterStackSize = stackSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadFileContent(String path) {
        BufferedReader stream = null;
        try {
            String line;
            InputStream in = TaintAnalysis.class.getClassLoader().getResourceAsStream(path);
            stream = new BufferedReader(new InputStreamReader(in, "utf-8"));
            ArrayList<String> content = new ArrayList<String>();
            while ((line = stream.readLine()) != null) {
                content.add(line.trim());
            }
            ArrayList<String> arrayList = content;
            IO.close((Closeable)stream);
            return arrayList;
        }
        catch (IOException ex) {
            assert (false) : ex.getMessage();
        }
        finally {
            IO.close(stream);
        }
        return new ArrayList<String>();
    }
}

