/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import com.h3xstream.findsecbugs.common.StackUtils;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class JndiCredentialsDetector
extends OpcodeStackDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private final BugReporter bugReporter;
    private static final InvokeMatcherBuilder HASHTABLE_PUT_METHOD = InstructionDSL.invokeInstruction().atMethod("put").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");

    public JndiCredentialsDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && HASHTABLE_PUT_METHOD.matches(this) && InterfaceUtils.isSubtype(this.getClassConstantOperand(), "java.util.Hashtable")) {
            OpcodeStack.Item item1 = this.stack.getStackItem(1);
            OpcodeStack.Item item0 = this.stack.getStackItem(0);
            if (StackUtils.isConstantString(item1) && "java.naming.security.credentials".equals((String)item1.getConstant()) && StackUtils.isConstantString(item0)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, HARD_CODE_PASSWORD_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }
}

