/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfig;
import java.io.IOException;
import java.util.regex.Pattern;

public class TaintMethodConfigWithArgumentsAndLocation
extends TaintMethodConfig {
    private static final Pattern methodWithStringConstantOrEnumPattern;
    private String location;

    public TaintMethodConfigWithArgumentsAndLocation() {
        super(true);
    }

    public static boolean accepts(String typeSignature, String summary) {
        int pos = summary.lastIndexOf(64);
        if (pos < 0) {
            return false;
        }
        summary = summary.substring(0, pos);
        return methodWithStringConstantOrEnumPattern.matcher(typeSignature).matches() && TaintMethodConfig.summaryPattern.matcher(summary).matches();
    }

    @Override
    public TaintMethodConfigWithArgumentsAndLocation load(String summary) throws IOException {
        if (summary == null) {
            throw new NullPointerException("string is null");
        }
        if ((summary = summary.trim()).isEmpty()) {
            throw new IOException("No taint method summary specified");
        }
        int locationPos = summary.lastIndexOf(64);
        if (locationPos < 0) {
            throw new IOException("Bad format: @ expected");
        }
        this.location = summary.substring(locationPos + 1).trim();
        summary = summary.substring(0, locationPos);
        super.load(summary);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    static {
        String classWithPackageRegex = "([a-z][a-z0-9]*\\/)*[A-Z][a-zA-Z0-9\\$]*";
        String methodRegex = "(([a-zA-Z][a-zA-Z0-9]*)|(<init>))";
        String stringConstantRegex = "\"[^\"]*\"";
        String enumNameRegex = "[A-Z_]+";
        String methodArguments = "(" + stringConstantRegex + ",?|" + enumNameRegex + ",?)*";
        String methodWithStringConstantOrEnumRegex = classWithPackageRegex + "\\." + methodRegex + "\\(" + methodArguments + "\\)";
        methodWithStringConstantOrEnumPattern = Pattern.compile(methodWithStringConstantOrEnumRegex);
    }
}

