/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintClassConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintConfigLoader;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfigWithArgumentsAndLocation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class TaintConfig
extends HashMap<String, TaintMethodConfig> {
    private static final long serialVersionUID = 1L;
    private final Map<String, TaintClassConfig> taintClassSummaryMap = new HashMap<String, TaintClassConfig>();
    private final Map<String, TaintMethodConfigWithArgumentsAndLocation> taintMethodConfigWithArgumentsAndLocationMap = new HashMap<String, TaintMethodConfigWithArgumentsAndLocation>();

    public void dump(PrintStream output) {
        TreeSet keys = new TreeSet(this.keySet());
        for (String key : keys) {
            output.println(key + ":" + this.get(key));
        }
    }

    public void load(InputStream input, final boolean checkRewrite) throws IOException {
        new TaintConfigLoader().load(input, new TaintConfigLoader.TaintConfigReceiver(){

            @Override
            public void receiveTaintConfigSummary(String typeSignature, String summary) throws IOException {
                if (TaintMethodConfig.accepts(typeSignature, summary)) {
                    if (checkRewrite && TaintConfig.this.containsKey(typeSignature)) {
                        throw new IllegalStateException("Summary for " + typeSignature + " already loaded");
                    }
                    TaintMethodConfig taintMethodSummary = new TaintMethodConfig(true).load(summary);
                    TaintConfig.this.put(typeSignature, taintMethodSummary);
                    return;
                }
                if (TaintClassConfig.accepts(typeSignature, summary)) {
                    if (checkRewrite && TaintConfig.this.taintClassSummaryMap.containsKey(typeSignature)) {
                        throw new IllegalStateException("Summary for " + typeSignature + " already loaded");
                    }
                    TaintClassConfig taintClassSummary = new TaintClassConfig().load(summary);
                    TaintConfig.this.taintClassSummaryMap.put(typeSignature, taintClassSummary);
                    return;
                }
                if (TaintMethodConfigWithArgumentsAndLocation.accepts(typeSignature, summary)) {
                    if (checkRewrite && TaintConfig.this.taintMethodConfigWithArgumentsAndLocationMap.containsKey(typeSignature)) {
                        throw new IllegalStateException("Summary for " + typeSignature + " already loaded");
                    }
                    TaintMethodConfigWithArgumentsAndLocation methodConfig = new TaintMethodConfigWithArgumentsAndLocation().load(summary);
                    String key = typeSignature + '@' + methodConfig.getLocation();
                    TaintConfig.this.taintMethodConfigWithArgumentsAndLocationMap.put(key, methodConfig);
                    return;
                }
                throw new IllegalArgumentException("Invalid full method name " + typeSignature + " configured");
            }
        });
    }

    public boolean isClassImmutable(String typeSignature) {
        if (!this.isClassType(typeSignature)) {
            return false;
        }
        TaintClassConfig summary = this.taintClassSummaryMap.get(typeSignature);
        if (summary == null) {
            return false;
        }
        return summary.isImmutable();
    }

    public boolean isClassTaintSafe(String typeSignature) {
        if (!this.isClassType(typeSignature)) {
            return false;
        }
        TaintClassConfig taintClassSummary = this.getClassSummary(typeSignature);
        if (taintClassSummary == null) {
            return false;
        }
        return taintClassSummary.getTaintState().equals((Object)Taint.State.SAFE);
    }

    public Taint.State getClassTaintState(String typeSignature, Taint.State defaultState) {
        if (!this.isClassType(typeSignature)) {
            return defaultState;
        }
        TaintClassConfig taintClassSummary = this.getClassSummary(typeSignature);
        if (taintClassSummary == null) {
            return defaultState;
        }
        Taint.State classSummaryTaintState = taintClassSummary.getTaintState();
        if (classSummaryTaintState.equals((Object)TaintClassConfig.DEFAULT_TAINT_STATE)) {
            return defaultState;
        }
        return classSummaryTaintState;
    }

    public TaintClassConfig getClassSummary(String typeSignature) {
        if (!this.isClassType(typeSignature)) {
            return null;
        }
        return this.taintClassSummaryMap.get(typeSignature);
    }

    private boolean isClassType(String typeSignature) {
        return typeSignature != null && typeSignature.length() > 2 && typeSignature.charAt(0) == 'L';
    }

    public TaintMethodConfig getMethodSummary(TaintFrame frame, MethodDescriptor methodDescriptor, String className, String methodId) {
        TaintMethodConfig taintMethodSummary = this.getTaintMethodConfigWithArgumentsAndLocation(frame, methodDescriptor, className, methodId);
        if (taintMethodSummary == null) {
            taintMethodSummary = (TaintMethodConfig)this.get(className.concat(methodId));
        }
        if (taintMethodSummary == null) {
            taintMethodSummary = this.getSuperMethodSummary(className, methodId);
        }
        return taintMethodSummary;
    }

    public TaintMethodConfig getSuperMethodSummary(String className, String methodId) {
        try {
            if (className.endsWith("]")) {
                return null;
            }
            JavaClass javaClass = Repository.lookupClass((String)className);
            assert (javaClass != null);
            TaintMethodConfig summary = this.getSuperMethodSummary(javaClass.getSuperClasses(), methodId);
            if (summary != null) {
                return summary;
            }
            return this.getSuperMethodSummary(javaClass.getAllInterfaces(), methodId);
        }
        catch (ClassNotFoundException ex) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            return null;
        }
    }

    private TaintMethodConfig getSuperMethodSummary(JavaClass[] javaClasses, String method) {
        assert (javaClasses != null);
        for (JavaClass classOrInterface : javaClasses) {
            String fullMethodName = classOrInterface.getClassName().replace('.', '/').concat(method);
            TaintMethodConfig summary = (TaintMethodConfig)this.get(fullMethodName);
            if (summary == null) continue;
            return summary;
        }
        return null;
    }

    private TaintMethodConfig getTaintMethodConfigWithArgumentsAndLocation(TaintFrame frame, MethodDescriptor methodDescriptor, String className, String methodId) {
        if (this.taintMethodConfigWithArgumentsAndLocationMap.isEmpty()) {
            return null;
        }
        String signature = methodId.substring(methodId.indexOf("("), methodId.length());
        int parameters = new SignatureParser(signature).getNumParameters();
        StringBuffer sb = null;
        if (parameters > 0 && frame.getStackDepth() >= parameters) {
            sb = new StringBuffer(parameters);
            for (int i = parameters - 1; i >= 0; --i) {
                try {
                    Taint taint = (Taint)frame.getStackValue(i);
                    String value = taint.getConstantValue();
                    if (value != null) {
                        sb.append('\"' + value + '\"');
                    } else {
                        sb.append(taint.getState().name());
                    }
                    if (i <= 0) continue;
                    sb.append(',');
                    continue;
                }
                catch (DataflowAnalysisException e) {
                    assert (false) : e.getMessage();
                    continue;
                }
            }
        }
        String arguments = sb != null ? sb.toString() : "";
        String methodName = methodId.substring(1, methodId.indexOf(40));
        String methodDefinition = className + "." + methodName + "(" + arguments + ")";
        String key = methodDefinition + "@" + methodDescriptor.getSlashedClassName();
        return this.taintMethodConfigWithArgumentsAndLocationMap.get(key);
    }
}

