/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.serial;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;

public class DeserializationGadgetDetector
implements Detector {
    private static final String DESERIALIZATION_GADGET_TYPE = "DESERIALIZATION_GADGET";
    private static final List<String> DANGEROUS_APIS = Arrays.asList("java/lang/reflect/Method", "java/lang/reflect/Constructor", "org/springframework/beans/BeanUtils", "org/apache/commons/beanutils/BeanUtils", "org/apache/commons/beanutils/PropertyUtils", "org/springframework/util/ReflectionUtils");
    List<String> classesToIgnoreInReadObjectMethod = Arrays.asList("java/io/ObjectInputStream", "java/lang/Object");
    private BugReporter bugReporter;
    private static List<String> READ_DESERIALIZATION_METHODS = Arrays.asList("readObject", "readUnshared", "readArray", "readResolve");

    public DeserializationGadgetDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        boolean isSerializable = InterfaceUtils.isSubtype(javaClass, "java.io.Serializable");
        boolean isInvocationHandler = InterfaceUtils.isSubtype(javaClass, "java.lang.reflect.InvocationHandler");
        boolean useDangerousApis = false;
        boolean customReadObjectMethod = false;
        boolean customInvokeMethod = false;
        boolean hasMethodField = false;
        if (!isSerializable) {
            return;
        }
        for (Constant constant : javaClass.getConstantPool().getConstantPool()) {
            ConstantUtf8 utf8;
            String constantValue;
            if (!(constant instanceof ConstantUtf8) || !DANGEROUS_APIS.contains(constantValue = String.valueOf((utf8 = (ConstantUtf8)constant).getBytes()))) continue;
            useDangerousApis = true;
            break;
        }
        for (Constant constant : javaClass.getMethods()) {
            if (!customReadObjectMethod && READ_DESERIALIZATION_METHODS.contains(constant.getName())) {
                try {
                    customReadObjectMethod = this.hasCustomReadObject((Method)constant, classContext, this.classesToIgnoreInReadObjectMethod);
                }
                catch (CFGBuilderException cFGBuilderException) {
                }
                catch (DataflowAnalysisException dataflowAnalysisException) {}
                continue;
            }
            if (customInvokeMethod || !"invoke".equals(constant.getName())) continue;
            try {
                customInvokeMethod = this.hasCustomReadObject((Method)constant, classContext, this.classesToIgnoreInReadObjectMethod);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        for (Constant constant : javaClass.getFields()) {
            if ((!constant.getName().toLowerCase().contains("method") || !constant.getType().equals((Object)new ObjectType("java.lang.String"))) && !constant.getType().equals((Object)new ObjectType("java.reflect.Method"))) continue;
            hasMethodField = true;
        }
        if (isSerializable && customReadObjectMethod || isInvocationHandler && customInvokeMethod) {
            int priority = useDangerousApis ? 2 : 3;
            this.bugReporter.reportBug(new BugInstance((Detector)this, DESERIALIZATION_GADGET_TYPE, priority).addClass(javaClass));
        } else if (isSerializable && hasMethodField && useDangerousApis) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, DESERIALIZATION_GADGET_TYPE, 3).addClass(javaClass));
        }
    }

    private boolean hasCustomReadObject(Method m, ClassContext classContext, List<String> classesToIgnore) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        int count = 0;
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            InvokeInstruction invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof InvokeInstruction) || READ_DESERIALIZATION_METHODS.contains((invoke = (InvokeInstruction)inst).getMethodName(cpg)) || classesToIgnore.contains(invoke.getClassName(cpg))) continue;
            ++count;
        }
        return count > 3;
    }

    public void report() {
    }
}

