/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class ConstantPasswordDetector
extends OpcodeStackDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private static final String HARD_CODE_KEY_TYPE = "HARD_CODE_KEY";
    private final BugReporter bugReporter;
    private boolean staticInitializerSeen = false;
    private static final String CONFIG_DIR = "password-methods";
    private static final String METHODS_FILENAME = "password-methods-all.txt";
    private static final String GET_BYTES_STRING = "java/lang/String.getBytes(Ljava/lang/String;)[B";
    private static final String GET_BYTES = "java/lang/String.getBytes()[B";
    private static final String TO_CHAR_ARRAY = "java/lang/String.toCharArray()[C";
    private static final String BIGINTEGER_CONSTRUCTOR_STRING = "java/math/BigInteger.<init>(Ljava/lang/String;)V";
    private static final String BIGINTEGER_CONSTRUCTOR_STRING_RADIX = "java/math/BigInteger.<init>(Ljava/lang/String;I)V";
    private static final String BIGINTEGER_CONSTRUCTOR_BYTE = "java/math/BigInteger.<init>([B)V";
    private static final String BIGINTEGER_BYTE_SIGNUM = "java/math/BigInteger.<init>(I[B)V";
    private static final String PASSWORD_NAMES = ".*(pass|pwd|psw|secret|key|cipher|crypt|des|aes|mac|private|sign|cert).*";
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(".*(pass|pwd|psw|secret|key|cipher|crypt|des|aes|mac|private|sign|cert).*", 2);
    private final Map<String, Collection<Integer>> sinkMethods = new HashMap<String, Collection<Integer>>();
    private boolean isFirstArrayStore = false;
    private boolean wasToConstArrayConversion = false;
    private static final Set<String> hardCodedFields = new HashSet<String>();
    private static final Set<String> reportedFields = new HashSet<String>();
    private String calledMethod = null;

    public ConstantPasswordDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.loadMap(METHODS_FILENAME, this.sinkMethods, "#");
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot load resources", ex);
        }
    }

    public void visit(JavaClass javaClass) {
        Method[] methods;
        this.staticInitializerSeen = false;
        for (Method method : methods = javaClass.getMethods()) {
            if (!method.getName().equals("<clinit>")) continue;
            this.doVisitMethod(method);
            this.staticInitializerSeen = true;
            break;
        }
        this.isFirstArrayStore = false;
        this.wasToConstArrayConversion = false;
    }

    public void visitAfter(JavaClass obj) {
        ArrayList<String> fieldsToReport = new ArrayList<String>();
        for (String field : hardCodedFields) {
            if (!ConstantPasswordDetector.isSuspiciousName(field, obj) || reportedFields.contains(field)) continue;
            fieldsToReport.add(field);
        }
        this.reportBugSource(fieldsToReport, 2);
        hardCodedFields.clear();
        reportedFields.clear();
        super.visitAfter(obj);
    }

    private static boolean isSuspiciousName(String fullFieldName, JavaClass obj) {
        int classNameLength = obj.getClassName().length();
        if (classNameLength <= fullFieldName.length()) {
            String fieldName = fullFieldName.substring(classNameLength);
            return PASSWORD_PATTERN.matcher(fieldName).matches();
        }
        String fieldName = fullFieldName.substring(Math.max(fullFieldName.lastIndexOf(46), 0));
        return PASSWORD_PATTERN.matcher(fieldName).matches();
    }

    public void visit(Method method) {
        this.isFirstArrayStore = false;
        this.wasToConstArrayConversion = false;
    }

    public void sawOpcode(int seen) {
        if (this.isAlreadyAnalyzed()) {
            return;
        }
        this.markHardCodedItemsFromFlow();
        if (seen == 188) {
            this.isFirstArrayStore = true;
        }
        if (ConstantPasswordDetector.isStoringToArray(seen)) {
            this.markArraysHardCodedOrNot();
            this.isFirstArrayStore = false;
        }
        if (this.wasToConstArrayConversion) {
            this.markTopItemHardCoded();
            this.wasToConstArrayConversion = false;
        }
        if (seen == 181 || seen == 179) {
            this.saveArrayFieldIfHardCoded();
        }
        if (ConstantPasswordDetector.isInvokeInstruction(seen)) {
            this.calledMethod = this.getCalledMethodName();
            this.wasToConstArrayConversion = this.isToConstArrayConversion();
            this.markBigIntegerHardCodedOrNot();
            this.reportBadSink();
        }
    }

    private boolean isAlreadyAnalyzed() {
        return this.getMethodName().equals("<clinit>") && this.staticInitializerSeen;
    }

    private void markHardCodedItemsFromFlow() {
        for (int i = 0; i < this.stack.getStackDepth(); ++i) {
            OpcodeStack.Item stackItem = this.stack.getStackItem(i);
            if ((stackItem.getConstant() != null || stackItem.isNull()) && !stackItem.getSignature().startsWith("[")) {
                this.setHardCodedItem(stackItem);
            }
            if (!this.hasHardCodedFieldSource(stackItem)) continue;
            this.setHardCodedItem(stackItem);
        }
    }

    private boolean hasHardCodedFieldSource(OpcodeStack.Item stackItem) {
        XField xField = stackItem.getXField();
        if (xField == null) {
            return false;
        }
        String[] split = xField.toString().split(" ");
        int length = split.length;
        if (length < 2) {
            return false;
        }
        String fieldSignature = split[length - 1];
        if (!ConstantPasswordDetector.isSupportedSignature(fieldSignature)) {
            return false;
        }
        String fieldName = split[length - 2] + fieldSignature;
        return hardCodedFields.contains(fieldName);
    }

    private static boolean isStoringToArray(int seen) {
        return seen == 85 || seen == 84 || seen == 86 || seen == 79;
    }

    private void markArraysHardCodedOrNot() {
        if (this.hasHardCodedStackItem(0) && this.hasHardCodedStackItem(1)) {
            if (this.isFirstArrayStore) {
                this.setHardCodedItem(2);
            }
        } else {
            this.stack.getStackItem(2).setUserValue(null);
        }
    }

    private void markTopItemHardCoded() {
        assert (this.stack.getStackDepth() > 0);
        this.setHardCodedItem(0);
    }

    private void saveArrayFieldIfHardCoded() {
        String fieldSignature = this.getSigConstantOperand();
        if (ConstantPasswordDetector.isSupportedSignature(fieldSignature) && this.hasHardCodedStackItem(0) && !this.stack.getStackItem(0).isNull()) {
            String fieldName = this.getFullFieldName();
            hardCodedFields.add(fieldName);
        }
    }

    private static boolean isInvokeInstruction(int seen) {
        return seen >= 182 && seen <= 185;
    }

    private boolean isToConstArrayConversion() {
        return this.isInMethodWithConst(TO_CHAR_ARRAY, 0) || this.isInMethodWithConst(GET_BYTES, 0) || this.isInMethodWithConst(GET_BYTES_STRING, 1);
    }

    private void markBigIntegerHardCodedOrNot() {
        if (this.isInMethodWithConst(BIGINTEGER_CONSTRUCTOR_STRING, 0) || this.isInMethodWithConst(BIGINTEGER_CONSTRUCTOR_BYTE, 0)) {
            this.setHardCodedItem(1);
        } else if (this.isInMethodWithConst(BIGINTEGER_CONSTRUCTOR_STRING_RADIX, 1) || this.isInMethodWithConst(BIGINTEGER_BYTE_SIGNUM, 0)) {
            this.setHardCodedItem(2);
        }
    }

    private void reportBadSink() {
        if (!this.sinkMethods.containsKey(this.calledMethod)) {
            return;
        }
        Collection<Integer> offsets = this.sinkMethods.get(this.calledMethod);
        ArrayList<Integer> offsetsToReport = new ArrayList<Integer>();
        for (Integer offset : offsets) {
            if (!this.hasHardCodedStackItem(offset) || this.stack.getStackItem(offset.intValue()).isNull()) continue;
            offsetsToReport.add(offset);
            String sourceField = this.getStackFieldName(offset);
            if (sourceField == null) continue;
            reportedFields.add(sourceField);
        }
        if (!offsetsToReport.isEmpty()) {
            this.reportBugSink(1, offsets);
        }
    }

    private String getStackFieldName(int offset) {
        XField xField = this.stack.getStackItem(offset).getXField();
        if (xField == null) {
            return null;
        }
        String[] split = xField.toString().split(" ");
        if (split.length < 2) {
            return null;
        }
        return split[split.length - 2] + split[split.length - 1];
    }

    private void reportBugSink(int priority, Collection<Integer> offsets) {
        String bugType = HARD_CODE_KEY_TYPE;
        for (Integer paramIndex : offsets) {
            OpcodeStack.Item stackItem = this.stack.getStackItem(paramIndex.intValue());
            String signature = stackItem.getSignature();
            if (!"Ljava/lang/String;".equals(signature) && !"[C".equals(signature)) continue;
            bugType = HARD_CODE_PASSWORD_TYPE;
            break;
        }
        BugInstance bugInstance = new BugInstance((Detector)this, bugType, priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this);
        for (Integer paramIndex : offsets) {
            OpcodeStack.Item stackItem = this.stack.getStackItem(paramIndex.intValue());
            bugInstance.addParameterAnnotation(paramIndex.intValue(), "Hard coded parameter number (in reverse order) is").addFieldOrMethodValueSource(stackItem);
            Object constant = stackItem.getConstant();
            if (constant == null) continue;
            bugInstance.addString(constant.toString());
        }
        this.bugReporter.reportBug(bugInstance);
    }

    private void reportBugSource(Collection<String> fields, int priority) {
        if (fields.isEmpty()) {
            return;
        }
        String bugType = HARD_CODE_KEY_TYPE;
        for (String field : fields) {
            if (!field.endsWith("[C")) continue;
            bugType = HARD_CODE_PASSWORD_TYPE;
            break;
        }
        BugInstance bug = new BugInstance((Detector)this, bugType, priority).addClass((PreorderVisitor)this);
        for (String field : fields) {
            bug.addString("is hard coded in field " + field + " with suspicious name");
        }
        this.bugReporter.reportBug(bug);
    }

    private void setHardCodedItem(int stackOffset) {
        this.setHardCodedItem(this.stack.getStackItem(stackOffset));
    }

    private void setHardCodedItem(OpcodeStack.Item stackItem) {
        stackItem.setUserValue((Object)Boolean.TRUE);
    }

    private boolean hasHardCodedStackItem(int stackOffset) {
        return this.stack.getStackItem(stackOffset).getUserValue() != null;
    }

    private boolean isInMethodWithConst(String method, int stackOffset) {
        return method.equals(this.calledMethod) && this.hasHardCodedStackItem(stackOffset);
    }

    private String getFullFieldName() {
        String fieldName = this.getDottedClassConstantOperand() + "." + this.getNameConstantOperand() + this.getSigConstantOperand();
        return fieldName;
    }

    private static boolean isSupportedSignature(String signature) {
        return "[C".equals(signature) || "[B".equals(signature) || "Ljava/math/BigInteger;".equals(signature);
    }

    private String getCalledMethodName() {
        String methodNameWithSignature = this.getNameConstantOperand() + this.getSigConstantOperand();
        return this.getClassConstantOperand() + "." + methodNameWithSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMap(String filename, Map<String, Collection<Integer>> map, String separator) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = this.getReader(filename);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] tuple = line.split(separator);
                int count = tuple.length - 1;
                ArrayList<Integer> parameters = new ArrayList<Integer>(count);
                for (int i = 0; i < count; ++i) {
                    parameters.add(Integer.parseInt(tuple[i + 1]));
                }
                map.put(tuple[0], parameters);
            }
        }
    }

    private BufferedReader getReader(String filename) {
        String path = "password-methods/" + filename;
        return new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path), Charset.forName("UTF-8")));
    }
}

