/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.com.google.common.collect.Sets;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.Node;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.HashSet;
import java.util.List;

@Internal
public class UniqueArgumentNames
extends AbstractRule {
    public UniqueArgumentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        if (field.getArguments() == null || field.getArguments().size() <= 1) {
            return;
        }
        HashSet<String> arguments = Sets.newHashSetWithExpectedSize(field.getArguments().size());
        for (Argument argument : field.getArguments()) {
            if (arguments.contains(argument.getName())) {
                String message = this.i18n(ValidationErrorType.DuplicateArgumentNames, "UniqueArgumentNames.uniqueArgument", argument.getName());
                this.addError(ValidationErrorType.DuplicateArgumentNames, field.getSourceLocation(), message);
                continue;
            }
            arguments.add(argument.getName());
        }
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        if (directive.getArguments() == null || directive.getArguments().size() <= 1) {
            return;
        }
        HashSet<String> arguments = Sets.newHashSetWithExpectedSize(directive.getArguments().size());
        for (Argument argument : directive.getArguments()) {
            if (arguments.contains(argument.getName())) {
                String message = this.i18n(ValidationErrorType.DuplicateArgumentNames, "UniqueArgumentNames.uniqueArgument", argument.getName());
                this.addError(ValidationErrorType.DuplicateArgumentNames, directive.getSourceLocation(), message);
                continue;
            }
            arguments.add(argument.getName());
        }
    }
}

