/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.role;

import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfGroup;
import com.documentum.fc.client.IDfQuery;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSessionManager;
import com.documentum.fc.common.DfException;
import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IConfigLookup;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IRoleModelAdaptor;
import com.documentum.services.config.common.Context;
import com.documentum.services.config.role.ClientCapabilityRoleModel;
import com.documentum.services.config.role.RoleService;
import com.documentum.services.config.util.DocbaseUtils;
import com.documentum.services.config.util.ServerUtil;
import com.documentum.services.config.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocbaseRoleModel
implements IRoleModelAdaptor,
IConfigServiceConsumer {
    private static Hashtable s_rolesOfUserCache = new Hashtable(4001);
    private static Map s_aliasRolesCache = null;
    private static Boolean s_bClientCapabilityRollbackEnabled = null;
    private static ClientCapabilityRoleModel s_clientCapabilityRoleModel;
    private static List g_additionalRoleQualifierClasses;
    private static IConfigService m_configService;
    private static final String ROLE_QUALIFIER_CLASS_STRING = "group_class";
    private static final String ROLE_QUALIFIER_CLASSES = "application.rolemodel.groupclasses";
    private static final String ROLE = "role";
    private static final String ROLES_PRECEDENCE = "application.rolemodel.rolesprecedence";

    public DocbaseRoleModel() {
        s_clientCapabilityRoleModel = new ClientCapabilityRoleModel();
        Runnable runnable = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    DocbaseRoleModel.this.refresh();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (Trace.ROLESERVICE) {
            Trace.println(this, "DocbaseRoleModel - clearing role caches");
        }
        Class<DocbaseRoleModel> clazz = DocbaseRoleModel.class;
        synchronized (DocbaseRoleModel.class) {
            s_aliasRolesCache = null;
            s_bClientCapabilityRollbackEnabled = null;
            s_clientCapabilityRoleModel.refresh();
            if (s_rolesOfUserCache != null) {
                s_rolesOfUserCache.clear();
            }
            if (RolesOfUser.s_superRolesOfRoleCache != null) {
                RolesOfUser.s_superRolesOfRoleCache.clear();
            }
            if (RolesOfUser.s_activeDomainCache != null) {
                RolesOfUser.s_activeDomainCache.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getUserRole(String string) {
        String string2 = null;
        RolesOfUser rolesOfUser = DocbaseRoleModel.getRolesOfUser(string);
        if (rolesOfUser != null) {
            string2 = rolesOfUser.getPrimaryRole();
        }
        return string2;
    }

    public boolean isUserAssignedRole(String string, String string2, IContext iContext) {
        boolean bl = false;
        RolesOfUser rolesOfUser = DocbaseRoleModel.getRolesOfUser(string);
        if (rolesOfUser != null) {
            bl = rolesOfUser.hasRole(string2);
        }
        return bl;
    }

    public String[] getUserRoles(String string) {
        String[] stringArray = null;
        RolesOfUser rolesOfUser = DocbaseRoleModel.getRolesOfUser(string);
        if (rolesOfUser != null) {
            stringArray = rolesOfUser.getAllRoles();
        }
        return stringArray;
    }

    public String getParentRole(String string, String string2) {
        String string3 = null;
        RolesOfUser rolesOfUser = DocbaseRoleModel.getRolesOfUser(string);
        if (rolesOfUser != null) {
            string3 = rolesOfUser.getSuperRole(string2);
        }
        return string3;
    }

    public void setConfigService(IConfigService iConfigService) {
        m_configService = iConfigService;
        s_clientCapabilityRoleModel.setConfigService(iConfigService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RolesOfUser getRolesOfUser(String string) {
        RolesOfUser rolesOfUser;
        String string2;
        String string3 = m_configService.getDocbaseContext().getCurrentDocbaseName();
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(string3);
        stringBuilder.append(':');
        stringBuilder.append(string);
        String string4 = string2 = stringBuilder.toString().intern();
        synchronized (string4) {
            rolesOfUser = (RolesOfUser)s_rolesOfUserCache.get(string2);
            if (rolesOfUser == null) {
                try {
                    rolesOfUser = new RolesOfUser(string, string3, string2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("An error occurred while retrieving roles for user: " + string2, exception);
                }
                rolesOfUser.m_initialized = true;
            }
        }
        if (rolesOfUser.m_initialized) {
            return rolesOfUser;
        }
        return null;
    }

    private static synchronized boolean isClientCapabilityFallbackEnabled() {
        if (s_bClientCapabilityRollbackEnabled == null) {
            IConfigLookup iConfigLookup = m_configService.getConfigLookup();
            String string = iConfigLookup.lookupString("application.rolemodel.client_capability_fallback_enabled", (IContext)Context.getApplicationContext());
            s_bClientCapabilityRollbackEnabled = string == null || !string.equalsIgnoreCase("false");
        }
        return s_bClientCapabilityRollbackEnabled;
    }

    private static synchronized String getClientCapabilityAlias(String string) {
        if (s_aliasRolesCache == null) {
            s_aliasRolesCache = new HashMap(27);
            String[] stringArray = new String[]{"consumer", "contributor", "coordinator", "administrator"};
            IConfigLookup iConfigLookup = m_configService.getConfigLookup();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = "application.rolemodel.client_capability_aliases." + string2 + "_roles";
                IConfigElement iConfigElement = iConfigLookup.lookupElement(string3, (IContext)Context.getApplicationContext());
                if (iConfigElement == null) continue;
                Iterator iterator = iConfigElement.getChildElements(ROLE);
                while (iterator != null && iterator.hasNext()) {
                    IConfigElement iConfigElement2 = (IConfigElement)iterator.next();
                    String string4 = iConfigElement2.getValue();
                    if (string4 == null || string4.length() <= 0) continue;
                    s_aliasRolesCache.put(string4, string2);
                }
            }
        }
        return (String)s_aliasRolesCache.get(string);
    }

    static {
        g_additionalRoleQualifierClasses = null;
        m_configService = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RolesOfUser {
        private String m_strUserName = null;
        private String m_strDocbaseName = null;
        private String m_strPrimaryRole = null;
        private String[] m_roles = null;
        private Map m_rolesPrecedence = new HashMap(7);
        private boolean m_initialized = false;
        private static HashMap s_activeDomainCache = new HashMap();
        private static Map s_superRolesOfRoleCache = new HashMap(101);

        public RolesOfUser(String string, String string2, String string3) {
            s_rolesOfUserCache.put(string3, this);
            this.m_strUserName = string;
            this.m_strDocbaseName = string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            if (ServerUtil.compareDocbaseVersion(5, 0, m_configService.getDocbaseContext().getCurrentDfSession())) {
                this.addGroupBasedRoles(arrayList);
                this.addClientCapabilityRoleAliases(arrayList);
                bl = this.containsClientCapabilityRoles(arrayList);
            }
            if (arrayList.isEmpty() || DocbaseRoleModel.isClientCapabilityFallbackEnabled() && !bl) {
                this.addClientCapabilityRoles(arrayList);
            }
            this.applyCustomRolesPrecedence(arrayList);
            this.setProperties(arrayList);
        }

        public String getPrimaryRole() {
            return this.m_strPrimaryRole;
        }

        public String getSuperRole(String string) {
            return (String)this.m_rolesPrecedence.get(string);
        }

        public boolean hasRole(String string) {
            return this.m_rolesPrecedence.containsKey(string);
        }

        public String[] getAllRoles() {
            return this.m_roles;
        }

        private void applyCustomRolesPrecedence(List<String> list) {
            Serializable serializable;
            List<String> list2 = this.getCustomRolesPrecedence();
            if (list2 == null || list2.isEmpty() || list.isEmpty()) {
                return;
            }
            if (Trace.ROLESERVICE) {
                serializable = new StringBuilder(100);
                ((StringBuilder)serializable).append("DocbaseRoleModel - original user roles: ");
                for (String object : list) {
                    ((StringBuilder)serializable).append(object).append(", ");
                }
                Trace.println(this, ((StringBuilder)serializable).toString());
                serializable = new StringBuilder(100);
                ((StringBuilder)serializable).append("apply the custom roles precedence setting: ");
                for (String string : list2) {
                    ((StringBuilder)serializable).append(string).append(", ");
                }
                Trace.println(this, ((StringBuilder)serializable).toString());
            }
            serializable = new HashMap(13);
            int n = list.size() - 1;
            for (String string : list) {
                serializable.put(string, new Integer(n));
                --n;
            }
            n = list.size() + list2.size() - 1;
            for (String string : list2) {
                serializable.put(string, new Integer(n));
                --n;
            }
            Collections.sort(list, new RoleComparator((Map)((Object)serializable)));
        }

        private void setProperties(List list) {
            String string;
            if (list.size() > 0) {
                this.m_strPrimaryRole = (String)list.get(0);
            }
            for (int i = 0; i < list.size(); ++i) {
                string = (String)list.get(i);
                String string2 = null;
                if (i + 1 < list.size()) {
                    string2 = (String)list.get(i + 1);
                }
                this.m_rolesPrecedence.put(string, string2);
            }
            this.m_roles = list.toArray(new String[list.size()]);
            if (Trace.ROLESERVICE) {
                StringBuffer stringBuffer = new StringBuffer(100);
                string = this.getActiveDomain();
                if (string == null || string.length() == 0) {
                    string = "all";
                }
                stringBuffer.append("DocbaseRoleModel - caching roles for User: '");
                stringBuffer.append(this.m_strUserName);
                stringBuffer.append("', Docbase: '");
                stringBuffer.append(this.m_strDocbaseName);
                stringBuffer.append("', Domain: '");
                stringBuffer.append(string);
                stringBuffer.append("', ClientCapabilityFallbackEnabled: '");
                stringBuffer.append(Boolean.toString(DocbaseRoleModel.isClientCapabilityFallbackEnabled()));
                stringBuffer.append("', Roles (in order of precedence): ");
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        String string3 = (String)list.get(i);
                        stringBuffer.append("'");
                        stringBuffer.append(string3);
                        stringBuffer.append("'");
                    }
                } else {
                    stringBuffer.append("none");
                }
                Trace.println(this, stringBuffer.toString());
            }
        }

        private void addGroupBasedRoles(List list) {
            String string = this.getUserRolesQuery(this.m_strUserName);
            List<String> list2 = this.executeQuery(string, "group_name");
            if (list2 != null && list2.size() > 0) {
                if (list2.size() > 1) {
                    this.sortRolesByStructure(list2);
                }
                list.addAll(list2);
            }
        }

        private String getUserRolesQuery(String string) {
            List list = RolesOfUser.getAdditionalClassesForRoleQualifier();
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("select group_name, i_all_users_names from dm_group where ( group_class='role'");
            Object object = list.iterator();
            while (object.hasNext()) {
                stringBuilder.append(" or group_class='");
                stringBuilder.append(object.next());
                stringBuilder.append("'");
            }
            stringBuilder.append(" )");
            stringBuilder.append(" and any i_all_users_names='");
            stringBuilder.append(RolesOfUser.quote(string));
            stringBuilder.append('\'');
            object = this.getActiveDomain();
            if (object != null && ((String)object).length() > 0) {
                stringBuilder.append(" and any i_supergroups_names ='");
                stringBuilder.append((String)object);
                stringBuilder.append('\'');
            }
            return stringBuilder.toString();
        }

        public static String quote(String string) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length + 16);
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\'') {
                    stringBuffer.append('\'');
                }
                stringBuffer.append(cArray[i]);
            }
            return stringBuffer.toString();
        }

        private static synchronized List getAdditionalClassesForRoleQualifier() {
            if (g_additionalRoleQualifierClasses == null) {
                IConfigLookup iConfigLookup = m_configService.getConfigLookup();
                IConfigElement iConfigElement = iConfigLookup.lookupElement(DocbaseRoleModel.ROLE_QUALIFIER_CLASSES, (IContext)new Context());
                g_additionalRoleQualifierClasses = new ArrayList();
                if (iConfigElement != null) {
                    IConfigElement iConfigElement2 = null;
                    Iterator iterator = iConfigElement.getChildElements(DocbaseRoleModel.ROLE_QUALIFIER_CLASS_STRING);
                    while (iterator.hasNext()) {
                        iConfigElement2 = (IConfigElement)iterator.next();
                        g_additionalRoleQualifierClasses.add(iConfigElement2.getValue());
                    }
                }
            }
            return g_additionalRoleQualifierClasses;
        }

        private List<String> getDefaultCustomRolesPrecedence() {
            IConfigLookup iConfigLookup = m_configService.getConfigLookup();
            IConfigElement iConfigElement = iConfigLookup.lookupElement(DocbaseRoleModel.ROLES_PRECEDENCE, (IContext)Context.getApplicationContext());
            ArrayList<String> arrayList = null;
            if (iConfigElement != null) {
                Iterator iterator = iConfigElement.getChildElements(DocbaseRoleModel.ROLE);
                while (iterator.hasNext()) {
                    IConfigElement iConfigElement2 = (IConfigElement)iterator.next();
                    String string = iConfigElement2.getValue();
                    if (string == null || string.length() <= 0) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string);
                }
            }
            return arrayList;
        }

        private List<String> getCustomRolesPrecedence() {
            return this.getDefaultCustomRolesPrecedence();
        }

        private void sortRolesByStructure(List list) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(13);
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                Set set = this.getSuperRoles(string);
                int n = set.size();
                hashMap.put(string, new Integer(n));
            }
            Collections.sort(list, new RoleComparator(hashMap));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getSuperRoles(String string) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.m_strDocbaseName);
            stringBuilder.append(':');
            stringBuilder.append(string);
            String string2 = stringBuilder.toString();
            HashSet<String> hashSet = null;
            Class<DocbaseRoleModel> clazz = DocbaseRoleModel.class;
            synchronized (DocbaseRoleModel.class) {
                hashSet = (HashSet<String>)s_superRolesOfRoleCache.get(string2);
                if (hashSet == null) {
                    List list = RolesOfUser.getAdditionalClassesForRoleQualifier();
                    StringBuilder stringBuilder2 = new StringBuilder(200);
                    stringBuilder2.append("select i_supergroups_names from dm_group where ( group_class='role'");
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        stringBuilder2.append(" or group_class='");
                        stringBuilder2.append(object.next());
                        stringBuilder2.append("'");
                    }
                    stringBuilder2.append(" ) ");
                    stringBuilder2.append("and group_name='");
                    stringBuilder2.append(string);
                    stringBuilder2.append("'");
                    object = this.executeQuery(stringBuilder2.toString(), "i_supergroups_names");
                    hashSet = new HashSet<String>(7);
                    for (int i = 0; i < object.size(); ++i) {
                        String string3 = (String)object.get(i);
                        if (string3 == null || string3.equals(string)) continue;
                        hashSet.add(string3);
                    }
                    s_superRolesOfRoleCache.put(string2, hashSet);
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return hashSet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private List<String> executeQuery(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>(10);
            IDfSessionManager iDfSessionManager = null;
            IDfSession iDfSession = null;
            IDfCollection iDfCollection = null;
            try {
                IDfQuery iDfQuery = DocbaseUtils.getClientX().getQuery();
                iDfQuery.setDQL(string);
                iDfSession = m_configService.getDocbaseContext().getDfSession(this.m_strDocbaseName);
                iDfSessionManager = iDfSession.getSessionManager();
                iDfCollection = iDfQuery.execute(iDfSession, 0);
                while (iDfCollection.next()) {
                    String string3 = iDfCollection.getString(string2);
                    arrayList.add(string3);
                }
            }
            catch (DfException dfException) {
                try {
                    throw new RuntimeException("Failed to execute the query", dfException);
                }
                catch (Throwable throwable) {
                    try {
                        if (iDfCollection == null) throw throwable;
                        iDfCollection.close();
                        throw throwable;
                    }
                    catch (DfException dfException2) {
                        throw new RuntimeException("Failed to close collection", dfException2);
                    }
                    finally {
                        if (iDfSession != null) {
                            iDfSessionManager.release(iDfSession);
                        }
                    }
                }
            }
            try {
                if (iDfCollection == null) return arrayList;
                iDfCollection.close();
                return arrayList;
            }
            catch (DfException dfException) {
                throw new RuntimeException("Failed to close collection", dfException);
            }
            finally {
                if (iDfSession != null) {
                    iDfSessionManager.release(iDfSession);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected String getActiveDomain() {
            String string = null;
            String string2 = RoleService.getDomain();
            if (string2 == null) return string;
            if (string2.length() <= 0) return string;
            String string3 = m_configService.getDocbaseContext().getCurrentDocbaseName();
            Class<DocbaseRoleModel> clazz = DocbaseRoleModel.class;
            synchronized (DocbaseRoleModel.class) {
                if (s_activeDomainCache.containsKey(string3)) {
                    return (String)s_activeDomainCache.get(string3);
                }
                IDfSession iDfSession = null;
                try {
                    iDfSession = m_configService.getDocbaseContext().getCurrentDfSession();
                    IDfGroup iDfGroup = iDfSession.getGroup(string2);
                    if (iDfGroup != null) {
                        iDfGroup.fetch(null);
                        String string4 = iDfGroup.getString(DocbaseRoleModel.ROLE_QUALIFIER_CLASS_STRING);
                        if (string4 != null && string4.equals("domain")) {
                            string = string2;
                        }
                    }
                }
                catch (DfException dfException) {
                    // empty catch block
                }
                s_activeDomainCache.put(string3, string);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return string;
            }
        }

        private void addClientCapabilityRoles(List list) {
            Trace.suspendTracing();
            String string = s_clientCapabilityRoleModel.getUserRole(this.m_strUserName);
            while (string != null) {
                list.add(string);
                string = s_clientCapabilityRoleModel.getParentRole(this.m_strUserName, string);
            }
            Trace.resumeTracing();
        }

        private void addClientCapabilityRoleAliases(List list) {
            String string;
            int n;
            boolean bl = DocbaseRoleModel.isClientCapabilityFallbackEnabled();
            if (!bl) {
                for (n = 0; n < list.size(); ++n) {
                    string = (String)list.get(n);
                    if (DocbaseRoleModel.getClientCapabilityAlias(string) == null) continue;
                    bl = true;
                    break;
                }
            }
            for (n = list.size() - 1; n >= 0; --n) {
                string = (String)list.get(n);
                String[] stringArray = null;
                if (this.isClientCapabilityRole(string)) {
                    if (bl) {
                        stringArray = this.getClientCapabilityRoleHierarchy(string);
                    }
                } else {
                    String string2 = DocbaseRoleModel.getClientCapabilityAlias(string);
                    if (string2 != null) {
                        stringArray = this.getClientCapabilityRoleHierarchy(string2);
                    }
                }
                if (stringArray == null) continue;
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    String string3 = stringArray[i];
                    if (list.contains(string3)) continue;
                    list.add(n + 1, string3);
                }
            }
        }

        private boolean containsClientCapabilityRoles(List list) {
            return list.contains("consumer") || list.contains("contributor") || list.contains("coordinator") || list.contains("administrator");
        }

        private boolean isClientCapabilityRole(String string) {
            return string.equals("consumer") || string.equals("contributor") || string.equals("coordinator") || string.equals("administrator");
        }

        private String[] getClientCapabilityRoleHierarchy(String string) {
            if (string.equals("administrator")) {
                return new String[]{"administrator", "coordinator", "contributor", "consumer"};
            }
            if (string.equals("coordinator")) {
                return new String[]{"coordinator", "contributor", "consumer"};
            }
            if (string.equals("contributor")) {
                return new String[]{"contributor", "consumer"};
            }
            if (string.equals("consumer")) {
                return new String[]{"consumer"};
            }
            return null;
        }

        static class RoleComparator
        implements Comparator {
            private Map m_precidenceOfRoles;

            RoleComparator(Map map) {
                this.m_precidenceOfRoles = map;
            }

            public int compare(Object object, Object object2) {
                int n;
                String string = (String)object;
                String string2 = (String)object2;
                int n2 = (Integer)this.m_precidenceOfRoles.get(string);
                if (n2 == (n = ((Integer)this.m_precidenceOfRoles.get(string2)).intValue())) {
                    return string.compareTo(string2);
                }
                if (n2 < n) {
                    return 1;
                }
                return -1;
            }

            public boolean equals(Object object) {
                return false;
            }

            public int hashCode() {
                return 0;
            }
        }
    }
}

