/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.role;

import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfUser;
import com.documentum.fc.common.DfException;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IRoleModelAdaptor;
import com.documentum.services.config.util.Trace;
import java.util.HashMap;

public class ClientCapabilityRoleModel
implements IRoleModelAdaptor,
IConfigServiceConsumer {
    private HashMap m_hashRoleName2Role = new HashMap();
    private final HashMap m_capabilityMap = new HashMap(89, 1.0f);
    private IConfigService m_configService = null;
    protected static final String CONSUMER_ROLE = "consumer";
    protected static final String CONTRIBUTOR_ROLE = "contributor";
    protected static final String COORDINATOR_ROLE = "coordinator";
    protected static final String ADMINISTRATOR_ROLE = "administrator";
    protected static final int ADMINISTRATOR_CLIENT_CAPABILITY = 8;
    protected static final int COORDINATOR_CLIENT_CAPABILITY = 4;
    protected static final int CONTRIBUTOR_CLIENT_CAPABILITY = 2;
    protected static final int CONSUMER_CLIENT_CAPABILITY = 1;
    protected static final int NOT_A_USER = -1;

    public ClientCapabilityRoleModel() {
        ClientCapabilityRole clientCapabilityRole = new ClientCapabilityRole(CONSUMER_ROLE, null, 1);
        this.m_hashRoleName2Role.put(CONSUMER_ROLE, clientCapabilityRole);
        ClientCapabilityRole clientCapabilityRole2 = new ClientCapabilityRole(CONTRIBUTOR_ROLE, clientCapabilityRole, 2);
        this.m_hashRoleName2Role.put(CONTRIBUTOR_ROLE, clientCapabilityRole2);
        ClientCapabilityRole clientCapabilityRole3 = new ClientCapabilityRole(COORDINATOR_ROLE, clientCapabilityRole2, 4);
        this.m_hashRoleName2Role.put(COORDINATOR_ROLE, clientCapabilityRole3);
        ClientCapabilityRole clientCapabilityRole4 = new ClientCapabilityRole(ADMINISTRATOR_ROLE, clientCapabilityRole3, 8);
        this.m_hashRoleName2Role.put(ADMINISTRATOR_ROLE, clientCapabilityRole4);
        Runnable runnable = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ClientCapabilityRoleModel.this.refresh();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        HashMap hashMap = this.m_capabilityMap;
        synchronized (hashMap) {
            if (Trace.ROLESERVICE) {
                Trace.println(this, "ClientCapabilityRoleModel - clearing role cache");
            }
            this.m_capabilityMap.clear();
        }
    }

    public String getUserRole(String string) {
        String string2 = null;
        IDfSession iDfSession = null;
        try {
            iDfSession = this.m_configService.getDocbaseContext().getCurrentDfSession();
            int n = this.getClientCapability(iDfSession, string);
            string2 = ClientCapabilityRoleModel.getClientCapabilityRole(n);
        }
        catch (DfException dfException) {
            throw new RuntimeException("Failed  to get client capability", dfException);
        }
        return string2;
    }

    public String[] getUserRoles(String string) {
        return new String[]{this.getUserRole(string)};
    }

    public boolean isUserAssignedRole(String string, String string2, IContext iContext) {
        boolean bl = false;
        IDfSession iDfSession = null;
        try {
            iDfSession = this.m_configService.getDocbaseContext().getCurrentDfSession();
            if (string2 != null) {
                int n = this.getClientCapability(iDfSession, string);
                if (n != -1 && string2.equals(CONSUMER_ROLE)) {
                    bl = true;
                } else {
                    int n2;
                    ClientCapabilityRole clientCapabilityRole = this.findRole(string2);
                    if (clientCapabilityRole != null && (n2 = clientCapabilityRole.getClientCapability()) <= n) {
                        bl = true;
                    }
                }
            }
        }
        catch (DfException dfException) {
            throw new RuntimeException("Failed to get client capability", dfException);
        }
        return bl;
    }

    public String getParentRole(String string, String string2) {
        ClientCapabilityRole clientCapabilityRole;
        String string3 = null;
        ClientCapabilityRole clientCapabilityRole2 = this.findRole(string2);
        if (clientCapabilityRole2 != null && (clientCapabilityRole = clientCapabilityRole2.getParentRole()) != null) {
            string3 = clientCapabilityRole.getName();
        }
        return string3;
    }

    public void setConfigService(IConfigService iConfigService) {
        this.m_configService = iConfigService;
    }

    private ClientCapabilityRole findRole(String string) {
        ClientCapabilityRole clientCapabilityRole = null;
        if (string != null) {
            string = string.toLowerCase().trim();
            clientCapabilityRole = (ClientCapabilityRole)this.m_hashRoleName2Role.get(string);
        }
        return clientCapabilityRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClientCapability(IDfSession iDfSession, String string) throws DfException {
        Integer n = null;
        String string2 = iDfSession.getDocbaseId();
        StringBuffer stringBuffer = new StringBuffer(string2.length() + string.length());
        stringBuffer.append(string2).append(string);
        String string3 = stringBuffer.toString();
        HashMap hashMap = this.m_capabilityMap;
        synchronized (hashMap) {
            n = (Integer)this.m_capabilityMap.get(string3);
            if (n == null) {
                IDfUser iDfUser = iDfSession.getUser(string);
                if (iDfUser != null) {
                    iDfUser.fetch(null);
                    int n2 = iDfUser.getClientCapability();
                    n = new Integer(ClientCapabilityRoleModel.getValidClientCapability(n2));
                } else {
                    n = new Integer(-1);
                }
                this.m_capabilityMap.put(string3, n);
                if (Trace.ROLESERVICE) {
                    StringBuffer stringBuffer2 = new StringBuffer(100);
                    stringBuffer2.append("ClientCapabilityRoleModel - caching client capability, user: '");
                    stringBuffer2.append(string);
                    stringBuffer2.append("', docbase: '");
                    stringBuffer2.append(iDfSession.getDocbaseName());
                    stringBuffer2.append("', client capability: '");
                    stringBuffer2.append(ClientCapabilityRoleModel.getClientCapabilityRole(n));
                    stringBuffer2.append("'");
                    Trace.println(this, stringBuffer2.toString());
                }
            }
        }
        return n;
    }

    private static int getValidClientCapability(int n) {
        if (n != 8 && n != 4 && n != 2 && n != 1) {
            n = 1;
        }
        return n;
    }

    private static String getClientCapabilityRole(int n) {
        String string = null;
        string = n == 8 ? ADMINISTRATOR_ROLE : (n == 4 ? COORDINATOR_ROLE : (n == 2 ? CONTRIBUTOR_ROLE : CONSUMER_ROLE));
        return string;
    }

    static class ClientCapabilityRole {
        private String m_strName = null;
        private ClientCapabilityRole m_roleParent = null;
        private int m_clientCapability = 0;

        ClientCapabilityRole(String string, ClientCapabilityRole clientCapabilityRole, int n) {
            this.m_strName = string;
            this.m_roleParent = clientCapabilityRole;
            this.m_clientCapability = n;
        }

        String getName() {
            return this.m_strName;
        }

        ClientCapabilityRole getParentRole() {
            return this.m_roleParent;
        }

        int getClientCapability() {
            return this.m_clientCapability;
        }
    }
}

