/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.qualifiers;

import com.documentum.fc.client.DfService;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.documentum.services.config.IConfigService;
import com.documentum.services.config.IConfigServiceConsumer;
import com.documentum.services.config.IContext;
import com.documentum.services.config.IInquisitiveQualifier;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.util.DocbaseUtils;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocbaseNameQualifier
extends DfService
implements IQualifier,
IInquisitiveQualifier,
IConfigServiceConsumer {
    private IConfigService m_configService;
    private HashSet<String> m_configuredDocbaseNames = new HashSet();
    private static final String OBJECTID = "objectId";
    private static final String DOCBASE = "docbase";
    private static final String[] CONTEXT_NAMES = new String[]{"objectId", "docbase"};

    public String[] getContextNames() {
        return CONTEXT_NAMES;
    }

    public String getScopeName() {
        return DOCBASE;
    }

    public String getScopeValue(IContext iContext) {
        if (this.m_configuredDocbaseNames.size() == 0) {
            return null;
        }
        String string = iContext.get(DOCBASE);
        if (string == null || string.length() == 0) {
            String string2;
            String string3 = iContext.get(OBJECTID);
            if (string3 != null && string3.length() != 0) {
                try {
                    string2 = DocbaseUtils.getDocbaseNameFromId((IDfId)new DfId(string3));
                    if (string2 != null && string2.length() > 0) {
                        string = string2;
                    }
                }
                catch (DfException dfException) {
                    // empty catch block
                }
            }
            if (string == null && (string2 = this.m_configService.getDocbaseContext().getCurrentDocbaseName()) != null && string2.length() > 0) {
                string = string2;
            }
        }
        if (string != null) {
            string = this.m_configuredDocbaseNames.contains(string) ? string : null;
        }
        return string;
    }

    public String getParentScopeValue(String string) {
        return null;
    }

    public String[] getAliasScopeValues(String string) {
        return null;
    }

    public void onAddScopeValues(List<String> list) {
        this.m_configuredDocbaseNames.addAll(list);
    }

    public void setConfigService(IConfigService iConfigService) {
        this.m_configService = iConfigService;
    }
}

