/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.nls;

import com.documentum.services.config.impl.ConfigService;
import com.documentum.services.config.nls.LocaleService;
import com.documentum.services.config.nls.NlsResourceBundle;
import com.documentum.services.config.util.Trace;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class NlsResourceClass
implements Serializable {
    protected ConfigService m_configService = null;
    private static boolean m_bNlsTest = false;
    private static boolean m_bFarEastTest = false;
    private static boolean m_bLongStringTest = false;
    private static final String XX_STRING = "xx";
    private static final String EN_US_LOCALE = "en_US";

    public void setConfigService(ConfigService configService) {
        this.m_configService = configService;
    }

    protected ConfigService getConfigService() {
        return this.m_configService;
    }

    public boolean stringExists(int n, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("NlsResourceClass.stringExists(...) - the 'locale' paramater is required");
        }
        String string = Integer.toString(n);
        ResourceBundle resourceBundle = null;
        String string2 = this.getBundleName();
        try {
            if (this instanceof NlsResourceBundle) {
                resourceBundle = ((NlsResourceBundle)this).getBundle(string2, locale);
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingResourceException("Missing resource bundle: ", string2, null);
        }
        boolean bl = true;
        try {
            if (resourceBundle != null) {
                resourceBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            bl = false;
        }
        return bl;
    }

    public boolean stringExists(String string, Locale locale) {
        boolean bl = false;
        if (locale == null) {
            throw new IllegalArgumentException("NlsResourceClass.stringExists(...) - the 'locale' paramater is required");
        }
        int n = -1;
        Class<?> clazz = null;
        try {
            clazz = this.getClass();
            Field field = clazz.getField(string);
            n = (Integer)field.get(null);
            if (n != -1) {
                bl = this.stringExists(n, locale);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return bl;
    }

    public String getString(String string, Locale locale) {
        return this.getString(string, locale, false);
    }

    public String getString(String string, Locale locale, boolean bl) {
        String string2 = null;
        if (locale == null) {
            throw new IllegalArgumentException("NlsResourceClass.getString(...) - the 'locale' paramater is required");
        }
        int n = -1;
        Class<?> clazz = null;
        try {
            clazz = this.getClass();
            Field field = clazz.getField(string);
            n = (Integer)field.get(null);
            if (n != -1) {
                string2 = bl ? this.getString(n, locale) : NlsResourceClass.alterString(this.getString(n, locale));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            string2 = this.getFallbackResourceString(string, clazz.toString(), locale);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = this.getFallbackResourceString(string, clazz.toString(), locale);
        }
        return string2;
    }

    public String getString(String string, Object[] objectArray, Locale locale) {
        return MessageFormat.format(this.getString(string, locale), objectArray);
    }

    public String getString(int n, Locale locale) {
        return this.getString(n, locale, false);
    }

    public String getString(int n, Locale locale, boolean bl) {
        if (locale == null) {
            throw new IllegalArgumentException("NlsResourceClass.getString(...) - the 'locale' paramater is required");
        }
        String string = Integer.toString(n);
        ResourceBundle resourceBundle = null;
        String string2 = this.getBundleName();
        try {
            if (this instanceof NlsResourceBundle) {
                resourceBundle = ((NlsResourceBundle)this).getBundle(string2, locale);
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingResourceException("Missing resource bundle: ", string2, null);
        }
        String string3 = null;
        try {
            if (resourceBundle != null) {
                string3 = bl ? resourceBundle.getString(string) : NlsResourceClass.alterString(resourceBundle.getString(string));
            }
        }
        catch (MissingResourceException missingResourceException) {
            string3 = this.getFallbackResourceString(string, string2, locale);
        }
        return string3;
    }

    public String getString(int n, Object[] objectArray, Locale locale) {
        return MessageFormat.format(this.getString(n, locale), objectArray);
    }

    public abstract String getBundleName();

    public static void setNlsTesting(boolean bl) {
        NlsResourceBundle.clearStringCache();
        m_bNlsTest = bl;
    }

    public static boolean isNlsTesting() {
        return m_bNlsTest;
    }

    public static void setFarEastTesting(boolean bl) {
        NlsResourceBundle.clearStringCache();
        m_bFarEastTest = bl;
    }

    public static boolean isFarEastTesting() {
        return m_bFarEastTest;
    }

    public static void setLongStringTesting(boolean bl) {
        NlsResourceBundle.clearStringCache();
        m_bLongStringTest = bl;
    }

    public static boolean isLongStringTesting() {
        return m_bLongStringTest;
    }

    protected static String alterString(String string) {
        String string2 = string;
        if (string2 != null && string2.length() > 0) {
            if (NlsResourceClass.isFarEastTesting()) {
                string2 = NlsResourceClass.convertStringToFarEasternTest(string2);
            }
            if (NlsResourceClass.isLongStringTesting()) {
                string2 = NlsResourceClass.increaseLengthOfString(string2);
            }
            if (NlsResourceClass.isNlsTesting()) {
                string2 = NlsResourceClass.addXesToString(string2);
            }
        }
        return string2;
    }

    protected static String addXesToString(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
            stringBuffer.append(XX_STRING).append(string).append(XX_STRING);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected static String convertStringToFarEasternTest(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                char c2 = c;
                if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    stringBuffer.append((char)(c2 + 65248));
                    continue;
                }
                stringBuffer.append(c);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected static String increaseLengthOfString(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (!Character.isLetter(c) || i >= string.length() - 1) continue;
                stringBuffer.append('_');
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected static String constructMissingResourceString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Missing resource string: ").append(string).append(" Resource: ").append(string2);
        Trace.println(stringBuffer.toString());
        return NlsResourceClass.addXesToString(string);
    }

    final String getFallbackResourceString(String string, String string2, Locale locale) {
        String string3 = null;
        String string4 = locale.getLanguage();
        String string5 = locale.getCountry();
        Locale locale2 = LocaleService.createLocale(EN_US_LOCALE);
        String string6 = locale2.getLanguage();
        String string7 = locale2.getCountry();
        if (!string4.equals(string6) && !string5.equals(string7) && LocaleService.fallbackToEnglishLocale(this.getConfigService()) && this.stringExists(string, locale2)) {
            string3 = this.getString(string, locale2);
        }
        if (string3 == null) {
            string3 = NlsResourceClass.constructMissingResourceString(string, string2);
        }
        return string3;
    }
}

