/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import java.io.Serializable;
import java.math.BigInteger;

class SearchCandidate
implements Comparable,
Serializable {
    private int m_index;
    private byte[] m_relevance;
    private BigInteger m_relValue = null;
    boolean m_bValid;

    public SearchCandidate(int n, int n2) {
        this.m_index = n;
        this.m_relevance = new byte[n2];
        this.m_bValid = true;
    }

    public void reset() {
        this.m_index = -1;
        this.m_bValid = true;
        this.m_relValue = null;
        int n = this.m_relevance.length;
        for (int i = 0; i < n; ++i) {
            this.m_relevance[i] = 0;
        }
    }

    public boolean isValid() {
        return this.m_bValid;
    }

    public void setInvalid() {
        this.m_bValid = false;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public void setRelevance(int n, int n2) {
        if (n2 > 255) {
            throw new IllegalArgumentException("Relevance value exceeds 255");
        }
        this.m_relevance[n] = (byte)n2;
    }

    public int compareTo(Object object) {
        SearchCandidate searchCandidate = (SearchCandidate)object;
        return this.getRelevanceValue().compareTo(searchCandidate.getRelevanceValue());
    }

    public boolean equals(Object object) {
        if (object instanceof SearchCandidate) {
            SearchCandidate searchCandidate = (SearchCandidate)object;
            return this.getRelevanceValue().equals(searchCandidate.getRelevanceValue());
        }
        return false;
    }

    public int hashCode() {
        return this.m_relValue == null ? super.hashCode() : this.m_relValue.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append('{').append("index=").append(this.m_index).append("; rel=");
        int n = this.m_relevance.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[').append(this.m_relevance[i]).append(']');
        }
        stringBuffer.append("==").append(this.m_relValue == null ? "null" : this.m_relValue.toString()).append(this.m_bValid ? " VALID" : " INVALID").append('}');
        return stringBuffer.toString();
    }

    protected BigInteger getRelevanceValue() {
        if (this.m_relValue == null) {
            this.m_relValue = new BigInteger(1, this.m_relevance);
        }
        return this.m_relValue;
    }
}

