/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IQualifier;
import com.documentum.services.config.impl.ConfigKey;
import com.documentum.services.config.impl.ConfigService;
import com.documentum.services.config.impl.ScopeKey;
import com.documentum.services.config.impl.ScopedDictionary;
import com.documentum.services.config.util.Trace;
import java.util.HashSet;
import java.util.LinkedList;

class PrimaryElementsByScopeDictionary {
    private String m_strName;
    private ScopedDictionary m_dictionary;
    private ConfigService m_configSvc;

    public PrimaryElementsByScopeDictionary(ConfigService configService, String string, int n) {
        this.m_strName = string;
        this.m_dictionary = new ScopedDictionary(n);
        this.m_configSvc = configService;
    }

    public void init(IQualifier[] iQualifierArray) {
        if (iQualifierArray == null) {
            throw new RuntimeException("Scope Dictionary initialized with null qualifiers");
        }
        this.m_dictionary.setQualifiers(iQualifierArray);
    }

    public synchronized IConfigElement get(String string, ScopeKey scopeKey) {
        if (Trace.CONFIGSERVICE) {
            Trace.println(this, "\tLookup dictionary '" + this.m_strName + "': Resolving scope");
        }
        IConfigElement iConfigElement = null;
        ConfigKey configKey = this.createLookupKey(string, scopeKey);
        Object object = this.m_dictionary.get(configKey);
        if (object != null) {
            iConfigElement = ScopedDictionary.NULL_SENTINEL.equals(object) ? null : (IConfigElement)object;
        }
        return iConfigElement;
    }

    public synchronized IConfigElement getAbsolute(String string, ScopeKey scopeKey) {
        ConfigKey configKey = this.createLookupKey(string, scopeKey);
        Object object = this.m_dictionary.getExact(configKey);
        if (!ScopedDictionary.NULL_SENTINEL.equals(object)) {
            return (IConfigElement)object;
        }
        return null;
    }

    public synchronized void put(String string, ScopeKey scopeKey, IConfigElement iConfigElement) {
        ConfigKey configKey = this.createLookupKey(string, scopeKey);
        Object object = this.m_dictionary.getExact(configKey);
        if (object != null) {
            String string2 = null;
            String string3 = null;
            if (object instanceof IConfigElement) {
                string3 = this.m_configSvc.getConfigFilePathName((IConfigElement)object);
                string2 = "Lookup dictionary '" + this.m_strName + "': Duplicate element '" + string + "', scope='" + scopeKey.toString() + "', config files='" + this.m_configSvc.getConfigFilePathName(iConfigElement) + "' and '" + string3 + "'";
            } else if (object == ScopedDictionary.NULL_SENTINEL) {
                string2 = "Lookup dictionary '" + this.m_strName + "': Duplicate element '" + string + "', scope='" + scopeKey.toString() + "', duplicate config file='" + this.m_configSvc.getConfigFilePathName(iConfigElement) + "', existing config entry is a placeholder indicating the element is explicitly undefined.";
            }
            throw new IllegalStateException(string2);
        }
        boolean bl = this.m_configSvc.isMarkedAsNotDefined(iConfigElement);
        if (scopeKey.m_bUndefine && bl) {
            throw new IllegalStateException("Lookup dictionary '" + this.m_strName + "': Cannot use 'notdefined' within scope that includes 'not' keyword: " + iConfigElement.toString());
        }
        if (scopeKey.m_bUndefine | bl) {
            this.m_dictionary.put(configKey, ScopedDictionary.NULL_SENTINEL);
            if (Trace.CONFIGSERVICE) {
                Trace.println(this, "\tLookup dictionary '" + this.m_strName + "': Clearing =" + string + ", scope='" + scopeKey.toString() + "', element='" + iConfigElement.toString() + "'");
            }
        } else {
            this.m_dictionary.put(configKey, iConfigElement);
            if (Trace.CONFIGSERVICE) {
                Trace.println(this, "\tLookup dictionary '" + this.m_strName + "': Setting =" + string + ", scope='" + scopeKey.toString() + "', config file='" + iConfigElement.toString() + "'");
            }
        }
    }

    public synchronized void remove(String string, ScopeKey scopeKey) {
        ConfigKey configKey = this.createLookupKey(string, scopeKey);
        Object object = this.m_dictionary.getExact(configKey);
        if (object == null) {
            return;
        }
        this.m_dictionary.remove(configKey);
        if (Trace.CONFIGSERVICE) {
            Trace.println(this, "\tLookup dictionary '" + this.m_strName + "': Removing =" + string + ", scope='" + scopeKey.toString());
        }
    }

    public String[] getPrimaryElementIds(String string) {
        String[] stringArray2;
        HashSet<String> hashSet = new HashSet<String>(127);
        for (String[] stringArray2 : this.m_dictionary.keySet()) {
            String string2 = stringArray2.toString();
            if (!string2.startsWith(string)) continue;
            int n = string2.indexOf("[id=");
            int n2 = string2.indexOf("]");
            if (n != string.length() || n2 <= n || !(this.m_dictionary.get((ConfigKey)stringArray2) instanceof IConfigElement)) continue;
            String string3 = string2.substring(n + 4, n2);
            hashSet.add(string3);
        }
        stringArray2 = new String[hashSet.size()];
        hashSet.toArray(stringArray2);
        return stringArray2;
    }

    public String[] getPrimaryElementScopes(String string) {
        IConfigElement[] iConfigElementArray = this.getPrimaryElements(string);
        String[] stringArray = new String[iConfigElementArray.length];
        for (int i = 0; i < iConfigElementArray.length; ++i) {
            stringArray[i] = this.m_configSvc.getPrimaryElementScopeEx(iConfigElementArray[i]);
        }
        return stringArray;
    }

    public IConfigElement[] getPrimaryElements(String string) {
        IConfigElement[] iConfigElementArray2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (IConfigElement[] iConfigElementArray2 : this.m_dictionary.keySet()) {
            Object object;
            if (!iConfigElementArray2.m_primElem.equals(string) || !((object = this.m_dictionary.get((ConfigKey)iConfigElementArray2)) instanceof IConfigElement)) continue;
            linkedList.add(object);
        }
        iConfigElementArray2 = new IConfigElement[linkedList.size()];
        linkedList.toArray(iConfigElementArray2);
        return iConfigElementArray2;
    }

    public void trace() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("PrimaryElementsByScopeDictionary (");
        stringBuffer.append(this.m_strName);
        stringBuffer.append("), size: ");
        stringBuffer.append(this.m_dictionary.size());
        Trace.println(this, stringBuffer.toString());
    }

    private ConfigKey createLookupKey(String string, ScopeKey scopeKey) {
        return new ConfigKey(string, scopeKey);
    }
}

