/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.ConfigException;
import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IConfigFile;
import com.documentum.services.config.impl.ConfigElement;
import com.documentum.services.config.impl.ConfigService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigFile
extends ConfigElement
implements IConfigFile {
    private String m_strPathName;
    private static DocumentBuilderFactory g_builderFactory = DocumentBuilderFactory.newInstance();

    public ConfigFile(String string, ConfigService configService) {
        super(ConfigFile.loadXML(string), null, configService);
        this.m_strPathName = string;
    }

    public String getPathName() {
        return this.m_strPathName;
    }

    public IConfigElement getConfigElement() {
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (this.m_strPathName != null) {
            stringBuilder.append('(');
            stringBuilder.append(this.m_strPathName);
            stringBuilder.append(')');
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    private static Element loadXML(String string) {
        Element element = null;
        InputStream inputStream = ConfigFile.getResourceAsStream(string);
        if (inputStream == null) {
            throw new ConfigException("Can not find the config file: " + string);
        }
        try {
            DocumentBuilder documentBuilder = g_builderFactory.newDocumentBuilder();
            ErrorListener errorListener = new ErrorListener();
            documentBuilder.setErrorHandler(errorListener);
            InputSource inputSource = new InputSource(inputStream);
            Document document = documentBuilder.parse(inputSource);
            if (errorListener.getNumberOfErrors() > 0 || errorListener.getNumberOfWarnings() > 0) {
                throw new IllegalStateException(errorListener.getWarningErrorMessages());
            }
            element = document.getDocumentElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigException("Cannot load XML parser", (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ConfigException("SAXException parsing: " + string, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new ConfigException("IOException reading: " + string, (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return element;
    }

    private static InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        try {
            inputStream = ConfigFile.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            return inputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigException("No config file.", (Throwable)fileNotFoundException);
        }
    }

    static {
        g_builderFactory.setNamespaceAware(true);
    }

    private static class ErrorListener
    implements ErrorHandler {
        private StringBuffer m_strWarningErrorMessages = new StringBuffer(256);
        private int m_nNoOfErrors = 0;
        private int m_nNoOfWarnings = 0;

        private ErrorListener() {
        }

        public void error(SAXParseException sAXParseException) {
            this.m_strWarningErrorMessages.append("XML parse error occurred at line ");
            this.m_strWarningErrorMessages.append(sAXParseException.getLineNumber());
            this.m_strWarningErrorMessages.append(" column ");
            this.m_strWarningErrorMessages.append(sAXParseException.getColumnNumber());
            this.m_strWarningErrorMessages.append(" - ");
            this.m_strWarningErrorMessages.append(sAXParseException.toString());
            this.m_strWarningErrorMessages.append("\n");
            ++this.m_nNoOfErrors;
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.m_strWarningErrorMessages.append("XML parse fatal error occurred at line ");
            this.m_strWarningErrorMessages.append(sAXParseException.getLineNumber());
            this.m_strWarningErrorMessages.append(" column ");
            this.m_strWarningErrorMessages.append(sAXParseException.getColumnNumber());
            this.m_strWarningErrorMessages.append(" - ");
            this.m_strWarningErrorMessages.append(sAXParseException.toString());
            this.m_strWarningErrorMessages.append("\n");
            ++this.m_nNoOfErrors;
        }

        public void warning(SAXParseException sAXParseException) {
            this.m_strWarningErrorMessages.append("XML parse warning occurred at line ");
            this.m_strWarningErrorMessages.append(sAXParseException.getLineNumber());
            this.m_strWarningErrorMessages.append(" column ");
            this.m_strWarningErrorMessages.append(sAXParseException.getColumnNumber());
            this.m_strWarningErrorMessages.append(" - ");
            this.m_strWarningErrorMessages.append(sAXParseException.toString());
            this.m_strWarningErrorMessages.append("\n");
            ++this.m_nNoOfWarnings;
        }

        public int getNumberOfErrors() {
            return this.m_nNoOfErrors;
        }

        public int getNumberOfWarnings() {
            return this.m_nNoOfWarnings;
        }

        public String getWarningErrorMessages() {
            return this.m_strWarningErrorMessages.toString();
        }
    }
}

