/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.impl;

import com.documentum.services.config.ConfigException;
import com.documentum.services.config.IConfigElement;
import com.documentum.services.config.IDocbaseContext;
import com.documentum.services.config.INlsContext;
import com.documentum.services.config.impl.ArgumentList;
import com.documentum.services.config.impl.ConfigService;
import com.documentum.services.config.impl.ElementPath;
import com.documentum.services.config.nls.LocaleService;
import com.documentum.services.config.nls.NlsResourceBundle;
import com.documentum.services.config.nls.NlsResourceClass;
import com.documentum.services.config.util.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigElement
implements IConfigElement {
    private static final String NLSID = "nlsid";
    private static final String NLSBUNDLE = "nlsbundle";
    private static final String NLSCLASS = "nlsclass";
    private static final String FILTER = "filter";
    private static final String INSERT = "insert";
    private static final String INSERTFIRST = "insertfirst";
    private static final String INSERTAFTER = "insertafter";
    private static final String INSERTBEFORE = "insertbefore";
    private static final String REMOVE = "remove";
    private static final String REPLACE = "replace";
    private static final String PATH = "path";
    private static final int CAPACITY_CHILDREN = 5;
    private static final int CAPACITY_FILTERS = 1;
    private static ConfigService.LookupFilter SOLE_SCOPELESS_ELEMENT_FILTER = null;
    private static ConfigService.LookupFilter MULTIPLE_SCOPELESS_ELEMENT_FILTER = null;
    private static final ConfigElement SOLE_ELEMENT_MARKER = new ConfigElement("SoleElementMarker", null);
    private static final ConfigElement MULTIPLE_ELEMENT_MARKER = new ConfigElement("MultipleElementMarker", null);
    private ConfigService m_configService;
    private String m_strName;
    private String m_strValue;
    private String m_strNLSid;
    private NlsResourceClass m_nlsClass;
    private IConfigElement m_parent;
    private AppLevelElement m_originalParent;
    private ArrayList<IConfigElement> m_children;
    private HashMap m_uniqueChildren;
    private ArgumentList m_attributes;
    private ArrayList<ConfigService.LookupFilter> m_filters = null;

    public String getName() {
        return this.m_strName;
    }

    public IConfigElement getParent() {
        return this.m_parent;
    }

    public String getValue() {
        String string;
        if (this.m_strNLSid != null) {
            NlsResourceClass nlsResourceClass = this.getNlsClass();
            if (nlsResourceClass == null) {
                throw new IllegalStateException("'nlsbundle' or 'nlsclass' tag not resolved " + this.toString());
            }
            string = nlsResourceClass.getString(this.m_strNLSid, this.getLocale());
        } else {
            string = this.m_strValue;
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public Boolean getValueAsBoolean() {
        if (this.m_strValue != null) {
            if (this.m_strValue.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (this.m_strValue.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Integer getValueAsInteger() {
        if (this.m_strValue != null) {
            return new Integer(this.m_strValue);
        }
        return null;
    }

    public String getAttributeValue(String string) {
        if (this.m_attributes != null) {
            return (String)this.m_attributes.get(string);
        }
        return null;
    }

    public Boolean getAttributeValueAsBoolean(String string) {
        String string2;
        if (this.m_attributes != null && (string2 = (String)this.m_attributes.get(string)) != null) {
            if (string2.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string2.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Integer getAttributeValueAsInteger(String string) {
        String string2;
        if (this.m_attributes != null && (string2 = (String)this.m_attributes.get(string)) != null) {
            return new Integer(string2);
        }
        return null;
    }

    public Iterator<String> getAttributeNames() {
        if (this.m_attributes != null) {
            return this.m_attributes.keySet().iterator();
        }
        return new ArrayList().iterator();
    }

    void setAttributeValue(String string, String string2) {
        if (this.m_attributes == null) {
            this.m_attributes = new ArgumentList();
        }
        this.m_attributes.put(string, string2);
    }

    void setAttributeValue(String string, boolean bl) {
        if (this.m_attributes == null) {
            this.m_attributes = new ArgumentList();
        }
        this.m_attributes.put(string, bl ? "true" : "false");
    }

    void setAttributeValue(String string, int n) {
        if (this.m_attributes == null) {
            this.m_attributes = new ArgumentList();
        }
        this.m_attributes.put(string, Integer.toString(n));
    }

    public Iterator<IConfigElement> getChildElements() {
        return this.getChildElements(false);
    }

    Iterator<IConfigElement> getChildElements(boolean bl) {
        if (this.m_children != null) {
            ArrayList<IConfigElement> arrayList = new ArrayList<IConfigElement>(this.m_children.size());
            for (IConfigElement iConfigElement : this.m_children) {
                if (!bl && !this.isVisible(iConfigElement)) continue;
                arrayList.add(iConfigElement);
            }
            return arrayList.iterator();
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    public Iterator<IConfigElement> getChildElements(String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        Pattern pattern = new Pattern(string);
        if (this.m_uniqueChildren != null && (object = (IConfigElement)this.m_uniqueChildren.get(pattern.getName())) != null && pattern.matches((IConfigElement)object) && this.isVisible((IConfigElement)object)) {
            arrayList.add(object);
        }
        if (this.m_children != null && arrayList.size() == 0) {
            for (IConfigElement iConfigElement : this.m_children) {
                if (!pattern.matches(iConfigElement) || !this.isVisible(iConfigElement)) continue;
                arrayList.add(iConfigElement);
            }
        }
        return arrayList.iterator();
    }

    public IConfigElement getChildElement(String string) {
        IConfigElement iConfigElement;
        IConfigElement iConfigElement2 = null;
        Pattern pattern = new Pattern(string);
        if (this.m_uniqueChildren != null && (iConfigElement = (IConfigElement)this.m_uniqueChildren.get(pattern.getName())) != null && pattern.matches(iConfigElement) && this.isVisible(iConfigElement)) {
            iConfigElement2 = iConfigElement;
        }
        if (iConfigElement2 == null && this.m_children != null) {
            iConfigElement = null;
            ArrayList<IConfigElement> arrayList = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                IConfigElement iConfigElement3 = this.m_children.get(i);
                if (!pattern.matches(iConfigElement3) || !this.isVisible(iConfigElement3)) continue;
                if (iConfigElement == null) {
                    iConfigElement = iConfigElement3;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<IConfigElement>();
                    arrayList.add(iConfigElement);
                }
                arrayList.add(iConfigElement3);
            }
            iConfigElement2 = arrayList != null ? this.getMostRelevantVisible(arrayList) : iConfigElement;
        }
        return iConfigElement2;
    }

    public String getChildValue(String string) {
        IConfigElement iConfigElement = this.getChildElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValue();
        }
        return null;
    }

    public Boolean getChildValueAsBoolean(String string) {
        IConfigElement iConfigElement = this.getChildElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValueAsBoolean();
        }
        return null;
    }

    public Integer getChildValueAsInteger(String string) {
        IConfigElement iConfigElement = this.getChildElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValueAsInteger();
        }
        return null;
    }

    public IConfigElement getDescendantElement(String string) {
        ConfigElement configElement = this;
        for (String string2 : new ElementPath(string)) {
            if (configElement == null) continue;
            configElement = configElement.getChildElement(string2);
        }
        return configElement;
    }

    public String getDescendantValue(String string) {
        IConfigElement iConfigElement = this.getDescendantElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValue();
        }
        return null;
    }

    public Boolean getDescendantValueAsBoolean(String string) {
        IConfigElement iConfigElement = this.getDescendantElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValueAsBoolean();
        }
        return null;
    }

    public Integer getDescendantValueAsInteger(String string) {
        IConfigElement iConfigElement = this.getDescendantElement(string);
        if (iConfigElement != null) {
            return iConfigElement.getValueAsInteger();
        }
        return null;
    }

    void setParent(IConfigElement iConfigElement) {
        if (this.m_parent != iConfigElement) {
            this.m_parent = iConfigElement;
            if (this.m_parent != null) {
                ((ConfigElement)this.m_parent).addChildElement(this);
            }
        }
    }

    void addChildElement(IConfigElement iConfigElement) {
        if (iConfigElement.getParent() != this) {
            if (this.m_children == null) {
                this.m_children = new ArrayList(5);
            }
            this.m_children.add(iConfigElement);
            this.updateUniqueChildren();
            ((ConfigElement)iConfigElement).setParent(this);
        }
    }

    public String toString() {
        ConfigElement configElement;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.m_originalParent != null && this.m_originalParent.getElement() instanceof ConfigElement) {
            configElement = (ConfigElement)this.m_originalParent.getElement();
            stringBuffer.append(configElement.toString());
            stringBuffer.append('.');
        } else if (this.m_parent != null && this.m_parent instanceof ConfigElement) {
            configElement = (ConfigElement)this.m_parent;
            stringBuffer.append(configElement.toString());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.m_strName);
        boolean bl = false;
        Iterator<String> iterator = this.getAttributeNames();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append('[');
                bl = true;
            } else {
                stringBuffer.append(',');
            }
            String string = iterator.next();
            String string2 = this.getAttributeValue(string);
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(string2);
        }
        if (bl) {
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    ConfigElement() {
    }

    public ConfigElement(String string, String string2) {
        this.m_strName = string;
        this.m_strValue = string2 != null && string2.length() == 0 ? null : string2;
    }

    public ConfigElement(Element element, ConfigElement configElement, ConfigService configService) {
        Object object;
        Object object2;
        Object object3;
        this.m_configService = configService;
        this.m_parent = configElement;
        this.m_strName = element.getTagName();
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            this.m_strValue = node.getNodeValue();
            if (this.m_strValue != null) {
                this.m_strValue = this.m_strValue.trim();
                if (this.m_strValue.length() == 0) {
                    this.m_strValue = null;
                }
            }
        }
        if (this.m_strName.equals(NLSID)) {
            if (configElement == null) {
                throw new IllegalStateException("Invalid placement of nlsclass tag");
            }
            configElement.m_strNLSid = this.m_strValue;
        } else if (this.m_strName.equals(NLSBUNDLE)) {
            if (configElement == null) {
                throw new IllegalStateException("Invalid placement of nlsbundle tag");
            }
            configElement.m_nlsClass = new NlsResourceBundle(this.m_strValue);
            configElement.m_nlsClass.setConfigService(this.m_configService);
        } else if (this.m_strName.equals(NLSCLASS)) {
            if (configElement == null) {
                throw new IllegalStateException("Invalid placement of nlsbundle tag");
            }
            try {
                object3 = Class.forName(this.m_strValue);
                configElement.m_nlsClass = (NlsResourceClass)((Class)object3).newInstance();
                configElement.m_nlsClass.setConfigService(this.m_configService);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigException("Nls class not found: " + this.m_strValue, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new ConfigException("Nls class instantiation exception: " + this.m_strValue, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ConfigException("Nls class access exception exception: " + this.m_strValue, (Throwable)illegalAccessException);
            }
        }
        object3 = element.getAttributes();
        for (int i = 0; i < object3.getLength(); ++i) {
            if (this.m_attributes == null) {
                this.m_attributes = new ArgumentList();
            }
            object2 = object3.item(i);
            object = object2.getNodeName();
            String string = object2.getNodeValue();
            this.m_attributes.put(object, string);
        }
        ConfigService.LookupFilter lookupFilter = null;
        if (this.m_strName.equals(FILTER) && configElement != null) {
            lookupFilter = configService.getLookupFilter(this, false);
        }
        object2 = this;
        if (lookupFilter != null) {
            object2 = configElement;
        }
        if ((object = element.getChildNodes()) != null) {
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = object.item(i);
                if (node2.getNodeType() == 1) {
                    Element element2 = (Element)node2;
                    ConfigElement configElement2 = new ConfigElement(element2, (ConfigElement)object2, configService);
                    if (!FILTER.equals(element2.getTagName())) {
                        if (((ConfigElement)object2).m_children == null) {
                            ((ConfigElement)object2).m_children = new ArrayList(5);
                        }
                        ((ConfigElement)object2).m_children.add(configElement2);
                    }
                    if (lookupFilter == null) continue;
                    if (configElement2.m_filters == null) {
                        configElement2.m_filters = new ArrayList(1);
                    }
                    configElement2.m_filters.add(lookupFilter);
                    continue;
                }
                if (node2.getNodeType() != 4) continue;
                this.m_strValue = node2.getNodeValue();
                if (this.m_strValue == null) continue;
                this.m_strValue = this.m_strValue.trim();
                if (this.m_strValue.length() != 0) continue;
                this.m_strValue = null;
            }
        }
    }

    Set<ConfigElement> applyModification(ConfigElement configElement, int n) {
        HashSet<ConfigElement> hashSet = new HashSet<ConfigElement>();
        if (Trace.CONFIGMODIFICATION) {
            Trace.println(this, "apply modification of app level " + n + ": " + configElement);
            Trace.println(this, "to primary element: " + this);
        }
        if (configElement.m_children == null || configElement.m_children.size() == 0) {
            return hashSet;
        }
        ConfigElement configElement2 = (ConfigElement)configElement.m_parent;
        for (IConfigElement iConfigElement : configElement.m_children) {
            ConfigElement configElement3;
            ConfigElement configElement4 = (ConfigElement)iConfigElement;
            String string = configElement4.getName();
            String string2 = configElement4.getAttributeValue(PATH);
            if (!(string2 != null && string2.length() != 0 || string.equals(INSERT) || string.equals(INSERTFIRST))) {
                throw new IllegalStateException("path is required for modification action: " + configElement4);
            }
            if (string2 == null || string2.length() == 0) {
                configElement3 = this;
            } else {
                try {
                    configElement3 = this.getModificationTarget(string2, n);
                    if (configElement3 == null) {
                        throw new IllegalStateException("Can't locate a unique child element with path: " + string2 + " in: " + this + ".  \nThe path is specified by: " + configElement4);
                    }
                }
                catch (IndistinguishableModificationTargetException indistinguishableModificationTargetException) {
                    throw new IllegalStateException("There are more than one child elements with path: " + string2 + ".  " + indistinguishableModificationTargetException.getMessage() + ".  \nThe path is specified by: " + configElement4);
                }
            }
            hashSet.add(configElement3);
            ConfigElement configElement5 = null;
            if (Trace.CONFIGMODIFICATION) {
                Trace.println(this, "modification action: " + ConfigElement.toShortString(configElement4));
                Trace.println(this, ">>> original target element: ");
                configElement5 = string.equals(INSERT) || string.equals(INSERTFIRST) ? configElement3 : (ConfigElement)configElement3.m_parent;
                ConfigElement.traceModificationTarget(configElement5);
            }
            if (string.equals(INSERT)) {
                configElement3.addModificationAsChild(configElement4, configElement2, -1, n);
            } else if (string.equals(INSERTFIRST)) {
                configElement3.addModificationAsChild(configElement4, configElement2, 0, n);
            } else if (string.equals(INSERTAFTER)) {
                configElement3.addModificationAsSibling(configElement4, configElement2, true, n);
            } else if (string.equals(INSERTBEFORE)) {
                configElement3.addModificationAsSibling(configElement4, configElement2, false, n);
            } else if (string.equals(REMOVE)) {
                configElement3.applyRemoveModification(configElement4, configElement2, n);
            } else if (string.equals(REPLACE)) {
                configElement3.applyRemoveModification(configElement4, configElement2, n);
                configElement3.addModificationAsSibling(configElement4, configElement2, true, n);
            } else {
                throw new IllegalStateException("Unsupported modification action: " + configElement4);
            }
            if (!Trace.CONFIGMODIFICATION) continue;
            Trace.println(this, "<<< modified target element: ");
            ConfigElement.traceModificationTarget(configElement5);
        }
        this.updateUniqueChildren();
        if (configElement2.m_children != null) {
            configElement2.m_children.remove(configElement);
            configElement2.updateUniqueChildren();
        }
        return hashSet;
    }

    IConfigElement getOriginalParent() {
        IConfigElement iConfigElement = null;
        if (this.m_originalParent != null) {
            iConfigElement = this.m_originalParent.getElement();
        }
        return iConfigElement;
    }

    private void applyRemoveModification(ConfigElement configElement, ConfigElement configElement2, int n) {
        if (configElement.getName().equals(REMOVE) && configElement.m_children != null && configElement.m_children.size() > 0) {
            throw new IllegalStateException("remove modification is not allowed to have sub elements: " + configElement);
        }
        ConfigElement configElement3 = new ConfigElement(FILTER, null);
        configElement3.m_parent = this.m_parent;
        configElement3.m_originalParent = new AppLevelElement(configElement, n);
        configElement3.m_children = null;
        configElement3.m_attributes = new ArgumentList(configElement2.m_attributes);
        configElement3.m_attributes.remove("application");
        String string = (String)configElement3.m_attributes.get("version");
        if ("latest".equals(string)) {
            configElement3.m_attributes.remove("version");
        }
        ConfigService.LookupFilter lookupFilter = this.m_configService.getLookupFilter(configElement3, true);
        if (this.m_filters == null) {
            this.m_filters = new ArrayList(1);
        }
        this.m_filters.add(lookupFilter);
    }

    private void addModificationAsSibling(ConfigElement configElement, ConfigElement configElement2, boolean bl, int n) {
        if (this.m_parent == null) {
            throw new IllegalStateException("Cannot locate parent of modification target: " + this);
        }
        ConfigElement configElement3 = (ConfigElement)this.m_parent;
        int n2 = configElement3.m_children.indexOf(this);
        if (bl) {
            ++n2;
        }
        configElement3.addModificationAsChild(configElement, configElement2, n2, n);
    }

    private void addModificationAsChild(ConfigElement configElement, ConfigElement configElement2, int n, int n2) {
        int n3;
        if (configElement.m_children == null || configElement.m_children.size() == 0) {
            return;
        }
        int n4 = n3 = this.m_children != null ? this.m_children.size() : 0;
        if (n != -1 && n > n3) {
            throw new IllegalStateException("illegal index " + n + " is specified for adding modification: " + configElement);
        }
        ConfigElement configElement3 = new ConfigElement(FILTER, null);
        configElement3.m_parent = this;
        configElement3.m_originalParent = new AppLevelElement(configElement, n2);
        configElement3.m_children = null;
        configElement3.m_attributes = new ArgumentList(configElement2.m_attributes);
        configElement3.m_attributes.remove("application");
        String string = (String)configElement3.m_attributes.get("version");
        if ("latest".equals(string)) {
            configElement3.m_attributes.remove("version");
        }
        ConfigService.LookupFilter lookupFilter = this.m_configService.getLookupFilter(configElement3, false);
        for (IConfigElement iConfigElement : configElement.m_children) {
            ConfigElement configElement4 = (ConfigElement)iConfigElement;
            configElement4.m_originalParent = new AppLevelElement(configElement4.m_parent, n2);
            configElement4.m_parent = this;
            if (configElement4.m_filters == null) {
                configElement4.m_filters = new ArrayList(1);
            }
            configElement4.m_filters.add(lookupFilter);
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList(5);
        }
        if (n == -1) {
            this.m_children.addAll(configElement.m_children);
        } else {
            this.m_children.addAll(n, configElement.m_children);
        }
        this.updateUniqueChildren();
    }

    private ConfigElement getModificationTarget(String string, int n) throws IndistinguishableModificationTargetException {
        ConfigElement configElement = this;
        for (String string2 : new ElementPath(string)) {
            if (configElement == null) continue;
            configElement = configElement.getModificationTargetChildElement(string2, n);
        }
        return configElement;
    }

    private ConfigElement getModificationTargetChildElement(String string, int n) throws IndistinguishableModificationTargetException {
        ConfigElement configElement;
        Pattern pattern = new Pattern(string);
        if (this.m_uniqueChildren != null && (configElement = (ConfigElement)this.m_uniqueChildren.get(pattern.getName())) != null && (configElement.m_originalParent == null || configElement.m_originalParent.getAppLevel() < n) && pattern.matches(configElement)) {
            return configElement;
        }
        configElement = null;
        if (this.m_children != null) {
            ConfigElement configElement2 = null;
            ConfigElement configElement3 = null;
            ConfigElement configElement4 = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                ConfigElement configElement5 = (ConfigElement)this.m_children.get(i);
                if (configElement5.m_originalParent != null && configElement5.m_originalParent.getAppLevel() >= n || !pattern.matches(configElement5)) continue;
                if (configElement5.m_originalParent == null) {
                    if (configElement2 == null) {
                        configElement2 = configElement5;
                        continue;
                    }
                    String string2 = "Indistinguishable modification targets - \nelement 1: " + configElement2 + "; \nelement 2: " + configElement5;
                    throw new IndistinguishableModificationTargetException(string2);
                }
                if (configElement3 == null) {
                    configElement3 = configElement5;
                    continue;
                }
                if (configElement4 != null) continue;
                configElement4 = configElement5;
            }
            if (configElement2 != null) {
                configElement = configElement2;
            } else {
                if (configElement3 != null && configElement4 != null) {
                    String string3 = "Indistinguishable modification targets - \nelement 1: " + configElement3 + "; \nelement 2: " + configElement4;
                    throw new IndistinguishableModificationTargetException(string3);
                }
                configElement = configElement3;
            }
        }
        return configElement;
    }

    private static String toShortString(ConfigElement configElement) {
        String string = configElement.toString();
        int n = string.indexOf(".scope");
        if (n != -1 && (n = (string = string.substring(n + 1)).indexOf("].")) != -1) {
            string = string.substring(n + 2);
        }
        return string;
    }

    private static void traceModificationTarget(ConfigElement configElement) {
        Trace.println(ConfigElement.class, ConfigElement.toShortString(configElement));
        if (configElement.m_children == null || configElement.m_children.size() == 0) {
            Trace.println(ConfigElement.class, "no children");
        } else {
            StringBuffer stringBuffer = new StringBuffer(128);
            String string = ".filter";
            String string2 = "negate-";
            for (IConfigElement iConfigElement : configElement.m_children) {
                String string3;
                boolean bl;
                ConfigElement configElement2 = (ConfigElement)iConfigElement;
                stringBuffer.append("\n   child: ");
                if (configElement2.m_filters != null && configElement2.m_filters.size() > 0) {
                    bl = false;
                    for (ConfigService.LookupFilter lookupFilter : configElement2.m_filters) {
                        int n;
                        if (bl) {
                            stringBuffer.append(", ");
                        }
                        if ((n = (string3 = lookupFilter.toString()).indexOf(string)) != -1) {
                            boolean bl2 = string3.indexOf(string2) != -1;
                            string3 = string3.substring(n + 1);
                            if (bl2) {
                                string3 = string2 + string3;
                            }
                        }
                        stringBuffer.append(string3);
                        bl = true;
                    }
                    stringBuffer.append(" ");
                }
                stringBuffer.append(configElement2.m_strName);
                bl = false;
                Iterator<Object> iterator = configElement2.getAttributeNames();
                while (iterator.hasNext()) {
                    if (!bl) {
                        stringBuffer.append('[');
                        bl = true;
                    } else {
                        stringBuffer.append(',');
                    }
                    String string4 = (String)iterator.next();
                    string3 = configElement2.getAttributeValue(string4);
                    stringBuffer.append(string4);
                    stringBuffer.append('=');
                    stringBuffer.append(string3);
                }
                if (!bl) continue;
                stringBuffer.append(']');
            }
            Trace.println(ConfigElement.class, stringBuffer.toString());
        }
    }

    private NlsResourceClass getNlsClass() {
        if (this.m_nlsClass == null) {
            NlsResourceClass nlsResourceClass = null;
            ConfigElement configElement = this;
            while (configElement != null) {
                IConfigElement iConfigElement;
                if (configElement.m_nlsClass != null) {
                    nlsResourceClass = configElement.m_nlsClass;
                    break;
                }
                if (configElement.m_parent != null && configElement.m_parent.getName().equals("scope") && (iConfigElement = configElement.getExtendedElement()) != null && iConfigElement instanceof ConfigElement && (nlsResourceClass = ((ConfigElement)iConfigElement).getNlsClass()) != null) break;
                configElement = (ConfigElement)configElement.m_parent;
            }
            this.m_nlsClass = nlsResourceClass;
        }
        return this.m_nlsClass;
    }

    private IConfigElement getExtendedElement() {
        return this.m_configService.getExtendedElement(this);
    }

    private boolean isVisible(IConfigElement iConfigElement) {
        if (iConfigElement instanceof ConfigElement) {
            ConfigElement configElement = (ConfigElement)iConfigElement;
            if (configElement.m_filters != null) {
                for (int i = 0; i < configElement.m_filters.size(); ++i) {
                    ConfigService.LookupFilter lookupFilter = configElement.m_filters.get(i);
                    if (lookupFilter.showContents()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private IConfigElement getMostRelevantVisible(List<IConfigElement> list) {
        IConfigElement iConfigElement2;
        HashMap<ConfigService.LookupFilter, IConfigElement> hashMap = new HashMap<ConfigService.LookupFilter, IConfigElement>();
        boolean bl = false;
        boolean bl2 = false;
        for (IConfigElement iConfigElement2 : list) {
            ConfigService.LookupFilter lookupFilter;
            if (!(iConfigElement2 instanceof ConfigElement)) {
                return null;
            }
            boolean bl3 = false;
            ConfigElement configElement = (ConfigElement)iConfigElement2;
            if (configElement.m_filters != null) {
                for (int i = 0; i < configElement.m_filters.size(); ++i) {
                    lookupFilter = configElement.m_filters.get(i);
                    if (lookupFilter.isNegated()) continue;
                    bl3 = true;
                    hashMap.put(lookupFilter, iConfigElement2);
                }
            }
            if (bl3) {
                bl = true;
                continue;
            }
            if (!bl2) {
                bl2 = true;
                ConfigService.LookupFilter lookupFilter2 = this.getScopelessFilter(true);
                hashMap.put(lookupFilter2, configElement);
                continue;
            }
            ConfigService.LookupFilter lookupFilter3 = this.getScopelessFilter(false);
            if (hashMap.containsKey(lookupFilter3)) continue;
            lookupFilter = this.getScopelessFilter(true);
            hashMap.remove(lookupFilter);
            hashMap.put(lookupFilter3, MULTIPLE_ELEMENT_MARKER);
        }
        Object object = !bl ? null : ((iConfigElement2 = this.m_configService.getMostRelevantFilterElement(hashMap)) == MULTIPLE_ELEMENT_MARKER ? null : iConfigElement2);
        return object;
    }

    private void updateUniqueChildren() {
        HashMap<String, String> hashMap = new HashMap<String, String>(17);
        if (this.m_uniqueChildren != null) {
            this.m_uniqueChildren = null;
        }
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                IConfigElement iConfigElement = this.m_children.get(i);
                String string = iConfigElement.getName();
                if (this.m_uniqueChildren == null) {
                    this.m_uniqueChildren = new HashMap(5);
                }
                if (hashMap.get(string) != null) continue;
                if (this.m_uniqueChildren.get(string) == null) {
                    this.m_uniqueChildren.put(string, iConfigElement);
                    continue;
                }
                this.m_uniqueChildren.remove(string);
                hashMap.put(string, "");
            }
        }
    }

    private synchronized ConfigService.LookupFilter getScopelessFilter(boolean bl) {
        if (SOLE_SCOPELESS_ELEMENT_FILTER == null) {
            ConfigElement configElement = SOLE_ELEMENT_MARKER;
            configElement.m_children = null;
            configElement.m_attributes = new ArgumentList();
            SOLE_SCOPELESS_ELEMENT_FILTER = this.m_configService.getLookupFilter(configElement, false);
            configElement = MULTIPLE_ELEMENT_MARKER;
            configElement.m_children = null;
            configElement.m_attributes = new ArgumentList();
            MULTIPLE_SCOPELESS_ELEMENT_FILTER = this.m_configService.getLookupFilter(configElement, false);
        }
        if (bl) {
            return SOLE_SCOPELESS_ELEMENT_FILTER;
        }
        return MULTIPLE_SCOPELESS_ELEMENT_FILTER;
    }

    private Locale getLocale() {
        String string = null;
        IDocbaseContext iDocbaseContext = this.m_configService.getDocbaseContext();
        if (iDocbaseContext instanceof INlsContext) {
            string = ((INlsContext)iDocbaseContext).getLocale();
        }
        Locale locale = string != null ? LocaleService.createLocale(string) : LocaleService.getDefaultLocale(this.m_configService);
        return locale;
    }

    private static class IndistinguishableModificationTargetException
    extends Exception {
        private IndistinguishableModificationTargetException(String string) {
            super(string);
        }
    }

    private static class AppLevelElement {
        private IConfigElement m_element;
        private int m_appLevel;

        AppLevelElement(IConfigElement iConfigElement, int n) {
            this.m_element = iConfigElement;
            this.m_appLevel = n;
        }

        IConfigElement getElement() {
            return this.m_element;
        }

        int getAppLevel() {
            return this.m_appLevel;
        }
    }

    private class Pattern {
        private String m_strName;
        private String m_strAttributeName;
        private String m_strAttributeValue;

        public Pattern(String string) {
            int n = string.indexOf(32);
            if (n != -1) {
                throw new IllegalArgumentException("Invalid Argument 'pattern': 'element-name[attribute-name=attribute-value]'");
            }
            int n2 = string.indexOf(91);
            if (n2 != -1) {
                int n3 = string.indexOf(61, n2);
                if (n3 == -1) {
                    throw new IllegalArgumentException("Invalid Argument 'pattern': Missing '=' in 'element-name[attribute-name=attribute-value]'");
                }
                int n4 = string.indexOf(93, n3);
                if (n4 == -1) {
                    throw new IllegalArgumentException("Invalid Argument 'pattern': Missing ']' in 'element-name[attribute-name=attribute-value]'");
                }
                this.m_strAttributeName = string.substring(n2 + 1, n3);
                if (this.m_strAttributeName == null || this.m_strAttributeName.length() == 0) {
                    throw new IllegalArgumentException("Invalid Argument 'pattern': Missing attribute-name in 'element-name[attribute-name=attribute-value]'");
                }
                this.m_strAttributeValue = string.substring(n3 + 1, n4);
                if (this.m_strAttributeValue == null || this.m_strAttributeValue.length() == 0) {
                    throw new IllegalArgumentException("Invalid Argument 'pattern': Missing attribute-value in 'element-name[attribute-name=attribute-value]'");
                }
                this.m_strName = string.substring(0, n2);
            } else {
                this.m_strName = string;
            }
            if (this.m_strName == null || this.m_strName.length() == 0) {
                throw new IllegalArgumentException("Invalid Argument 'pattern': Missing element-name in 'element-name[attribute-name=attribute-value]'");
            }
        }

        public boolean matches(IConfigElement iConfigElement) {
            String string;
            if (!iConfigElement.getName().equals(this.m_strName)) {
                return false;
            }
            return this.m_strAttributeName == null || (string = iConfigElement.getAttributeValue(this.m_strAttributeName)) != null && string.equals(this.m_strAttributeValue);
        }

        public String getName() {
            return this.m_strName;
        }
    }
}

