/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.services.config.common;

import com.documentum.services.config.IContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class Context
implements IContext,
Serializable {
    private HashMap m_items;
    private Context m_parent;
    private String m_strDesc;
    private static Context m_appContext = Context.initRootContext();
    private static final String ELEMENT_SEPARATOR = "E*E*";
    private static final String VALUE_SEPARATOR = "V*V*";
    private static final String CONTEXT_DESC = "D*D*";
    private static final String CONTEXT_PARENT = "P*P*";

    public Context() {
        this.m_items = new HashMap(7, 1.0f);
        this.m_parent = null;
        this.m_strDesc = "REQUEST";
    }

    public Context(Context context) {
        this.m_items = (HashMap)context.m_items.clone();
        this.m_parent = context.m_parent;
        this.m_strDesc = context.m_strDesc;
    }

    private static Context initRootContext() {
        return new Context("APP", null);
    }

    public static Context getApplicationContext() {
        return m_appContext;
    }

    public static String serialize(Context context) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CONTEXT_DESC);
        stringBuffer.append(VALUE_SEPARATOR);
        stringBuffer.append(context.m_strDesc);
        if (!context.m_items.isEmpty()) {
            object = context.m_items.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = (String)context.m_items.get(string);
                stringBuffer.append(ELEMENT_SEPARATOR);
                stringBuffer.append(string);
                stringBuffer.append(VALUE_SEPARATOR);
                stringBuffer.append(string2);
            }
        }
        if (context.m_parent != null && (object = Context.serialize(context.m_parent)) != null) {
            stringBuffer.append(ELEMENT_SEPARATOR);
            stringBuffer.append(CONTEXT_PARENT);
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public static Context deserialize(String string) {
        ArrayList arrayList = Context.getSerializedElements(string);
        String string2 = Context.getSerializedParent(string);
        Context context = null;
        if (string2 != null) {
            context = Context.deserialize(string2);
        }
        Context context2 = new Context();
        context2.m_parent = context;
        if (arrayList.size() > 0) {
            for (String string3 : arrayList) {
                String string4 = Context.getElementName(string3);
                String string5 = Context.getElementValue(string3);
                if (string4 == null || string5 == null) continue;
                if (string4.equals(CONTEXT_DESC)) {
                    context2.m_strDesc = string5;
                    continue;
                }
                context2.set(string4, string5);
            }
        }
        return context2;
    }

    public void set(String string, String string2) {
        this.m_items.put(string, string2);
    }

    public void remove(String string) {
        this.m_items.remove(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        Context context = this;
        while (context != null) {
            stringBuffer.append(context.m_strDesc);
            stringBuffer.append('(');
            boolean bl = true;
            Iterator iterator = context.m_items.keySet().iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(',');
                }
                bl = false;
                String string = (String)iterator.next();
                String string2 = (String)context.m_items.get(string);
                if (string2 == null) {
                    string2 = "";
                }
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(string2);
            }
            stringBuffer.append(')');
            context = context.m_parent;
        }
        return stringBuffer.toString();
    }

    private String getOnBehalfOfFriend(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Context.get(...) - friend argument is required");
        }
        return this.get(string);
    }

    public String get(String string) {
        String string2 = null;
        Context context = this;
        do {
            string2 = (String)context.m_items.get(string);
            context = context.m_parent;
        } while (string2 == null && context != null);
        return string2;
    }

    private Context(String string, Context context) {
        this.m_items = new HashMap(7, 1.0f);
        this.m_parent = context;
        this.m_strDesc = string;
    }

    private static ArrayList getSerializedElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String string2 = null;
            int n = string.indexOf(CONTEXT_PARENT);
            string2 = n > 0 ? string.substring(0, n - ELEMENT_SEPARATOR.length()) : string;
            if (n != 0) {
                int n2 = string2.indexOf(ELEMENT_SEPARATOR);
                while (n2 >= 0) {
                    arrayList.add(string2.substring(0, n2));
                    string2 = string2.substring(n2 + ELEMENT_SEPARATOR.length());
                    n2 = string2.indexOf(ELEMENT_SEPARATOR);
                }
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static String getSerializedParent(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(CONTEXT_PARENT)) >= 0) {
            string2 = string.substring(n + CONTEXT_PARENT.length());
        }
        return string2;
    }

    private static String getElementName(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(VALUE_SEPARATOR)) >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private static String getElementValue(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(VALUE_SEPARATOR)) >= 0) {
            string2 = string.substring(n + VALUE_SEPARATOR.length());
        }
        return string2;
    }
}

