/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.xerces_2_8_0.xml.serialize;

import com.documentum.xerces_2_8_0.xml.serialize.ObjectFactory;
import com.documentum.xerces_2_8_0.xml.serialize.OutputFormat;
import com.documentum.xerces_2_8_0.xml.serialize.Serializer;
import com.documentum.xerces_2_8_0.xml.serialize.SerializerFactoryImpl;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "com.documentum.xerces_2_8_0.xml.serialize.factories";
    private static Hashtable _factories = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory serializerFactory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String string = serializerFactory.getSupportedMethod();
            _factories.put(string, serializerFactory);
        }
    }

    public static SerializerFactory getSerializerFactory(String string) {
        return (SerializerFactory)_factories.get(string);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static {
        SerializerFactory serializerFactory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        String string = System.getProperty(FactoriesProperty);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,:");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    serializerFactory = (SerializerFactory)ObjectFactory.newInstance(string2, SerializerFactory.class.getClassLoader(), true);
                    if (!_factories.containsKey(serializerFactory.getSupportedMethod())) continue;
                    _factories.put(serializerFactory.getSupportedMethod(), serializerFactory);
                }
                catch (Exception exception) {}
            }
        }
    }
}

