/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.tracing.tracer;

import com.documentum.tracing.tracer.ScopeStackElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ThreadContext {
    private int m_depthMeter = 0;
    private int m_enabledThreadTrace = 0;
    private int m_inConstructorCount = 0;
    private List m_methodTraceCache;
    private Stack m_monitors = new Stack();
    private Stack m_scopeStack = new Stack();

    public ThreadContext(int stackSize) {
        this.m_methodTraceCache = new ArrayList(stackSize + 1);
        this.m_enabledThreadTrace = 0;
    }

    public int increment() {
        return ++this.m_depthMeter;
    }

    public int decrement() {
        this.m_depthMeter = this.m_depthMeter > 0 ? --this.m_depthMeter : 0;
        return this.m_depthMeter + 1;
    }

    public int getDepth() {
        if (this.m_depthMeter < 0) {
            this.m_depthMeter = 0;
        }
        return this.m_depthMeter;
    }

    public List getMethodTraceCache() {
        return this.m_methodTraceCache;
    }

    public int getEnabledThreadTrace() {
        return this.m_enabledThreadTrace;
    }

    public void enableThreadTrace(boolean enable) {
        this.m_enabledThreadTrace = enable ? --this.m_enabledThreadTrace : ++this.m_enabledThreadTrace;
    }

    public boolean isInConstructor() {
        return this.m_inConstructorCount != 0;
    }

    public void enterConstructor() {
        ++this.m_inConstructorCount;
    }

    public void leaveConstructor() {
        --this.m_inConstructorCount;
    }

    public void pushMonitor(Object monitor) {
        this.m_monitors.push(monitor);
    }

    public void popMonitor() {
        this.m_monitors.pop();
    }

    public Object getCurrentMonitor() {
        if (this.m_monitors.empty()) {
            return null;
        }
        return this.m_monitors.peek();
    }

    public void pushScopeElement(ScopeStackElement element) {
        this.m_scopeStack.push(element);
        element.setLevel(this.m_scopeStack.size());
    }

    public void popScopeElement() {
        if (!this.m_scopeStack.empty()) {
            this.m_scopeStack.pop();
        }
    }

    public ScopeStackElement getCurrentScopeElement() {
        if (this.m_scopeStack.empty()) {
            return null;
        }
        return (ScopeStackElement)this.m_scopeStack.peek();
    }

    public int getCurrentScopeLevel() {
        return this.m_scopeStack.size();
    }

    public boolean isMonitorSet(Object monitor) {
        for (Object existingMonitor : this.m_monitors) {
            if (monitor != existingMonitor) continue;
            return true;
        }
        return false;
    }
}

