/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.tracing.tracer;

import com.documentum.fc.common.DfLogger;
import com.documentum.tracing.core.Parameter;
import com.documentum.tracing.tracer.DfTracer;
import com.documentum.tracing.tracer.IDfTraceInfo;
import com.documentum.tracing.tracer.ThreadContext;

public class MethodInfo
implements IDfTraceInfo {
    private String m_name;
    private int m_type;
    private Parameter[] m_parameters;
    private Class m_methodClass;
    private Object m_called;
    private int m_level;
    private String m_returnType;
    private Throwable m_exception;
    private String m_result;
    private boolean m_printReturnValue;
    private long m_startTime;
    private boolean m_isComplete = false;
    private String m_trCategory;
    private boolean m_isScrambled;

    public MethodInfo(ThreadContext context, String name, int type, Parameter[] parameters, Class methodClass, Object called, int level, String returnType) {
        this.m_name = name;
        this.m_type = type;
        this.m_parameters = parameters;
        this.m_methodClass = methodClass;
        this.m_called = called;
        this.m_level = level;
        this.m_returnType = returnType;
        this.m_trCategory = null;
        this.m_isScrambled = MethodInfo.shouldScrambleRet(name, methodClass.getName());
    }

    public MethodInfo(ThreadContext context, String name, Parameter[] parameters, String trCategory, int level, String returnType) {
        this.m_name = name;
        this.m_type = 0;
        this.m_parameters = parameters;
        this.m_methodClass = null;
        this.m_called = null;
        this.m_level = level;
        this.m_returnType = returnType;
        this.m_trCategory = trCategory;
        this.m_isScrambled = MethodInfo.shouldScrambleRet(name, null);
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public Parameter[] getParameters() {
        return this.m_parameters;
    }

    public Class getMethodClass() {
        return this.m_methodClass;
    }

    public Object getCalled() {
        return this.m_called;
    }

    public int getLevel() {
        return this.m_level;
    }

    public Throwable getException() {
        return this.m_exception;
    }

    public void setException(Throwable exception) {
        this.m_exception = exception;
    }

    public String getResult() {
        return this.m_result;
    }

    public void setResult(String result) {
        this.m_result = this.m_isScrambled ? "******" : result;
        this.m_isComplete = true;
    }

    public boolean isPrintReturnValue() {
        return this.m_printReturnValue;
    }

    public void setPrintReturnValue(boolean printReturnValue) {
        this.m_printReturnValue = printReturnValue;
    }

    public boolean isComplete() {
        return this.m_isComplete;
    }

    public String getCategory() {
        return this.m_trCategory;
    }

    public void print(ThreadContext context) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(DfTracer.getIndent(this.m_level));
        buffer.append(this.printFullMethodSig());
        if (this.isComplete()) {
            buffer.append(" ");
            buffer.append(this.printMethodResult(context));
        } else {
            buffer.append(" [started]");
        }
        String[] values = new String[]{buffer.toString()};
        DfLogger.trace((Object)this.getTraceCategory(), "{0}", values, null);
    }

    public void printMethodExit(ThreadContext context) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(DfTracer.getIndent(this.m_level));
        buffer.append(this.m_name);
        buffer.append(" [finished]");
        buffer.append(" ");
        buffer.append(this.printMethodResult(context));
        String[] values = new String[]{buffer.toString()};
        DfLogger.trace((Object)this.getTraceCategory(), "{0}", values, null);
    }

    private String getTraceCategory() {
        String cat = this.getCalled() != null ? this.getCalled().getClass().getName() : (this.getMethodClass() != null ? this.getMethodClass().getName() : this.getCategory());
        return cat;
    }

    private String printFullMethodSig() {
        StringBuffer buff = new StringBuffer(512);
        if (this.getMethodClass() != null) {
            buff.append(DfTracer.getMethodClassName(this.getMethodClass()));
        }
        if (this.m_called != null) {
            buff.append("@");
            buff.append(Integer.toHexString(System.identityHashCode(this.m_called)));
        }
        buff.append(".");
        buff.append(this.m_name);
        if ((this.m_type & 8) != 0 && (this.m_type & 0x10) != 0) {
            buff.append(" [S SYNCH]");
        } else if ((this.m_type & 8) != 0) {
            buff.append(" [S]");
        } else if ((this.m_type & 0x10) != 0) {
            buff.append(" [SYNCH]");
        }
        if (DfTracer.getRecordParameters()) {
            buff.append(this.printParamInfo());
        }
        return buff.toString();
    }

    private String printParamInfo() {
        StringBuffer buff = new StringBuffer(1024);
        if (this.m_parameters == null || this.m_parameters.length == 0) {
            return "()";
        }
        int paramCount = this.m_parameters.length;
        if (paramCount != 0) {
            buff.append(" (");
            for (int i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    buff.append(", '");
                } else {
                    buff.append("'");
                }
                Parameter param = this.m_parameters[i];
                if (param.getCombine() != null) {
                    buff.append(param.getCombine());
                    continue;
                }
                Object value = param.getValue();
                if (value == null) {
                    buff.append("null");
                } else if (param.isPrimative()) {
                    buff.append(value);
                } else {
                    String type = param.getType();
                    if (type.equals("String") || type.equals("StringBuffer") || type.endsWith("DfId")) {
                        buff.append(value);
                    } else {
                        buff.append(param.getType());
                        buff.append("@");
                        buff.append(Integer.toHexString(System.identityHashCode(value)));
                    }
                }
                buff.append("'");
            }
            buff.append(")");
        }
        return buff.toString();
    }

    private String printMethodResult(ThreadContext context) {
        StringBuffer buff = new StringBuffer(1024);
        if (this.m_exception == null) {
            if (this.m_printReturnValue && DfTracer.getRecordReturnValue()) {
                if (this.m_result != null) {
                    buff.append(this.m_result);
                } else {
                    buff.append(" --> null");
                }
            }
        } else {
            String exceptionMsg = this.m_exception.getMessage();
            exceptionMsg = exceptionMsg != null ? this.m_exception.getClass().getName() + " --> " + exceptionMsg.trim() : this.m_exception.getClass().getName();
            buff.append(" --> Exception occurred: ");
            buff.append(exceptionMsg);
        }
        return buff.toString();
    }

    private static boolean shouldScrambleRet(String methodName, String className) {
        return methodName.indexOf("Password") > -1 || methodName.equals("decode") || className != null && className.equals("com.documentum.fc.client.DfSession") && methodName.equals("getKey");
    }
}

