/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.tracing.tracer;

import com.documentum.fc.common.DfLogger;
import com.documentum.tracing.tracer.DfTracer;
import com.documentum.tracing.tracer.IDfTraceInfo;
import com.documentum.tracing.tracer.ThreadContext;

public class DfMessageInfo
implements IDfTraceInfo {
    private Class m_methodClass;
    private Object m_called;
    private int m_level;
    private String m_trCategory;
    private String m_message;

    public DfMessageInfo(Class methodClass, Object called, int level, String message) {
        this.m_called = called;
        this.m_level = level;
        this.m_methodClass = methodClass;
        this.m_trCategory = null;
        this.m_message = message;
    }

    public DfMessageInfo(String category, int level, String message) {
        this.m_called = null;
        this.m_level = level;
        this.m_methodClass = null;
        this.m_trCategory = category;
        this.m_message = message;
    }

    public void print(ThreadContext context) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(DfTracer.getIndent(this.m_level));
        buffer.append(this.m_message);
        DfLogger.trace((Object)this.getTraceCategory(), "{0}", new String[]{buffer.toString()}, null);
    }

    public boolean isComplete() {
        return true;
    }

    public int getLevel() {
        return this.m_level;
    }

    private String getTraceCategory() {
        String cat = this.getCalled() != null ? this.getCalled().getClass().getName() : (this.getMethodClass() != null ? this.getMethodClass().getName() : this.getCategory());
        return cat;
    }

    public Object getCalled() {
        return this.m_called;
    }

    public Class getMethodClass() {
        return this.m_methodClass;
    }

    public String getCategory() {
        return this.m_trCategory;
    }
}

