/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.tracing.tracer;

import com.documentum.fc.common.DfLogger;
import com.documentum.tracing.tracer.DfTracer;
import com.documentum.tracing.tracer.IDfTraceInfo;
import com.documentum.tracing.tracer.ThreadContext;

public class DfExceptionInfo
implements IDfTraceInfo {
    private int m_accMode;
    private Class m_methodClass;
    private Object m_called;
    private Throwable m_exception;
    private String m_exceptionType;
    private int m_level;

    public DfExceptionInfo(Class methodClass, Object called, int accType, int level, Throwable e, String exceptionType) {
        this.m_accMode = accType;
        this.m_methodClass = methodClass;
        this.m_called = called;
        this.m_exception = e;
        this.m_exceptionType = exceptionType;
        this.m_level = level;
    }

    public boolean isComplete() {
        return true;
    }

    public int getLevel() {
        return this.m_level;
    }

    private String getTraceCategory() {
        String cat = this.getCalled() != null ? this.getCalled().getClass().getName() : this.getMethodClass().getName();
        return cat;
    }

    public void print(ThreadContext context) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(DfTracer.getIndent(this.m_level));
        buffer.append(this.m_exception.getMessage());
        buffer.append(this.m_exceptionType);
        DfLogger.trace((Object)this.getTraceCategory(), "{0}", new String[]{buffer.toString()}, null);
    }

    public Object getCalled() {
        return this.m_called;
    }

    public Class getMethodClass() {
        return this.m_methodClass;
    }
}

