/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.thirdparty.javassist.convert;

import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.CtMethod;
import com.documentum.thirdparty.javassist.bytecode.BadBytecode;
import com.documentum.thirdparty.javassist.bytecode.CodeAttribute;
import com.documentum.thirdparty.javassist.bytecode.CodeIterator;
import com.documentum.thirdparty.javassist.bytecode.ConstPool;
import com.documentum.thirdparty.javassist.convert.Transformer;

public class TransformCall
extends Transformer {
    protected String classname;
    protected String methodname;
    protected String methodDescriptor;
    protected String newClassname;
    protected String newMethodname;
    protected int newIndex;
    protected ConstPool constPool;

    public TransformCall(Transformer next, CtMethod origMethod, CtMethod substMethod) {
        super(next);
        this.classname = origMethod.getDeclaringClass().getName();
        this.methodname = origMethod.getName();
        this.methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
        this.newClassname = substMethod.getDeclaringClass().getName();
        this.newMethodname = substMethod.getName();
        this.constPool = null;
    }

    public void initialize(ConstPool cp, CodeAttribute attr) {
        if (this.constPool != cp) {
            this.newIndex = 0;
        }
    }

    public int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        int index;
        int typedesc;
        int c = iterator.byteAt(pos);
        if ((c == 185 || c == 183 || c == 184 || c == 182) && (typedesc = cp.isMember(this.classname, this.methodname, index = iterator.u16bitAt(pos + 1))) != 0 && cp.getUtf8Info(typedesc).equals(this.methodDescriptor)) {
            pos = this.match(c, pos, iterator, typedesc, cp);
        }
        return pos;
    }

    protected int match(int c, int pos, CodeIterator iterator, int typedesc, ConstPool cp) throws BadBytecode {
        if (this.newIndex == 0) {
            int nt = cp.addNameAndTypeInfo(cp.addUtf8Info(this.newMethodname), typedesc);
            int ci = cp.addClassInfo(this.newClassname);
            this.newIndex = c == 185 ? cp.addInterfaceMethodrefInfo(ci, nt) : cp.addMethodrefInfo(ci, nt);
            this.constPool = cp;
        }
        iterator.write16bit(this.newIndex, pos + 1);
        return pos;
    }
}

