/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.thirdparty.javassist.bytecode.annotation;

import com.documentum.thirdparty.javassist.ClassPool;
import com.documentum.thirdparty.javassist.CtClass;
import com.documentum.thirdparty.javassist.NotFoundException;
import com.documentum.thirdparty.javassist.bytecode.AnnotationDefaultAttribute;
import com.documentum.thirdparty.javassist.bytecode.ClassFile;
import com.documentum.thirdparty.javassist.bytecode.MethodInfo;
import com.documentum.thirdparty.javassist.bytecode.annotation.Annotation;
import com.documentum.thirdparty.javassist.bytecode.annotation.MemberValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AnnotationImpl
implements InvocationHandler {
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;

    public static Object make(ClassLoader cl, Class clazz, ClassPool cp, Annotation anon) {
        AnnotationImpl handler = new AnnotationImpl(anon, cp, cl);
        return Proxy.newProxyInstance(cl, new Class[]{clazz}, (InvocationHandler)handler);
    }

    private AnnotationImpl(Annotation a, ClassPool cp, ClassLoader loader) {
        this.annotation = a;
        this.pool = cp;
        this.classLoader = loader;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MemberValue mv;
        String name = method.getName();
        if (Object.class == method.getDeclaringClass()) {
            if ("equals".equals(name)) {
                Object obj = args[0];
                if (obj == null || !(obj instanceof Proxy)) {
                    return Boolean.FALSE;
                }
                InvocationHandler other = Proxy.getInvocationHandler(obj);
                if (this.equals(other)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("toString".equals(name)) {
                return this.annotation.getTypeName() + '@' + this.hashCode();
            }
            if ("hashCode".equals(name)) {
                return new Integer(this.hashCode());
            }
        } else if ("annotationType".equals(name) && method.getParameterTypes().length == 0) {
            return this.classLoader.loadClass(this.getTypeName());
        }
        if ((mv = this.annotation.getMemberValue(name)) == null) {
            return this.getDefault(name, method);
        }
        return mv.getValue(this.classLoader, this.pool, method);
    }

    private Object getDefault(String name, Method method) throws ClassNotFoundException, RuntimeException {
        String classname = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute ainfo;
                CtClass cc = this.pool.get(classname);
                ClassFile cf = cc.getClassFile2();
                MethodInfo minfo = cf.getMethod(name);
                if (minfo != null && (ainfo = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault")) != null) {
                    MemberValue mv = ainfo.getDefaultValue();
                    return mv.getValue(this.classLoader, this.pool, method);
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException("cannot find a class file: " + classname);
            }
        }
        throw new RuntimeException("no default value: " + classname + "." + name + "()");
    }
}

