/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.registry;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import com.documentum.registry.IDfHouseKeepingObject;
import com.documentum.registry.IDfRegistry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DfHouseKeepingObject
implements IDfHouseKeepingObject {
    private IDfRegistry m_registry;
    private static final String VALUE_NAME_DAYS_TO_KEEP_VIEWED_FILES = "DaysToKeepViewedFiles";
    private static final String VALUE_NAME_LAST_HOUSE_KEEPING = "LastHouseKeeping";
    private static final String VALUE_NAME_NUM_OF_DAYS = "NumberOfDays";
    private static final SimpleDateFormat HOUSE_KEEPING_DATE_FORMAT;
    private static final Object MUTEX_HOUSE_KEEPING_DATE_FORMAT;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public DfHouseKeepingObject(IDfRegistry registry) {
        IDfRegistry iDfRegistry = registry;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfRegistry);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_registry = registry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfRegistry);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfRegistry);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Calendar getLastHouseKeeping() throws DfException {
        JoinPoint joinPoint = null;
        try {
            Object object;
            Object object2;
            Object object3;
            block22: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (this.m_registry == null) {
                    object2 = object3 = null;
                } else {
                    Object object4;
                    this.m_registry.openKey("Common\\HouseKeeping");
                    String dateInUSFormat = this.m_registry.getStringValue(VALUE_NAME_LAST_HOUSE_KEEPING);
                    if (dateInUSFormat == null) {
                        this.setLastHouseKeeping();
                        Object object5 = null;
                        object2 = object3 = object5;
                        break block22;
                    }
                    Calendar c = Calendar.getInstance();
                    if (dateInUSFormat.length() != 8) {
                        c.add(2, -1);
                    } else {
                        try {
                            object4 = MUTEX_HOUSE_KEEPING_DATE_FORMAT;
                            synchronized (object4) {
                                c.setTime(HOUSE_KEEPING_DATE_FORMAT.parse(dateInUSFormat));
                            }
                        }
                        catch (ParseException e) {
                            c.add(2, -1);
                        }
                    }
                    object4 = c;
                    object2 = object3 = object4;
                }
                break block22;
                finally {
                    if (this.m_registry != null) {
                        this.m_registry.closeKey();
                    }
                }
            }
            Object object6 = object = object2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return object3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHouseKeepingFrequency() throws DfException {
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            int n3;
            block17: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (this.m_registry == null) {
                    n2 = n3 = -1;
                } else {
                    int houseKeepingInterval = DfPreferences.getInstance().getHousekeepingInterval();
                    if (houseKeepingInterval > 0) {
                        n2 = n3 = houseKeepingInterval;
                    } else {
                        this.m_registry.openKey("Common\\HouseKeeping");
                        String noOfDaysAsStr = this.m_registry.getStringValue(VALUE_NAME_NUM_OF_DAYS);
                        if (noOfDaysAsStr != null && noOfDaysAsStr.length() > 0) {
                            int n4 = new Integer(noOfDaysAsStr);
                            n2 = n3 = n4;
                            break block17;
                        }
                        int n5 = -1;
                        n2 = n3 = n5;
                    }
                }
                break block17;
                finally {
                    this.m_registry.closeKey();
                }
            }
            int n6 = n = n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getViewedFilesCleanupFrequency() throws DfException {
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            int n3;
            block18: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (this.m_registry == null) {
                    n2 = n3 = 0;
                } else {
                    int viewedFileRetentionPeriod = DfPreferences.getInstance().getHousekeepingViewedFileRetentionPeriod();
                    if (viewedFileRetentionPeriod > 0) {
                        n2 = n3 = viewedFileRetentionPeriod;
                    } else {
                        this.m_registry.openKey("Common\\HouseKeeping");
                        String noOfDaysAsStr = this.m_registry.getStringValue(VALUE_NAME_DAYS_TO_KEEP_VIEWED_FILES);
                        if (noOfDaysAsStr != null && noOfDaysAsStr.length() > 0) {
                            int n4 = new Integer(noOfDaysAsStr);
                            n2 = n3 = n4;
                            break block18;
                        }
                        int n5 = -1;
                        n2 = n3 = n5;
                    }
                }
                break block18;
                finally {
                    if (this.m_registry != null) {
                        this.m_registry.closeKey();
                    }
                }
            }
            int n6 = n = n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastHouseKeeping() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_registry != null) {
                try {
                    Object object = MUTEX_HOUSE_KEEPING_DATE_FORMAT;
                    synchronized (object) {
                        this.m_registry.openKey("Common\\HouseKeeping");
                        this.m_registry.setStringValue(VALUE_NAME_LAST_HOUSE_KEEPING, HOUSE_KEEPING_DATE_FORMAT.format(new Date()));
                    }
                }
                finally {
                    this.m_registry.closeKey();
                }
            }
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfHouseKeepingObject.java", Class.forName("com.documentum.registry.DfHouseKeepingObject"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastHouseKeeping", "com.documentum.registry.DfHouseKeepingObject", "", "", "com.documentum.fc.common.DfException:", "java.util.Calendar"), 34);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHouseKeepingFrequency", "com.documentum.registry.DfHouseKeepingObject", "", "", "com.documentum.fc.common.DfException:", "int"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getViewedFilesCleanupFrequency", "com.documentum.registry.DfHouseKeepingObject", "", "", "com.documentum.fc.common.DfException:", "int"), 121);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLastHouseKeeping", "com.documentum.registry.DfHouseKeepingObject", "", "", "com.documentum.fc.common.DfException:", "void"), 151);
        ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.registry.DfHouseKeepingObject", "com.documentum.registry.IDfRegistry:", "registry:", ""), 28);
        HOUSE_KEEPING_DATE_FORMAT = new SimpleDateFormat("MMddyyyy");
        MUTEX_HOUSE_KEEPING_DATE_FORMAT = new Object();
    }
}

