/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.triggers.ThreadComparator;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class ThreadNameTrigger
extends TracingTriggerAdapter {
    private Pattern m_pattern;
    private Map<Thread, Boolean> m_threadsToTrace;

    public ThreadNameTrigger(Pattern pattern) {
        DfLogger.debug((Object)this, "Creating ThreadNameTrigger -- pattern: {0}", new String[]{pattern.pattern()}, null);
        this.m_pattern = pattern;
        this.m_threadsToTrace = new TreeMap<Thread, Boolean>(ThreadComparator.COMPARATOR);
    }

    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        boolean retval;
        Thread curThread = Thread.currentThread();
        Boolean value = this.m_threadsToTrace.get(curThread);
        if (value != null) {
            retval = this.isNextTriggered(tracer, context, value, isEntrance);
        } else {
            retval = this.m_pattern.matcher(curThread.getName()).matches();
            this.m_threadsToTrace.put(curThread, retval);
            retval = this.isNextTriggered(tracer, context, retval, isEntrance);
        }
        return retval;
    }
}

