/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.ThreadTraceContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.triggers.MethodFilterMatcher;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;

public class MethodFilterTrigger
extends TracingTriggerAdapter {
    private boolean m_printStackOnMethodMatch;
    private MethodFilterMatcher m_matcher;

    public MethodFilterTrigger(String[] methodFilterExprs, boolean printStackOnMethodMatch) {
        if (DfLogger.isDebugEnabled(this)) {
            StringBuilder b = new StringBuilder(128);
            b.append("Creating MethodFilterTrigger -- exprs: ");
            String prefix = "\"";
            for (String s : methodFilterExprs) {
                b.append(prefix).append(s).append('\"');
                prefix = ", \"";
            }
            b.append("; printStackOnMethodMatch: ").append(printStackOnMethodMatch);
            DfLogger.debug((Object)this, b.toString(), null, null);
        }
        this.m_matcher = new MethodFilterMatcher(methodFilterExprs);
        this.m_printStackOnMethodMatch = printStackOnMethodMatch;
    }

    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        boolean retval;
        ThreadTraceContext threadContext = tracer.getThreadTraceContext();
        boolean alreadyMarked = threadContext.isDepthMarked();
        if (alreadyMarked || this.m_matcher.matches(context.getTargetClassName(), context.getMethodName())) {
            retval = this.isNextTriggered(tracer, context, true, isEntrance);
            if (!alreadyMarked) {
                threadContext.markCallDepth();
                if (retval && isEntrance && this.m_printStackOnMethodMatch) {
                    this.logStackTrace(context);
                }
            }
        } else {
            retval = false;
        }
        return retval;
    }

    private void logStackTrace(MethodContext context) {
        String methodName = context.getMethodName();
        Exception e = new Exception("EXCEPTION TO GET CALL STACK");
        StackTraceElement[] elems = e.getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            if (!elems[i].getMethodName().equals(methodName)) continue;
            int len = elems.length - i;
            StackTraceElement[] newElems = new StackTraceElement[len];
            System.arraycopy(elems, i, newElems, 0, len);
            e.setStackTrace(newElems);
            break;
        }
        DfLogger.debug((Object)context.getTargetClass(), "{0}.{1}() Entered.  The current call stack is:", new String[]{context.getTargetClassName(), methodName}, (Throwable)e);
    }
}

