/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

class MethodFilterMatcher {
    private InternalMatcher[] m_matchers;

    public MethodFilterMatcher(String[] entrancePoints) {
        this.init(entrancePoints);
    }

    public boolean matches(String className, String method) {
        for (InternalMatcher m : this.m_matchers) {
            if (!m.matches(className, method)) continue;
            return true;
        }
        return false;
    }

    private void init(String[] entrancePointExprs) {
        int length = entrancePointExprs.length;
        this.m_matchers = new InternalMatcher[length];
        for (int i = 0; i < length; ++i) {
            String expr = entrancePointExprs[i];
            if (expr == null || expr.length() == 0) {
                throw new IllegalArgumentException("Bad entrance point expression: " + expr);
            }
            this.m_matchers[i] = this.createMatcher(expr);
        }
    }

    private InternalMatcher createMatcher(String expr) {
        SimpleMatcher classNameMatcher;
        SimpleMatcher methodMatcher = null;
        int last = expr.length() - 1;
        switch (expr.charAt(last)) {
            case '*': {
                classNameMatcher = this.createClassNameMatcher(expr.substring(0, last - 1), true);
                break;
            }
            case ')': {
                MatcherPair p = this.splitExpr(expr, last);
                classNameMatcher = p.classNameMatcher;
                methodMatcher = p.methodMatcher;
                break;
            }
            default: {
                classNameMatcher = this.createClassNameMatcher(expr, false);
            }
        }
        InternalMatcher retval = classNameMatcher != null ? (methodMatcher == null ? new ClassNameMatcher(classNameMatcher) : new ClassAndMethodNameMatcher(classNameMatcher, methodMatcher)) : new MethodNameMatcher(methodMatcher);
        return retval;
    }

    private SimpleMatcher createClassNameMatcher(String expr, boolean hasWildCardEnding) {
        if (expr.indexOf(42) >= 0) {
            throw new IllegalArgumentException("Wildcard '*' must appear only on right-hand side of classname expression");
        }
        if (hasWildCardEnding) {
            return new StartsWithMatcher(expr);
        }
        return new ExactMatcher(expr);
    }

    private SimpleMatcher createMethodMatcher(String expr) {
        boolean hasWildCard = expr.endsWith("*");
        if (hasWildCard) {
            expr = expr.substring(0, expr.length() - 1);
        }
        if (expr.length() == 0) {
            return null;
        }
        if (expr.indexOf(42) >= 0) {
            throw new IllegalArgumentException("Wildcards are allowed only on the left-hand side of method expressions");
        }
        if (hasWildCard) {
            return new StartsWithMatcher(expr);
        }
        return new ExactMatcher(expr);
    }

    private MatcherPair splitExpr(String expr, int indexLastChar) {
        int rightMostDotIndex = expr.lastIndexOf(46);
        if (expr.length() < 5 || expr.charAt(indexLastChar - 1) != '(' || rightMostDotIndex < 0) {
            throw new IllegalArgumentException("Unrecognized expression: " + expr);
        }
        MatcherPair retval = new MatcherPair();
        String classExpr = expr.substring(0, rightMostDotIndex);
        if (classExpr.length() > 0 && !classExpr.equals("*")) {
            retval.classNameMatcher = classExpr.charAt(rightMostDotIndex - 1) == '*' ? this.createClassNameMatcher(classExpr.substring(0, rightMostDotIndex - 1), true) : this.createClassNameMatcher(classExpr, false);
        }
        String method = expr.substring(rightMostDotIndex + 1, indexLastChar - 1);
        retval.methodMatcher = this.createMethodMatcher(method);
        return retval;
    }

    static class ExactMatcher
    implements SimpleMatcher {
        private String m_equals;

        public ExactMatcher(String s) {
            this.m_equals = s;
        }

        public boolean matches(String s) {
            return this.m_equals.equals(s);
        }

        public String getPattern() {
            return this.m_equals;
        }
    }

    static class StartsWithMatcher
    implements SimpleMatcher {
        private String m_startsWith;

        public StartsWithMatcher(String s) {
            this.m_startsWith = s;
        }

        public boolean matches(String s) {
            return s != null && s.startsWith(this.m_startsWith);
        }

        public String getPattern() {
            return this.m_startsWith + "*";
        }
    }

    static interface SimpleMatcher {
        public boolean matches(String var1);

        public String getPattern();
    }

    static class ClassAndMethodNameMatcher
    implements InternalMatcher {
        private SimpleMatcher m_classNameMatcher;
        private SimpleMatcher m_methodNameMatcher;

        public ClassAndMethodNameMatcher(SimpleMatcher classNameMatcher, SimpleMatcher methodNameMatcher) {
            this.m_classNameMatcher = classNameMatcher;
            this.m_methodNameMatcher = methodNameMatcher;
        }

        public boolean matches(String className, String method) {
            return this.m_classNameMatcher.matches(className) && this.m_methodNameMatcher.matches(method);
        }
    }

    static class MethodNameMatcher
    implements InternalMatcher {
        private SimpleMatcher m_methodNameMatcher;

        public MethodNameMatcher(SimpleMatcher methodNameMatcher) {
            this.m_methodNameMatcher = methodNameMatcher;
        }

        public boolean matches(String className, String method) {
            return this.m_methodNameMatcher.matches(method);
        }
    }

    static class ClassNameMatcher
    implements InternalMatcher {
        private SimpleMatcher m_classNameMatcher;

        public ClassNameMatcher(SimpleMatcher classNameMatcher) {
            this.m_classNameMatcher = classNameMatcher;
        }

        public boolean matches(String className, String method) {
            return this.m_classNameMatcher.matches(className);
        }
    }

    static interface InternalMatcher {
        public boolean matches(String var1, String var2);
    }

    static class MatcherPair {
        public SimpleMatcher classNameMatcher = null;
        public SimpleMatcher methodMatcher = null;

        MatcherPair() {
        }
    }
}

