/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.triggers;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.Tracer;
import com.documentum.fc.tracing.impl.triggers.ThreadComparator;
import com.documentum.fc.tracing.impl.triggers.TracingTriggerAdapter;
import java.util.TreeMap;

public final class MaxThreadsTrigger
extends TracingTriggerAdapter {
    private int m_maxThreads;
    private final TreeMap<Thread, Boolean> m_threadsTraced;

    public MaxThreadsTrigger(int maxThreads) {
        DfLogger.debug((Object)this, "Creating MaxThreadsTrigger -- maxThreads: {0}", new Object[]{maxThreads}, null);
        this.m_maxThreads = maxThreads;
        this.m_threadsTraced = new TreeMap(ThreadComparator.COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTriggered(Tracer tracer, MethodContext context, boolean isEntrance) {
        boolean retval;
        Boolean found;
        Thread t = Thread.currentThread();
        TreeMap<Thread, Boolean> treeMap = this.m_threadsTraced;
        synchronized (treeMap) {
            found = this.m_threadsTraced.get(t);
        }
        if (found != null) {
            retval = this.isNextTriggered(tracer, context, found, isEntrance);
        } else {
            boolean shouldTrace;
            TreeMap<Thread, Boolean> treeMap2 = this.m_threadsTraced;
            synchronized (treeMap2) {
                shouldTrace = this.m_threadsTraced.size() < this.m_maxThreads;
                this.m_threadsTraced.put(t, shouldTrace);
            }
            retval = this.isNextTriggered(tracer, context, shouldTrace, isEntrance);
        }
        return retval;
    }

    protected void resetThis() {
        this.m_threadsTraced.clear();
    }
}

