/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.aspects;

import com.documentum.fc.client.IDfSessionManager;
import com.documentum.fc.tracing.IUserIdentifyingObject;
import com.documentum.fc.tracing.impl.MethodContext;
import com.documentum.fc.tracing.impl.RpcContext;
import com.documentum.fc.tracing.impl.Tracing;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import java.lang.reflect.AnnotatedElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TracingAspect
extends BaseTracingAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ TracingAspect ajc$perSingletonInstance;

    static {
        try {
            TracingAspect.ajc$perSingletonInstance = new TracingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    protected void handleEntrance(JoinPoint jp, boolean annotated, boolean exclude, boolean rpc) {
        Signature signature = jp.getSignature();
        Object target = jp.getTarget();
        Class type = signature.getDeclaringType();
        String method = signature.getName();
        AnnotatedElement element = annotated ? this.getAnnotatedElement(signature) : null;
        Object[] args = jp.getArgs();
        IUserIdentifyingObject uio = TracingAspect.chooseIdentifyingObject(signature, target, args, null);
        if (rpc) {
            Tracing.traceRpcEntrance(new RpcContext(target, type, method, element, uio, exclude, args));
        } else {
            Tracing.traceMethodEntrance(new MethodContext(target, type, method, element, uio, exclude, args));
        }
    }

    private AnnotatedElement getAnnotatedElement(Signature signature) {
        if (signature instanceof MethodSignature) {
            return ((MethodSignature)signature).getMethod();
        }
        return ((ConstructorSignature)signature).getConstructor();
    }

    protected void handleExit(JoinPoint jp, Object result, boolean annotated, boolean exclude, boolean rpc) {
        Signature signature = jp.getSignature();
        Object target = jp.getTarget();
        Class type = signature.getDeclaringType();
        String method = signature.getName();
        AnnotatedElement element = annotated ? this.getAnnotatedElement(signature) : null;
        IUserIdentifyingObject uio = TracingAspect.chooseIdentifyingObject(signature, target, null, result);
        Class returnType = null;
        returnType = signature instanceof MethodSignature ? ((MethodSignature)signature).getReturnType() : Void.TYPE;
        if (rpc) {
            Tracing.traceRpcExit(new RpcContext(target, type, method, element, uio, exclude, result, returnType));
        } else {
            Tracing.traceMethodExit(new MethodContext(target, type, method, element, uio, exclude, result, returnType));
        }
    }

    protected void handleException(JoinPoint jp, Throwable t, boolean annotated, boolean exclude, boolean rpc) {
        Signature signature = jp.getSignature();
        Object target = jp.getTarget();
        Class type = signature.getDeclaringType();
        String method = signature.getName();
        AnnotatedElement element = annotated ? this.getAnnotatedElement(signature) : null;
        IUserIdentifyingObject uio = TracingAspect.chooseIdentifyingObject(signature, target, null, null);
        if (rpc) {
            Tracing.traceRpcException(new RpcContext(target, type, method, element, uio, exclude, t));
        } else {
            Tracing.traceMethodException(new MethodContext(target, type, method, element, uio, exclude, t));
        }
    }

    private static IUserIdentifyingObject chooseIdentifyingObject(Signature signature, Object target, Object[] args, Object result) {
        if (signature instanceof ConstructorSignature) {
            target = null;
        }
        if (target != null && target instanceof IUserIdentifyingObject && !(target instanceof IDfSessionManager)) {
            return (IUserIdentifyingObject)target;
        }
        if (args != null) {
            Object[] objectArray = args;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object arg = objectArray[n];
                if (arg instanceof IUserIdentifyingObject) {
                    return (IUserIdentifyingObject)arg;
                }
                ++n;
            }
        }
        if (result != null && result instanceof IUserIdentifyingObject) {
            return (IUserIdentifyingObject)result;
        }
        if (target != null && target instanceof IUserIdentifyingObject) {
            return (IUserIdentifyingObject)target;
        }
        return null;
    }

    @Before(value="((genericMethod() || genericCtor()) && (excludedFromTrace() && (!excludedFromInstr() && isTracingEnabled())))", argNames="")
    public void ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$1$c84a349f(JoinPoint thisJoinPoint) {
        this.handleEntrance(thisJoinPoint, false, true, false);
    }

    @Before(value="((genericMethod() || genericCtor()) && (!excludedFromTrace() && (hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", argNames="")
    public void ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$2$3a1af18d(JoinPoint thisJoinPoint) {
        this.handleEntrance(thisJoinPoint, true, false, false);
    }

    @Before(value="((genericMethod() || genericCtor()) && (!excludedFromTrace() && (!hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", argNames="")
    public void ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(JoinPoint thisJoinPoint) {
        this.handleEntrance(thisJoinPoint, false, false, false);
    }

    @AfterReturning(pointcut="(genericCtor() && (excludedFromTrace() && (!excludedFromInstr() && isTracingEnabled())))", returning="", argNames="")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$4$996d40d(JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, null, false, true, false);
    }

    @AfterReturning(pointcut="(genericCtor() && (!excludedFromTrace() && (hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", returning="", argNames="")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$5$151870df(JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, null, true, false, false);
    }

    @AfterReturning(pointcut="(genericCtor() && (!excludedFromTrace() && (!hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", returning="", argNames="")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, null, false, false, false);
    }

    @AfterReturning(pointcut="(genericMethod() && (excludedFromTrace() && (!excludedFromInstr() && isTracingEnabled())))", returning="result", argNames="result")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$7$ee18b79a(Object result, JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, result, false, true, false);
    }

    @AfterReturning(pointcut="(genericMethod() && (!excludedFromTrace() && (hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", returning="result", argNames="result")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$8$a77ff472(Object result, JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, result, true, false, false);
    }

    @AfterReturning(pointcut="(genericMethod() && (!excludedFromTrace() && (!hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", returning="result", argNames="result")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(Object result, JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, result, false, false, false);
    }

    @AfterThrowing(pointcut="((genericMethod() || genericCtor()) && (excludedFromTrace() && (!excludedFromInstr() && isTracingEnabled())))", throwing="t", argNames="t")
    public void ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$10$c84a349f(Throwable t, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, t, false, true, false);
    }

    @AfterThrowing(pointcut="((genericMethod() || genericCtor()) && (!excludedFromTrace() && (hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", throwing="t", argNames="t")
    public void ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$11$3a1af18d(Throwable t, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, t, true, false, false);
    }

    @AfterThrowing(pointcut="((genericMethod() || genericCtor()) && (!excludedFromTrace() && (!hasTracingAnnotation() && (!excludedFromInstr() && isTracingEnabled()))))", throwing="t", argNames="t")
    public void ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(Throwable t, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, t, false, false, false);
    }

    @Before(value="(rpcMethod() && isTracingEnabled())", argNames="")
    public void ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(JoinPoint thisJoinPoint) {
        this.handleEntrance(thisJoinPoint, false, false, true);
    }

    @AfterReturning(pointcut="(rpcMethod() && isTracingEnabled())", returning="result", argNames="result")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(Object result, JoinPoint thisJoinPoint) {
        this.handleExit(thisJoinPoint, result, false, false, true);
    }

    @AfterThrowing(pointcut="(rpcMethod() && isTracingEnabled())", throwing="t", argNames="t")
    public void ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(Throwable t, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, t, false, false, true);
    }

    @Before(value="specialCtor()", argNames="")
    public void ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$16$afa5902e() {
        Tracing.setMuted(true);
    }

    @AfterReturning(pointcut="specialCtor()", returning="", argNames="")
    public void ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$17$afa5902e() {
        Tracing.setMuted(false);
    }

    @AfterThrowing(pointcut="specialCtor()", throwing="t", argNames="t")
    public void ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$18$afa5902e(Throwable t) {
        Tracing.setMuted(false);
    }

    public static TracingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com_documentum_fc_tracing_impl_aspects_TracingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

