/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.tracing.impl.appenders;

import com.documentum.fc.common.DfLogger;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiplexingAppender<T>
extends AppenderSkeleton {
    protected TreeMap<T, RollingFileAppender> m_mapAppenders;
    protected Layout m_layout;
    protected String m_basePath;
    protected String m_maxFileSize;
    protected int m_maxBackupIndex;

    public MultiplexingAppender() {
        Comparator<T> c = this.getComparator();
        this.m_mapAppenders = c == null ? new TreeMap() : new TreeMap(c);
    }

    protected Comparator<T> getComparator() {
        return null;
    }

    protected void append(LoggingEvent loggingEvent) {
        this.getAppender(loggingEvent).doAppend(loggingEvent);
    }

    public void doAppend(LoggingEvent loggingEvent) {
        this.getAppender(loggingEvent).doAppend(loggingEvent);
    }

    public void close() {
        for (RollingFileAppender a : this.m_mapAppenders.values()) {
            a.close();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.m_basePath = baseFilePath;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.m_maxFileSize = maxFileSize;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.m_maxBackupIndex = maxBackupIndex;
    }

    public void setLayout(Layout layout) {
        this.m_layout = layout;
        super.setLayout(layout);
    }

    protected Appender getAppender(LoggingEvent event) {
        T key;
        try {
            key = this.getKeyFromEvent(event);
        }
        catch (ClassCastException cce) {
            return new BitBucketAppender();
        }
        Object a = (Appender)this.m_mapAppenders.get(key);
        if (a == null) {
            try {
                String fileName = this.m_basePath + "." + this.getMultiplexedExtension(key) + ".log";
                RollingFileAppender ra = new RollingFileAppender();
                ra.setFile(fileName, false, false, 0);
                ra.setMaxFileSize(this.m_maxFileSize);
                ra.setMaxBackupIndex(this.m_maxBackupIndex);
                ra.setLayout(this.m_layout);
                ra.setEncoding("UTF-8");
                this.m_mapAppenders.put(key, ra);
                a = ra;
            }
            catch (IOException ioe) {
                a = new BitBucketAppender();
                DfLogger.error((Object)this, "Unable to create appender for {0}", new String[]{this.getMultiplexedExtension(key)}, (Throwable)ioe);
            }
        }
        return a;
    }

    protected abstract T getKeyFromEvent(LoggingEvent var1);

    protected abstract String getMultiplexedExtension(T var1);

    static class BitBucketAppender
    extends AppenderSkeleton {
        BitBucketAppender() {
        }

        public void append(LoggingEvent event) {
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

